<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BomSizeController extends Controller
{

    public function FormInsert($pdtCode, $sizeCode)
    {
        $product = DB::table('tmstmproduct')
            ->where('xvpdtcode', '=', $pdtCode)
            ->first();
        $mat_unit = DB::table('tmstmmat_unit')
            ->join('TMstMMaterial', 'tmstmmat_unit.xvmatcode', 'TMstMMaterial.xvmatcode')
            ->leftjoin('tmstmunit', 'tmstmunit.xvuntcode', 'tmstmmat_unit.xvuntcode')
            ->get()->toArray();

        //check if have size select it
        $item = $this->getRecepie($pdtCode, $sizeCode);

        $data = [
            'Material' => $mat_unit,
            'Product' => $product,
            'oldItem' => $item,
            'sizeCode' => $sizeCode
        ];
        return view('BomSize.frm_add', $data);
    }

    public function Recepie($pdtCode, $sizeCode = null)
    {
        return response()->json([
            'bom' => $this->getRecepie($pdtCode, $sizeCode)
        ]);
    }

    public function getRecepie($pdtCode, $sizeCode)
    {
        if ($sizeCode != null) {
            $item = DB::table('tmstmbomsize')
                ->where('xvpdtcode', '=', $pdtCode)
                ->where('XVPszName', '=', $sizeCode)
                ->join('TMstMMaterial', 'tmstmbomsize.xvmatcode', 'TMstMMaterial.xvmatcode')
                ->leftjoin('tmstmunit', 'tmstmbomsize.xvuntcode', 'tmstmunit.xvuntcode')
                ->get();
            if (count($item) <= 0) {
                $item = DB::table('tmstmbom')
                    ->where('xvpdtcode', '=', $pdtCode)
                    ->join('TMstMMaterial', 'tmstmbom.xvmatcode', 'TMstMMaterial.xvmatcode')
                    ->leftjoin('tmstmunit', 'tmstmbom.xvuntcode', 'tmstmunit.xvuntcode')
                    ->get();
            }
        } else {
            $item = DB::table('tmstmbom')
                ->where('xvpdtcode', '=', $pdtCode)
                ->join('TMstMMaterial', 'tmstmbom.xvmatcode', 'TMstMMaterial.xvmatcode')
                ->leftjoin('tmstmunit', 'tmstmbom.xvuntcode', 'tmstmunit.xvuntcode')
                ->get();
        }
        return $item;
    }

    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            DB::table('tmstmbomsize')
                ->where('xvpdtcode', '=', $request->xvpdtcode)
                ->where('XVPszName', '=', $request->XVPszName)
                ->delete();
            for ($i = 0; $i < count($request->xvmatcode); $i++) {
                DB::table('tmstmbomsize')->insert([
                    'xvpdtcode' => $request->xvpdtcode,
                    'XVPszName' => $request->XVPszName,
                    'xvmatcode' => $request->xvmatcode[$i],
                    'xvuntcode' => $request->xvuntcode[$i],
                    'XIBomQty' => intval($request->XIBomQty[$i]),
                ]);
            }
            DB::commit();
            return redirect()->route('product.index')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }
}
