<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CustomerController extends Controller
{
    public function index()
    {
        $customers = DB::table('tmstmcustomer')->orderBy('XVCstCode', 'DESC')->get()->toArray();
        $data = [
            'csts' => $customers
        ];
        return view('customer.index', $data);
    }

    public function addCustomer(Request $request)
    {
        DB::beginTransaction();
        try {
            $isDuplicate = $this->checkNameDuplicate($request->XVCstName);
            if($isDuplicate){
                return redirect()->route('customer')->with('msg', 'Duplicate');
            }
            $code = GeneratePrimaryKeyDate('tmstmcustomer','XVCstCode','Cst');
            DB::table('tmstmcustomer')->insert([
                'XVCstCode' => $code,
                'XVCstName' => $request->XVCstName,
                'XVCstTaxID' => $request->XVCstTaxID,
                'XVCstAddress' => $request->XVCstAddress,
                'XVCstContacName' => $request->XVCstContacName,
                'XVCstEmail' => $request->XVCstEmail,
                'XVCstPhone' => $request->XVCstPhone,
                'XVCstFax' => $request->XVCstFax
            ]);
            DB::commit();

            return redirect()->route('customer')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function frmEdit($id)
    {
        $cst = $this->getCst()->where('XVCstCode', $id)->first();
        $data = [
            'cst' => $cst
        ];
        return view('customer.form_edit_customer', $data);
    }

    public function editCustomer(Request $request)
    {

        DB::beginTransaction();
        try {
            $isDuplicate = $this->checkNameDuplicate($request->XVCstName);
            if($isDuplicate){
                return redirect()->route('customer')->with('msg', 'Duplicate');
            }
            DB::table('tmstmcustomer')->where('XVCstCode', $request->XVCstCode)
                ->update([
                    'XVCstCode' => $request->XVCstCode,
                    'XVCstName' => $request->XVCstName,
                    'XVCstTaxID' => $request->XVCstTaxID,
                    'XVCstAddress' => $request->XVCstAddress,
                    'XVCstContacName' => $request->XVCstContacName,
                    'XVCstEmail' => $request->XVCstEmail,
                    'XVCstPhone' => $request->XVCstPhone,
                    'XVCstFax' => $request->XVCstFax
                ]);
            DB::commit();

            return redirect()->route('customer')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function delCustomer($id)
    {
        $CustomerInOrder = DB::table('TDocTOrHD')->where('XVCstCode','=',$id)->count();
        if($CustomerInOrder > 0){
            return redirect()->route('customer')->with('msg', 'busy');
        }
        DB::beginTransaction();
        try {
            DB::table('tmstmcustomer')->where('XVCstCode', $id)->delete();
            DB::commit();
            return redirect()->route('customer')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function getCst()
    {
        return DB::table('tmstmcustomer');
    }

    public function genCstCode()
    {
        $cst = DB::table('tmstmcustomer')->orderBy('XVCstCode', 'DESC')->first();
        if ($cst == null) {
            $num = 1;
        } else {
            $num = substr($cst->XVCstCode, -3) + 1;
        }
        $cstId = sprintf('Cst-' . '%03d', $num);
        return $cstId;
    }

    public function checkNameDuplicate($name){
        $Cst = DB::table('tmstmcustomer')->where('XVCstName', $name)->count();
        return $Cst>0;
    }
}
