<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FinishGoodIssuedController extends Controller
{
    public function index()
    {
        $HD = DB::table('tdoctfihd')
            ->leftjoin('vk2_users', 'tdoctfihd.XVFihExaminer', 'vk2_users.id')
            ->orderBy('XVFihDocNo', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
        ];
        return view('FI.index', $data);
    }
    public function Apporoveindex()
    {
        $HD = DB::table('tdoctfihd')
            ->leftjoin('vk2_users', 'tdoctfihd.XVFihExaminer', 'vk2_users.id')
            ->where('XVFihDocStatus','2')
            ->orderBy('XVFihDocNo', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
        ];
        return view('FI.index', $data);
    }


    public function FormInsert()
    {
//        $oldHDFind = DB::table('tdoctfihd')
//            ->where('XVFihDocNoOR', '=', $DocNo)
//            ->whereIn('XVFihDocStatus', ['1', '3'])
//            ->first();
//        if ($oldHDFind != null) {
//            return redirect()->route('fr.edit', $oldHDFind->XVFihDocNo)->with('msg', 'success');
//        }
//        $xvpdtcode = null;
//        $hd = DB::table('TDocTOrHD')
//            ->where('XVOrhDocNo', '=', $DocNo)
//            ->first();
//        $pdtImg = DB::table('tmstmproduct')
//            ->where('xvpdtcode', '=', $hd->xvpdtcode)
//            ->select('XVPdtImg')
//            ->first();
//        $xvpdtcode = $hd->xvpdtcode;
//        $dt = DB::table('TDocTOrDT')
//            ->where('XVOrhDocNo', '=', $DocNo)
//            ->join('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
//            ->get();

        return view('FI.frm_add', [
//            'hd' => $hd,
//            'dt' => $dt,
//            'xvpdtcode' => $xvpdtcode,
            'DocStatus' => 1,
        ]);
    }

    public function FormEdit($DocNo)
    {
        $hd = DB::table('tdoctfihd')
            ->where('XVFihDocNo', '=', $DocNo)
            ->first();
        $dt = DB::table('tdoctfidt')
            ->join('tmstmproduct', 'tdoctfidt.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
            ->where('XVFihDocNo', '=', $DocNo)->get();
        foreach ($dt as $item) {
            $qty = $MasterItems = DB::table('tstktmatstockcardproduct')
                ->where('xvpdtcode', '=', $item->xvpdtcode)
                ->where('xvpszname', '=', $item->XVPszName)
                ->select(DB::raw('SUM(xistkqtyleft) as SumQty'))
                ->first();
            $item->StockQty = $qty->SumQty;
        }
        $dataSend = [
            'hd' => $hd,
            'dt' => $dt,
            'DocStatus' => $hd->XVFihDocStatus,
        ];

        return view('FI.frm_edit', $dataSend);
    }

    public function Store(Request $request)
    {
        $date = Carbon::createFromFormat('d-m-Y', $request->XDFihDocDate);
        try {
            DB::beginTransaction();
            $code = GeneratePrimaryKeyDate('tdoctfihd', 'XVFihDocNo', 'FI', 2);
            DB::table('tdoctfihd')->insert([
                'XVFihDocNo' => $code,
                'XDFihDocDate' => $date->format('Y-m-d'),
                'XVFihDocStatus' => 1,
                'XVFihDocRmk' => $request->XVFihDocRmk,
                'XVFihExaminer' => $request->SelectUsers,
                'XVCstCode' => $request->XVCstCode,
                'XVFihRefPO' => $request->XVFihRefPO,
            ]);
            foreach ($request->XVPszName as $key => $item) {
//                $itemFactor = DB::table('tmstmmat_unit')
//                    ->where('xvmatcode', '=', $request->xvmatcode[$key])
//                    ->where('xvuntcode', '=', $request->xvuntcode[$key])
//                    ->first();
                DB::table('tdoctfidt')->insert([
                    'XVFihDocNo' => $code,
                    'xvpdtcode' => $request->xvpdtcode[$key],
                    'XVPszName' => $request->XVPszName[$key],
                    'XIFidQty' => $request->XIFidQty[$key],
                ]);
            }
            DB::commit();
            return redirect()->route('fi.edit', $code)->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function Update(Request $request)
    {
        $date = Carbon::createFromFormat('d-m-Y', $request->XDFihDocDate);
        try {
            DB::beginTransaction();
            $code = $request->XVFihDocNo;
            DB::table('tdoctfihd')
                ->where('XVFihDocNo', '=', $code)
                ->update([
                    'XDFihDocDate' => $date->format('Y-m-d'),
                    'XVFihDocStatus' => 1,
                    'XVFihDocRmk' => $request->XVFihDocRmk,
                    'XVFihExaminer' => $request->SelectUsers,
                    'XVCstCode' => $request->XVCstCode,
                    'XVFihRefPO' => $request->XVFihRefPO,
                ]);
            DB::table('tdoctfidt')
                ->where('XVFihDocNo', '=', $code)->delete();
            foreach ($request->XVPszName as $key => $item) {
//                $itemFactor = DB::table('tmstmmat_unit')
//                    ->where('xvmatcode', '=', $request->xvmatcode[$key])
//                    ->where('xvuntcode', '=', $request->xvuntcode[$key])
//                    ->first();
                DB::table('tdoctfidt')->insert([
                    'XVFihDocNo' => $code,
                    'xvpdtcode' => $request->xvpdtcode[$key],
                    'XVPszName' => $request->XVPszName[$key],
                    'XIFidQty' => $request->XIFidQty[$key],
                ]);
            }
            DB::commit();
            return redirect()->route('fi.edit', $code)->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function ChangeStatus(Request $request)
    {
        try {
            DB::beginTransaction();
            $docNo = $request->XVFihDocNo;
            $requestChange = $request->eventRequest;
            $HD = DB::table('tdoctfihd')
                ->where('XVFihDocNo', '=', $docNo)
                ->first();
            $DocStatus = $HD->XVFihDocStatus;

            switch ($requestChange) {
                case '2' : // Ask for Approve
                    if (canItBeSave($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 1 or 4
                        // Do Someting
                    }
                    break;
                case '3' :  // Approve

                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $isNotBalancePreviosMonth = checkBalancePreviousMonth("tstktmatstockcardproduct");
                        if($isNotBalancePreviosMonth){
                            return redirect()->back()->with('msg', 'IsNotBalanced');
                        }
                        $this->UpdateStatus($docNo, $requestChange);
                        $dt = DB::table('tdoctfidt')
                            ->where('XVFihDocNo', '=', $docNo)->get();
                        foreach ($dt as $item) {

                            $mst = $MasterItems = DB::table('tstktmatstockcardproduct')
                                ->where('xvpdtcode', '=', $item->xvpdtcode)
                                ->where('xvpszname', '=', $item->XVPszName);
                            $itemStockPdt = $mst->get();
                            $qty = $mst->select(DB::raw('SUM(xistkqtyleft) as SumQty'))->first();
                            if ($item->XIFidQty > $qty->SumQty) {
                                return redirect()->back()->with('msg', 'IsMoreThanStock');
                            }
                            $item->Cost = 0;
                            $item->tempXIFidQty = $item->XIFidQty;
                            foreach ($itemStockPdt as $keySTK => $itemSTK) {
                                if ($itemSTK->xistkqtyleft >= $item->tempXIFidQty) {
                                    DB::table('tstktmatstockcardproduct')
                                        ->where('xvpdtcode', '=', $itemSTK->xvpdtcode)
                                        ->where('xvpszname', '=', $itemSTK->xvpszname)
                                        ->where('xvstkdocno', '=', $itemSTK->xvstkdocno)
                                        ->where('xvstktype', '=', $itemSTK->xvstktype)
                                        ->update([
                                            'xistkqtyuse' => $itemSTK->xistkqtyuse + $item->tempXIFidQty,
                                            'xistkqtyleft' => $itemSTK->xistkqtyleft - $item->tempXIFidQty,
                                        ]);
                                    $item->Cost = $item->Cost + ($itemSTK->xfstkcost * $item->tempXIFidQty);
                                    $item->tempXIFidQty = 0;
                                } else {
                                    DB::table('tstktmatstockcardproduct')
                                        ->where('xvpdtcode', '=', $itemSTK->xvpdtcode)
                                        ->where('xvpszname', '=', $itemSTK->xvpszname)
                                        ->where('xvstkdocno', '=', $itemSTK->xvstkdocno)
                                        ->where('xvstktype', '=', $itemSTK->xvstktype)
                                        ->update([
                                            'xistkqtyuse' => $itemSTK->xistkqty,
                                            'xistkqtyleft' => 0,
                                        ]);
                                    $item->Cost = $item->Cost + ($itemSTK->xfstkcost * $itemSTK->xistkqtyleft);
                                    $item->tempXIFidQty = $item->tempXIFidQty - $itemSTK->xistkqtyleft;
                                }

                                if ($item->tempXIFidQty <= 0) {
                                    break;
                                }
                            }
//                            if (count($itemStockPdt) == 0) {
//                                $getDefaultCost = DB::table('tmstmmat_unit')
//                                    ->where('xvmatcode', '=', $item->xvmatcode)
//                                    ->where('xvuntcode', '=', $item->xvuntcode)
//                                    ->first();
//                                $item->Cost = $getDefaultCost->xfmunprice;
////                                dd(count($itemStockMat), $item,$getDefaultCost);
//                            }else{
//                                $item->Cost = divnum($item->Cost, ($item->XIGidQtyStk - $item->tempGidQty));
//                            }

                            $item->Cost = divnum($item->Cost, ($item->XIFidQty - $item->tempXIFidQty));
                            DB::table('tstktmatstockcardproduct')
                                ->insert([
                                    'xvpdtcode'=>$item->xvpdtcode,
                                    'xvpszname'=>$item->XVPszName,
                                    'xvstkdocno'=>$docNo,
                                    'xvstktype'=>2,
                                    'xistkqty'=>$item->XIFidQty,
                                    'xistkqtyuse'=>$item->XIFidQty - ($item->tempXIFidQty > 0 ? $item->tempXIFidQty : 0),
                                    'xistkqtyleft'=>$item->tempXIFidQty > 0 ? -$item->tempXIFidQty : 0,
                                    'xfstkcost'=>$item->Cost ,
                                    'xdstkdate'=>$HD->XDFihDocDate,
                                ]);
                            DB::table('tdoctfidt')
                                ->where('XVFihDocNo', '=', $docNo)
                                ->where('xvpdtcode', '=', $item->xvpdtcode)
                                ->where('XVPszName', '=', $item->XVPszName)
                                ->update([
                                    'XFFidCostTotal' => $item->Cost * $item->XIFidQty,
                                    'XFFidCostAvg' => $item->Cost,
                                ]);
                        }
                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '4' : // Requeste Change
                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '5' :
                    if (canItBe_Cancle($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't ( 1 , 2 , 4)
                        // Do Someting
                    }
            }
            DB::commit();
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function UpdateStatus($docNo, $docStatus)
    {
        DB::table('tdoctfihd')
            ->where('XVFihDocNo', '=', $docNo)
            ->update([
                'XVFihDocStatus' => $docStatus
            ]);
    }

    public function getDataForPDF($docNo)
    {
        $hd = DB::table('tdoctfihd')
            ->where('XVFihDocNo', '=', $docNo)
            ->leftjoin('vk2_users', 'tdoctfihd.XVFihExaminer', 'vk2_users.id')
            ->leftJoin('tmstmcustomer', 'tdoctfihd.XVCstCode', 'tmstmcustomer.XVCstCode')

            //            ->leftjoin('TDocTOrHD', 'tdoctfrhd.XVFihDocNoOR', 'TDocTOrHD.XVOrhDocNo')
//            ->leftjoin('tmstmproduct', 'TDocTOrHD.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->first();
        $dt = DB::table('tdoctfidt')
            ->where('XVFihDocNo', '=', $docNo)
            ->leftjoin('tmstmproduct', 'tdoctfidt.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->get()
            ->toArray();
        $dataSend = [
            'hd' => $hd,
            'dt' => $dt,

        ];
        return response()->json($dataSend);
    }
}
