<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GIController extends Controller
{
    public function index()
    {
        $HD = DB::table('tdoctgihd')
            ->leftjoin('vk2_users', 'tdoctgihd.XIGihUsrID', 'vk2_users.id')
            ->orderBy('XVGihDocNo', 'DESC')
            ->get();
        $RefHD = DB::table('TDocTOrHD')
            ->where('XVOrhDocStatus', '=', '3')
//            ->whereNull('XBOrhIsReferedGI')
            ->leftJoin('tmstmproduct', 'TDocTOrHD.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->orderBy('XVOrhDocNo', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
            'RefHD' => $RefHD
        ];
        return view('Gi.index', $data);
    }
    public function Approveindex()
    {
        $HD = DB::table('tdoctgihd')
            ->leftjoin('vk2_users', 'tdoctgihd.XIGihUsrID', 'vk2_users.id')
            ->where('XVGihDocStatus','2')
            ->orderBy('XVGihDocNo', 'DESC')
            ->get();
        $RefHD = DB::table('TDocTOrHD')
            ->where('XVOrhDocStatus', '=', '3')
//            ->whereNull('XBOrhIsReferedGI')
            ->leftJoin('tmstmproduct', 'TDocTOrHD.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->orderBy('XVOrhDocNo', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
            'RefHD' => $RefHD
        ];
        return view('Gi.index', $data);
    }

    public function FormInsertEmpty()
    {
        return view('Gi.frm_add_empty');
    }

    public function FormInsert($DocNo)
    {
        $oldHDFind = DB::table('tdoctgihd')
            ->where('XVGihDocNoOR', '=', $DocNo)
            ->whereIn('XVGihDocStatus', ['3'])
            ->pluck('XVGihDocNo');
//        if (count($oldHDFind) > 0) {
//            return redirect()->route('gi.edit', ['DocNo' => $oldHDFind[0]])->with('msg', 'success');
//        }
        $usageQty = [];
        if (count($oldHDFind) > 0) {
            $usageQty = DB::table('tdoctgidt')
                ->whereIn('XVGihDocNo', $oldHDFind)
                ->groupBy('xvmatcode', 'xvuntcode')
                ->select("tdoctgidt.*", DB::raw('SUM(XIGidQty) As SumUsageQty'))
                ->get();
        }
        $hd = DB::table('TDocTOrHD')
            ->where('XVOrhDocNo', '=', $DocNo)
            ->first();
        $xvpdtcode = $hd->xvpdtcode ?? null;;

//        $xvpdtcode = $hd->xvpdtcode;
        $dt = DB::table('TDocTOrDT')
            ->where('XVOrhDocNo', '=', $DocNo)
            ->join('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
            ->get();
        $mtQ = DB::table('TDocTOrMT')
            ->where('XVOrhDocNo', '=', $DocNo)
            ->groupBy('TDocTOrMT.xvmatcode', 'TDocTOrMT.xvuntcode')
            ->select('TDocTOrMT.*', DB::raw('SUM(XIOrmQtyBom) as SumQty'), 'tmstmmaterial.*', 'tmstmunit.*')
            ->join('tmstmmaterial', 'TDocTOrMT.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
            ->join('tmstmunit', 'TDocTOrMT.xvuntcode', '=', 'tmstmunit.xvuntcode')
            ->get()->toArray();
        foreach ($mtQ as $item) {
            foreach ($usageQty as $itemQty) {
                if ($item->xvmatcode == $itemQty->xvmatcode && $item->xvuntcode == $itemQty->xvuntcode) {
                    $item->XIOrdBalance = $item->SumQty - $itemQty->SumUsageQty;
                }
            }
        }
        $dataSend = [
            'hd' => $hd,
            'dt' => $dt,
            'xvpdtcode' => $xvpdtcode,
            'DocStatus' => $hd->XVOrhDocStatus,
            'mtQ' => $mtQ
        ];
        return view('Gi.frm_add', $dataSend);
    }

    public function FormEdit($DocNo)
    {
        $hd = DB::table('tdoctgihd')
            ->where('XVGihDocNo', '=', $DocNo)
            ->leftjoin('TDocTOrHD', 'tdoctgihd.XVGihDocNoOR', 'TDocTOrHD.XVOrhDocNo')
            ->first();
        $dt = DB::table('tdoctgidt')
            ->where('XVGihDocNo', '=', $DocNo);
        if (!isset($hd->XVGihDocNoOR)) {
            $dt = $dt
                ->join('tmstmmaterial', 'tdoctgidt.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
                ->join('tmstmunit', 'tdoctgidt.xvuntcode', '=', 'tmstmunit.xvuntcode')
                ->get();
            foreach ($dt as $item) {
                $item->unitType = DB::table('tmstmmat_unit')
                    ->where('xvmatcode', '=', $item->xvmatcode)
                    ->leftjoin('tmstmunit', 'tmstmunit.xvuntcode', 'tmstmmat_unit.xvuntcode')
                    ->get()->toArray();
            }
            return view('Gi.frm_edit_empty', [
                'hd' => $hd,
                'dt' => $dt,
                'DocStatus' => $hd->XVGihDocStatus,
            ]);
        }
        $dt = $dt->get();
        $DocNoOr = $hd->XVGihDocNoOR;
        $orHD = DB::table('TDocTOrHD')
            ->where('XVOrhDocNo', '=', $DocNoOr)
            ->first();
        $hd->XVCstCode = $orHD->XVCstCode;
        $oldHDFind = DB::table('tdoctgihd')
            ->where('XVGihDocNoOR', '=', $DocNoOr)
            ->whereIn('XVGihDocStatus', ['3'])
            ->pluck('XVGihDocNo');
        $usageQty = [];
        if (count($oldHDFind) > 0) {
            $usageQty = DB::table('tdoctgidt')
                ->whereIn('XVGihDocNo', $oldHDFind)
                ->groupBy('xvmatcode', 'xvuntcode')
                ->select("tdoctgidt.*", DB::raw('SUM(XIGidQty) As SumUsageQty'))
                ->get();
            //            return redirect()->route('gi.edit', ['DocNo' => $oldHDFind->XVGihDocNo])->with('msg', 'success');
        }
        $xvpdtcode = $hd->xvpdtcode ?? null;;
        $mtQ = DB::table('TDocTOrMT')
            ->where('XVOrhDocNo', '=', $DocNoOr)
            ->groupBy('TDocTOrMT.xvmatcode', 'TDocTOrMT.xvuntcode')
            ->select('TDocTOrMT.*', DB::raw('SUM(XIOrmQtyBom) as SumQty'), 'tmstmmaterial.*', 'tmstmunit.*')
            ->join('tmstmmaterial', 'TDocTOrMT.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
            ->join('tmstmunit', 'TDocTOrMT.xvuntcode', '=', 'tmstmunit.xvuntcode')
            ->get()->toArray();
        foreach ($mtQ as $item) {
            foreach ($usageQty as $itemQty) {
                if ($item->xvmatcode == $itemQty->xvmatcode && $item->xvuntcode == $itemQty->xvuntcode) {
                    $item->XIOrdBalance = $item->SumQty - $itemQty->SumUsageQty;
                }
            }
            foreach ($dt as $itemDT) {
                if ($item->xvmatcode == $itemDT->xvmatcode && $item->xvuntcode == $itemDT->xvuntcode) {
                    $item->XIGidQty = $itemDT->XIGidQty;
                    $item->XVGidRmk = $itemDT->XVGidRmk;
                }
            }
        }
        $dataSend = [
            'hd' => $hd,
            'dt' => $dt,
            'xvpdtcode' => $xvpdtcode,
            'DocStatus' => $hd->XVGihDocStatus,
            'mtQ' => $mtQ
        ];


//        dd($dataSend);
        return view('Gi.frm_edit', $dataSend);
    }

    public function Store(Request $request)
    {
        $date = Carbon::createFromFormat('d-m-Y', $request->XDOrhDocDate);
        $XDGihDocDateReceive = Carbon::createFromFormat('d-m-Y', $request->XDGihDocDateReceive);
        try {
            DB::beginTransaction();
            $code = GeneratePrimaryKeyDate('tdoctgihd', 'XVGihDocNo', 'GI', 2);
            DB::table('tdoctgihd')->insert([
                'XVGihDocNo' => $code,
                'XDGihDocDate' => $date->format('Y-m-d'),
                'XVGihDocStatus' => 1,
                'XVGihDocNoOR' => $request->XVOrhDocNo,
                'XVGihDocRmk' => $request->XVGihDocRmk,
                'XDGihDocDateReceive' => $XDGihDocDateReceive->format('Y-m-d'),
                'XIGihUsrID' => $request->SelectUsers,
//                'XVGihBillDays' => $request->XVGihBillDays,
//                'XBGihTaxType' => $request->XBGihTaxType,
//                'XIGihAmount' => $request->XIGihAmount,
//                'XFGihTotal' => $request->XFGihTotal,
//                'XFBillDiscount' => $request->XFBillDiscount,
//                'XFGihAfterBillDC' => $request->XFGihAfterBillDC,
//                'XBGihIsTax' => $request->XBGihIsTax,
//                'XIGihTax' => $request->XIGihTax,
//                'XFGihTotalVat' => $request->XFGihTotalVat,
//                'XFGihNet' => $request->XFGihNet,
//                'XFGihBeforeVat' => $request->XFGihBeforeVat,
//                'XVGihRefNo' => $request->XVGihRefNo,
//                'XVGihDeliveryPlace' => $request->XVGihDeliveryPlace,
//                'XVGihImg' => $request->XVGihImg,
            ]);
            foreach ($request->xvmatcode as $key => $item) {
                $itemFactor = DB::table('tmstmmat_unit')
                    ->where('xvmatcode', '=', $request->xvmatcode[$key])
                    ->where('xvuntcode', '=', $request->xvuntcode[$key])
                    ->first();
                DB::table('tdoctgidt')->insert([
                    'XVGihDocNo' => $code,
                    'xvmatcode' => $request->xvmatcode[$key],
                    'xvuntcode' => $request->xvuntcode[$key],
                    'XIGidQty' => $request->XIGidQty[$key],
                    'XVGidUnitName' => $request->xvuntname[$key],
                    //New
                    'XIGidFactor' => $itemFactor->ximunfactor,
                    'XIGidQtyOr' => $request->XIOrdBalance[$key],
                    'XIGidQtyLeft' => $request->XIOrdBalance[$key] - $request->XIGidQty[$key],
                    'XIGidQtyStk' => $itemFactor->ximunfactor * $request->XIGidQty[$key],
                ]);
            }
            DB::commit();
            return redirect()->route('gi.edit', ['DocNo' => $code])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function StoreEmpty(Request $request)
    {
        $date = Carbon::createFromFormat('d-m-Y', $request->XDOrhDocDate);
        $XDGihDocDateReceive = Carbon::createFromFormat('d-m-Y', $request->XDGihDocDateReceive);
        try {
            DB::beginTransaction();
            $code = GeneratePrimaryKeyDate('tdoctgihd', 'XVGihDocNo', 'GI', 2);
            DB::table('tdoctgihd')->insert([
                'XVGihDocNo' => $code,
                'XDGihDocDate' => $date->format('Y-m-d'),
                'XVGihDocStatus' => 1,
                'XVGihDocRmk' => $request->XVGihDocRmk,
                'XDGihDocDateReceive' => $XDGihDocDateReceive->format('Y-m-d'),
                'XIGihUsrID' => $request->SelectUsers,
            ]);
            foreach ($request->xvmatcode as $key => $item) {
                $itemFactor = DB::table('tmstmmat_unit')
                    ->where('xvmatcode', '=', $request->xvmatcode[$key])
                    ->where('tmstmmat_unit.xvuntcode', '=', $request->xvuntcode[$key])
                    ->leftJoin('tmstmunit', 'tmstmmat_unit.xvuntcode', 'tmstmunit.xvuntcode')
                    ->first();
                DB::table('tdoctgidt')->insert([
                    'XVGihDocNo' => $code,
                    'xvmatcode' => $request->xvmatcode[$key],
                    'xvuntcode' => $request->xvuntcode[$key],
                    'XIGidQty' => $request->XIGidQty[$key],
                    'XVGidUnitName' => $itemFactor->xvuntname,
//New
                    'XIGidFactor' => $itemFactor->ximunfactor,
                    'XIGidQtyOr' => 0,
                    'XIGidQtyLeft' => $request->XIGidQty[$key],
                    'XIGidQtyStk' => $itemFactor->ximunfactor * $request->XIGidQty[$key],
                ]);
            }
            DB::commit();
            return redirect()->route('gi.edit', ['DocNo' => $code])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function UpdateEmpty(Request $request)
    {
        $date = Carbon::createFromFormat('d-m-Y', $request->XDOrhDocDate);
        $XDGihDocDateReceive = Carbon::createFromFormat('d-m-Y', $request->XDGihDocDateReceive);
        try {
            DB::beginTransaction();
            $code = $request->XVGihDocNo;
            DB::table('tdoctgihd')
                ->where('XVGihDocNo', '=', $code)
                ->update([
                    'XDGihDocDate' => $date->format('Y-m-d'),
                    'XVGihDocRmk' => $request->XVGihDocRmk,
                    'XDGihDocDateReceive' => $XDGihDocDateReceive->format('Y-m-d'),
                    'XIGihUsrID' => $request->SelectUsers,
                ]);
            DB::table('tdoctgidt')
                ->where('XVGihDocNo', '=', $code)
                ->delete();
            foreach ($request->xvmatcode as $key => $item) {
                $itemFactor = DB::table('tmstmmat_unit')
                    ->where('xvmatcode', '=', $request->xvmatcode[$key])
                    ->where('tmstmmat_unit.xvuntcode', '=', $request->xvuntcode[$key])
                    ->leftJoin('tmstmunit', 'tmstmmat_unit.xvuntcode', 'tmstmunit.xvuntcode')
                    ->first();
                DB::table('tdoctgidt')->insert([
                    'XVGihDocNo' => $code,
                    'xvmatcode' => $request->xvmatcode[$key],
                    'xvuntcode' => $request->xvuntcode[$key],
                    'XIGidQty' => $request->XIGidQty[$key],
                    'XVGidUnitName' => $itemFactor->xvuntname,
//New
                    'XIGidFactor' => $itemFactor->ximunfactor,
                    'XIGidQtyOr' => 0,
                    'XIGidQtyLeft' => $request->XIGidQty[$key],
                    'XIGidQtyStk' => $itemFactor->ximunfactor * $request->XIGidQty[$key],
                ]);
            }
            DB::commit();
            return redirect()->route('gi.edit', ['DocNo' => $code])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

//
    public function Update(Request $request)
    {
        $DocNo = $request->XVGihDocNo;
        $date = Carbon::createFromFormat('d-m-Y', $request->XDOrhDocDate);
        $XDGihDocDateReceive = Carbon::createFromFormat('d-m-Y', $request->XDGihDocDateReceive);
        try {
            DB::beginTransaction();
            DB::table('tdoctgihd')
                ->where('XVGihDocNo', '=', $DocNo)
                ->update([
                    'XDGihDocDate' => $date->format('Y-m-d'),
                    'XVGihDocStatus' => 1,
                    'XVGihDocRmk' => $request->XVGihDocRmk,
                    'XDGihDocDateReceive' => $XDGihDocDateReceive->format('Y-m-d'),
                    'XIGihUsrID' => $request->SelectUsers,
//                'XVGihBillDays' => $request->XVGihBillDays,
//                'XBGihTaxType' => $request->XBGihTaxType,
//                'XIGihAmount' => $request->XIGihAmount,
//                'XFGihTotal' => $request->XFGihTotal,
//                'XFBillDiscount' => $request->XFBillDiscount,
//                'XFGihAfterBillDC' => $request->XFGihAfterBillDC,
//                'XBGihIsTax' => $request->XBGihIsTax,
//                'XIGihTax' => $request->XIGihTax,
//                'XFGihTotalVat' => $request->XFGihTotalVat,
//                'XFGihNet' => $request->XFGihNet,
//                'XFGihBeforeVat' => $request->XFGihBeforeVat,
//                'XVGihRefNo' => $request->XVGihRefNo,
//                'XVGihDeliveryPlace' => $request->XVGihDeliveryPlace,
//                'XVGihImg' => $request->XVGihImg,
                ]);
            DB::table('tdoctgidt')
                ->where('XVGihDocNo', '=', $DocNo)
                ->delete();
            foreach ($request->xvmatcode as $key => $item) {
                $itemFactor = DB::table('tmstmmat_unit')
                    ->where('xvmatcode', '=', $request->xvmatcode[$key])
                    ->where('xvuntcode', '=', $request->xvuntcode[$key])
                    ->first();
                DB::table('tdoctgidt')->insert([
                    'XVGihDocNo' => $DocNo,
                    'xvmatcode' => $request->xvmatcode[$key],
                    'xvuntcode' => $request->xvuntcode[$key],
                    'XIGidQty' => $request->XIGidQty[$key],
                    'XVGidUnitName' => $request->xvuntname[$key],
                    //New
                    'XIGidFactor' => $itemFactor->ximunfactor,
                    'XIGidQtyOr' => $request->XIOrdBalance[$key],
                    'XIGidQtyLeft' => $request->XIOrdBalance[$key] - $request->XIGidQty[$key],
                    'XIGidQtyStk' => $itemFactor->ximunfactor * $request->XIGidQty[$key],
                ]);
            }
            DB::commit();
            return redirect()->route('gi.edit', ['DocNo' => $DocNo])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function ChangeStatus(Request $request)
    {
        try {
            DB::beginTransaction();
            $docNo = $request->XVGihDocNo;
            $requestChange = $request->eventRequest;
            $HD = DB::table('tdoctgihd')
                ->where('XVGihDocNo', '=', $docNo)
                ->first();
            $DocStatus = $HD->XVGihDocStatus;
            switch ($requestChange) {
                case '2' : // Ask for Approve
                    if (canItBeSave($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 1 or 4
                        // Do Someting
                    }
                    break;
                case '3' :  // Approve
                   
                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $isNotBalancePreviosMonth = checkBalancePreviousMonth();
                        if($isNotBalancePreviosMonth ){
                            return redirect()->back()->with('msg', 'IsNotBalanced');
                        }
                       
                        $this->UpdateStatus($docNo, $requestChange);
                        

                        DB::table('tdoctorhd')
                            ->where('XVOrhDocNo', '=', $HD->XVGihDocNoOR)
                            ->update([
                                'XBOrhIsReferedGI' => true,
                            ]);
                        $DT = DB::table('tdoctgidt')
                            ->where('XVGihDocNo', '=', $docNo)
                            ->get();
//                        $lastKey = GeneratePrimaryKeyDate('tstktmatstockcard', 'xvstkdocno', "STK");
//                        $lastKeyAdj = GeneratePrimaryKeyDateExtra('tstktmatstockcard', 'xvstkdocno', "A",1,false,'xvstkdocno','A');

                        foreach ($DT as $key => $item) {
                            $item->Cost = 0;
                            $item->tempGidQty = $item->XIGidQtyStk;

                            $itemStockMat = DB::table('tstktmatstockcard')
                                ->where('xvmatcode', '=', $item->xvmatcode)
                                ->whereIn('xvstktype', [0,1, 5])
                                ->where('xistkqtyleft', '>', 0)
                                ->get();

                            foreach ($itemStockMat as $keySTK => $itemSTK) {
                                if ($itemSTK->xistkqtyleft >= $item->tempGidQty) {
//                                    dd($itemSTK, $item);

                                    DB::table('tstktmatstockcard')
                                        ->where('xvmatcode', '=', $itemSTK->xvmatcode)
                                        ->where('xvstkdocno', '=', $itemSTK->xvstkdocno)
                                        ->where('xvstktype', '=', $itemSTK->xvstktype)
                                        ->update([
                                            'xistkqtyuse' => $itemSTK->xistkqtyuse + $item->tempGidQty,
                                            'xistkqtyleft' => $itemSTK->xistkqtyleft - $item->tempGidQty,
                                        ]);
                                    $item->Cost = $item->Cost + ($itemSTK->xfstkcost * $item->tempGidQty);
                                    $item->tempGidQty = 0;
                                } else {
//                                    dd($itemSTK, $item, 'es');

                                    DB::table('tstktmatstockcard')
                                        ->where('xvmatcode', '=', $itemSTK->xvmatcode)
                                        ->where('xvstkdocno', '=', $itemSTK->xvstkdocno)
                                        ->where('xvstktype', '=', $itemSTK->xvstktype)
                                        ->update([
                                            'xistkqtyuse' => $itemSTK->xistkqty,
                                            'xistkqtyleft' => 0,
                                        ]);
                                    $item->Cost = $item->Cost + ($itemSTK->xfstkcost * $itemSTK->xistkqtyleft);
                                    $item->tempGidQty = $item->tempGidQty - $itemSTK->xistkqtyleft;
                                }

                                if ($item->tempGidQty <= 0) {
                                    break;
                                }
                            }
//                            dd($item->Cost , $item->XIGidQtyStk , $item->tempGidQty,($item->XIGidQtyStk - $item->tempGidQty),$item->Cost / ($item->XIGidQtyStk - $item->tempGidQty));
                            if (count($itemStockMat) == 0) {
                                $getDefaultCost = DB::table('tmstmmat_unit')
                                    ->where('xvmatcode', '=', $item->xvmatcode)
                                    ->where('xvuntcode', '=', $item->xvuntcode)
                                    ->first();
                                $item->Cost = $getDefaultCost->xfmunprice;
//                                dd(count($itemStockMat), $item,$getDefaultCost);
                            }else{
                                $item->Cost = divnum($item->Cost, ($item->XIGidQtyStk - $item->tempGidQty));
                            }
                            DB::table('tstktmatstockcard')
                                ->insert([
                                    'xvmatcode' => $item->xvmatcode,
                                    'xvstkdocno' => $docNo,
                                    'xvstktype' => 2,
                                    'xistkqty' => $item->XIGidQtyStk,
                                    'xistkqtyuse' =>$item->XIGidQtyStk -$item->tempGidQty,
                                    'xistkqtyleft' => -$item->tempGidQty,
                                    'xfstkcost' => $item->Cost,
                                    'xdstkdate' => $HD->XDGihDocDate,
                                ]);
                            DB::table('tdoctgidt')
                                ->where('XVGihDocNo', '=', $docNo)
                                ->where('xvmatcode', '=', $item->xvmatcode)
                                ->update([
                                    'XFGidCostTotal' => $item->Cost * $item->XIGidQtyStk,
                                    'XFGidCostAvg' => $item->Cost,
                                ]);
                        }
                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '4' : // Requeste Change
                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '5' :
                    if (canItBe_Cancle($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't ( 1 , 2 , 4)
                        // Do Someting
                    }
                case '6' :
                    if (canItBe_Expire($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't ( 3)
                        // Do Someting
                    }
                    break;
            }
            DB::commit();
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function UpdateStatus($docNo, $docStatus)
    {
        DB::table('tdoctgihd')
            ->where('XVGihDocNo', '=', $docNo)
            ->update([
                'XVGihDocStatus' => $docStatus
            ]);
          
    }

    public function getDataForPDF($docNo)
    {
        $hd = DB::table('tdoctgihd')
            ->where('XVGihDocNo', '=', $docNo)
            ->leftjoin('vk2_users', 'tdoctgihd.XIGihUsrID', 'vk2_users.id')
            ->leftJoin('TDocTOrHD', 'tdoctgihd.XVGihDocNoOR', 'TDocTOrHD.XVOrhDocNo')
            ->leftJoin('tmstmcustomer', 'TDocTOrHD.XVCstCode', 'tmstmcustomer.XVCstCode')
            ->leftJoin('tmstmproduct', 'TDocTOrHD.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->leftJoin('tmforuse', 'tmstmproduct.XIForCode', 'tmforuse.XIForCode')
            ->leftJoin('tmgenerate', 'tmstmproduct.XIGenerateCode', 'tmgenerate.XIGenerateCode')
            ->leftJoin('tmseason', 'tmstmproduct.XISeasonCode', 'tmseason.XISeasonCode')
            ->leftJoin('tmshape', 'tmstmproduct.XIShapeCode', 'tmshape.XIShapeCode')
            ->leftJoin('TMstMMaterial', 'tmstmproduct.xvmatcode', 'TMstMMaterial.xvmatcode')
            ->first();
        $dt = DB::table('tdoctgidt')
            ->where('XVGihDocNo', '=', $docNo)
            ->leftJoin('tmstmmaterial', 'tdoctgidt.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
            ->leftJoin('tmstmunit', 'tdoctgidt.xvuntcode', '=', 'tmstmunit.xvuntcode')
            ->get()->toArray();
        $dataSend = [
            'hd' => $hd,
            'dt' => $dt,

        ];
        return response()->json($dataSend);
    }
}
