<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class GRController extends Controller
{
    public function index()
    {
        $HD = DB::table('tdoctgrhd')
            ->leftjoin('vk2_users', 'tdoctgrhd.XIGrhUsrID', 'vk2_users.id')
            ->leftjoin('tmstmsupplier', 'tdoctgrhd.XVSplCode', 'tmstmsupplier.XVSplCode')
            ->orderBy('XVGrhDocNo', 'DESC')
            ->get();
        $HDPO = DB::table('TDocTPoHD')
            ->where('XVPohDocStatus', '=', '3')
            ->whereNull('XBPohIsRefered')
            ->leftjoin('tmstmsupplier', 'TDocTPoHD.XVSplCode', 'tmstmsupplier.XVSplCode')
            ->orderBy('XVPohDocNo', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
            'HDPO' => $HDPO
        ];
        return view('GR.index', $data);
    }

    public function Approveindex()
    {
        $HD = DB::table('tdoctgrhd')
            ->leftjoin('vk2_users', 'tdoctgrhd.XIGrhUsrID', 'vk2_users.id')
            ->leftjoin('tmstmsupplier', 'tdoctgrhd.XVSplCode', 'tmstmsupplier.XVSplCode')
            ->orderBy('XVGrhDocNo', 'DESC')
            ->where('XVGrhDocStatus', '=', '2')
            ->get();
        $HDPO = DB::table('TDocTPoHD')
            ->where('XVPohDocStatus', '=', '3')
            ->whereNull('XBPohIsRefered')
            ->leftjoin('tmstmsupplier', 'TDocTPoHD.XVSplCode', 'tmstmsupplier.XVSplCode')
            ->orderBy('XVPohDocNo', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
            'HDPO' => $HDPO
        ];
        return view('GR.index', $data);
    }

    public function FormInsert($XVPohDocNo)
    {
        $oldHDFind = DB::table('tdoctgrhd')
            ->where('XVGrhDocNoPO', '=', $XVPohDocNo)
            ->whereIn('XVGrhDocStatus', ['1', '3'])
            ->first();
        if ($oldHDFind != null) {
            return redirect()->route('gr.edit', ['XVGrhDocNo' => $oldHDFind->XVGrhDocNo])->with('msg', 'success');
        }
        $oldHD = DB::table('TDocTPoHD')
            ->where('XVPohDocNo', '=', $XVPohDocNo)->first();
        $oldDT = DB::table('TDocTPoDT')
            ->where('XVPohDocNo', '=', $XVPohDocNo)
            ->leftjoin('TMstMMaterial', 'TDocTPoDT.xvmatcode', 'TMstMMaterial.xvmatcode')
            ->leftjoin('tmstmunit', 'TDocTPoDT.xvuntcode', 'tmstmunit.xvuntcode')
            ->get();
        $dataSend = [
            'hd' => $oldHD,
            'dt' => $oldDT,
            'DocStatus' => $oldHD->XVPohDocStatus
        ];
        return view('GR.frm_add', $dataSend);
    }

    public function FormEdit($XVGrhDocNo)
    {
        $oldHD = DB::table('tdoctgrhd')
            ->leftjoin('TDocTPoHD', 'tdoctgrhd.XVGrhDocNoPO', 'TDocTPoHD.XVPohDocNo')
            ->select('tdoctgrhd.*','XVPohDeliveryPlace')
            ->where('XVGrhDocNo', '=', $XVGrhDocNo)->first();
//        dd($oldHD);
        $oldDT = DB::table('tdoctgrdt')
            ->where('XVGrhDocNo', '=', $XVGrhDocNo)
            ->leftjoin('TMstMMaterial', 'tdoctgrdt.xvmatcode', 'TMstMMaterial.xvmatcode')
            ->leftjoin('tmstmunit', 'tdoctgrdt.xvuntcode', 'tmstmunit.xvuntcode')
            ->get();
        $dataSend = [
            'hd' => $oldHD,
            'dt' => $oldDT,
            'DocStatus' => $oldHD->XVGrhDocStatus
        ];
//        dd($dataSend);
        return view('GR.frm_edit', $dataSend);
    }

    public function Store(Request $request)
    {
        $oldPO = DB::table('TDocTPoHD')->where('XVPohDocNo', $request->XVPohDocNo)->first();
        $XDPohDocDate = Carbon::createFromFormat('d-m-Y', $request->XDGrhDocDate);
        try {
            DB::beginTransaction();
            $docNo = GeneratePrimaryKeyDate('tdoctgrhd', 'XVGrhDocNo', 'GR', 2);
            DB::table('tdoctgrhd')->insert([
                'XVGrhDocNo' => $docNo,
                'XVSplCode' => $request->XVSplCode,
                'XDGrhDocDate' => $XDPohDocDate->format('Y-m-d'),
                'XVGrhDocStatus' => '1',
                'XVGrhDocNoPO' => $request->XVPohDocNo,
                'XVGrhDocRmk' => $request->XVGrhDocRmk,
                'XVGrhBillDays' => $request->XVPohBillDays,
                'XBGrhTaxType' => $request->XBPohTaxType,
                'XIGrhAmount' => $request->XIPohAmount,
                'XFGrhTotal' => $request->XFPohTotal,
                'XFBillDiscount' => $request->XFBillDiscount,
                'XFGrhAfterBillDC' => $request->XFPohAfterBillDC,
                'XBGrhIsTax' => isset($request->XBPohIsTax),
                'XIGrhTax' => $request->XIPohTax,
                'XFGrhTotalVat' => $request->XFPohTotalVat,
                'XFGrhNet' => $request->XFPohNet,
                'XFGrhBeforeVat' => $request->XFPohBeforeVat,
                'XVGrhRefNo' => $request->XVPohRefNo,
                'XVGrhDeliveryPlace' => $request->XVPohDeliveryPlace,
                'XVGrhImg' => $oldPO->XVPohImg,
                'XIGrhUsrID' => $request->SelectUsers,

            ]);
            for ($i = 0; $i < count($request->xvmatcode); $i++) {
                $MatUnit = DB::table('tmstmmat_unit')
                    ->where('xvmatcode', '=', $request->xvmatcode[$i])
                    ->where('tmstmmat_unit.xvuntcode', '=', $request->XVMatUnit_Name[$i])
                    ->join('tmstmunit', 'tmstmmat_unit.xvuntcode', 'tmstmunit.xvuntcode')
                    ->first();
                $qtyStk = $request->XIPodQty[$i] * $MatUnit->ximunfactor;
                DB::table('tdoctgrdt')->insert([
                    'XVGrhDocNo' => $docNo,
                    'xvmatcode' => $request->xvmatcode[$i],
                    'XVGrdName' => $request->XVPodName[$i],
                    'xvuntcode' => $request->XVMatUnit_Name[$i],
                    'XVGrdUnitName' => $MatUnit->xvuntname,
                    'XIGrdFactor' => $MatUnit->ximunfactor,
                    'XIGrdQty' => $request->XIPodQty[$i],
                    'XIGrdQtyPo' => $request->XIGrdQtyPo[$i],
                    'XIGrdQtyLeft' => $request->XIPodQty[$i] - $request->XIGrdQtyPo[$i],
                    'XIGrdQtyStk' => $qtyStk,
                    'XFGrdUnitCost' => $request->XFPodUnitCost[$i],
                    'XFGrdDiscount' => $request->XFPodDiscount[$i],
                    'XFGrdCostTotal' => $request->XFPodCostTotal[$i],
                    'XFGrdCostAvg' => $request->XFPodCostTotal[$i] / $qtyStk,
                ]);
            }
            DB::commit();
            return redirect()->route('gr.edit', ['XVGrhDocNo' => $docNo])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function Update(Request $request)
    {

//        $oldPO = DB::table('TDocTPoHD')->where('XVPohDocNo', $request->XVPohDocNo)->first();
        $XDPohDocDate = Carbon::createFromFormat('d-m-Y', $request->XDGrhDocDate);
        try {
            DB::beginTransaction();
            $docNo = $request->XVGrhDocNo;
            DB::table('tdoctgrhd')
                ->where('XVGrhDocNo', '=', $docNo)
                ->update([
                    'XVSplCode' => $request->XVSplCode,
                    'XDGrhDocDate' => $XDPohDocDate->format('Y-m-d'),
                    'XVGrhDocStatus' => '1',
                    'XVGrhDocNoPO' => $request->XVPohDocNo,
                    'XVGrhDocRmk' => $request->XVGrhDocRmk,
                    'XVGrhBillDays' => $request->XVPohBillDays,
                    'XBGrhTaxType' => $request->XBPohTaxType,
                    'XIGrhAmount' => $request->XIPohAmount,
                    'XFGrhTotal' => $request->XFPohTotal,
                    'XFBillDiscount' => $request->XFBillDiscount,
                    'XFGrhAfterBillDC' => $request->XFPohAfterBillDC,
                    'XBGrhIsTax' => isset($request->XBPohIsTax),
                    'XIGrhTax' => $request->XIPohTax,
                    'XFGrhTotalVat' => $request->XFPohTotalVat,
                    'XFGrhNet' => $request->XFPohNet,
                    'XFGrhBeforeVat' => $request->XFPohBeforeVat,
                    'XVGrhRefNo' => $request->XVPohRefNo,
                    'XVGrhDeliveryPlace' => $request->XVPohDeliveryPlace,
                    'XIGrhUsrID' => $request->SelectUsers,
                ]);
            DB::table('tdoctgrdt')
                ->where('XVGrhDocNo', '=', $docNo)
                ->delete();
            for ($i = 0; $i < count($request->xvmatcode); $i++) {
                $MatUnit = DB::table('tmstmmat_unit')
                    ->where('xvmatcode', '=', $request->xvmatcode[$i])
                    ->where('tmstmmat_unit.xvuntcode', '=', $request->XVMatUnit_Name[$i])
                    ->join('tmstmunit', 'tmstmmat_unit.xvuntcode', 'tmstmunit.xvuntcode')
                    ->first();
                $qtyStk = $request->XIPodQty[$i] * $MatUnit->ximunfactor;
                DB::table('tdoctgrdt')->insert([
                    'XVGrhDocNo' => $docNo,
                    'xvmatcode' => $request->xvmatcode[$i],
                    'XVGrdName' => $request->XVPodName[$i],
                    'xvuntcode' => $request->XVMatUnit_Name[$i],
                    'XVGrdUnitName' => $MatUnit->xvuntname,
                    'XIGrdFactor' => $MatUnit->ximunfactor,
                    'XIGrdQty' => $request->XIPodQty[$i],
                    'XIGrdQtyPo' => $request->XIGrdQtyPo[$i],
                    'XIGrdQtyLeft' => $request->XIPodQty[$i] - $request->XIGrdQtyPo[$i],
                    'XIGrdQtyStk' => $qtyStk,
                    'XFGrdUnitCost' => $request->XFPodUnitCost[$i],
                    'XFGrdDiscount' => $request->XFPodDiscount[$i],
                    'XFGrdCostTotal' => $request->XFPodCostTotal[$i],
                    'XFGrdCostAvg' =>divnum($request->XFPodCostTotal[$i] , $qtyStk),
                ]);
            }
            DB::commit();
            return redirect()->back();

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function ChangeStatus(Request $request)
    {
        try {
            DB::beginTransaction();
            $docNo = $request->XVGrhDocNo;
            $requestChange = $request->eventRequest;
            $GrHD = DB::table('tdoctgrhd')
                ->where('XVGrhDocNo', '=', $docNo)
                ->first();
            $DocStatus = $GrHD->XVGrhDocStatus;
            switch ($requestChange) {
                case '2' : // Ask for Approve
                    if (canItBeSave($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 1 or 4
                        // Do Someting
                    }
                    break;
                case '3' :  // Approve


                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $isNotBalancePreviosMonth = checkBalancePreviousMonth();
                        if($isNotBalancePreviosMonth){
                            return redirect()->back()->with('msg', 'IsNotBalanced');
                        }
                        $PoHD = DB::table('TDocTPoHD')
                            ->where('XVPohDocNo', '=', $GrHD->XVGrhDocNoPO)
                            ->first();
                        if ($PoHD->XBPohIsRefered == true) {
                            return redirect()->back()->with('msg', 'IsRefered');
                        } else {
                            $this->UpdateStatus($docNo, $requestChange);
                            DB::table('TDocTPoHD')
                                ->where('XVPohDocNo', '=', $GrHD->XVGrhDocNoPO)
                                ->update([
                                    'XDPohDocDateReceive' => $GrHD->XDGrhDocDate,
                                    'XBPohIsRefered' => true,
                                ]);
                            $GrDT = DB::table('tdoctgrdt')
                                ->where('XVGrhDocNo', '=', $docNo)
                                ->get();
//                            $prefix = 'STK';
//                            $lastKey = GeneratePrimaryKeyDate('tstktmatstockcard', 'xvstkdocno', $prefix,3,true);
//                            $lastKey = GeneratePrimaryKeyDate('tstktmatstockcard', 'xvstkdocno', $prefix);
//                            $stamp = twoprefixYearMonth();
                            foreach ($GrDT as $key => $item){
                                $item->tempXIGrdQty = $item->XIGrdQtyStk;
                                $itemStockMat = DB::table('tstktmatstockcard')
                                    ->where('xvmatcode', '=', $item->xvmatcode)
                                    ->whereIn('xvstktype', [2,6])
                                    ->where('xistkqtyleft', '!=', 0)
                                    ->get();
                                foreach ($itemStockMat as $keySTK => $itemSTK) {
                                    if($itemSTK->xistkqtyleft + $item->tempXIGrdQty >= 0  ){
                                        $qtyLeft = 0 ;
                                        $item->tempXIGrdQty = $itemSTK->xistkqtyleft + $item->tempXIGrdQty ;
                                    }else{
                                        $qtyLeft = $itemSTK->xistkqtyleft + $item->tempXIGrdQty;
                                        $item->tempXIGrdQty = 0 ;
                                    }
                                    DB::table('tstktmatstockcard')
                                        ->where('xvmatcode', '=', $itemSTK->xvmatcode)
                                        ->where('xvstkdocno', '=', $itemSTK->xvstkdocno)
                                        ->where('xvstktype', '=', $itemSTK->xvstktype)
                                        ->update([
                                            'xistkqtyuse'=>$itemSTK->xistkqty - $qtyLeft, // qtyuse issue
                                            'xistkqtyleft'=>$qtyLeft,
                                        ]);

                                    if($item->tempXIGrdQty <=0){
                                        break;
                                    }
                                }
                                DB::table('tstktmatstockcard')
                                    ->insert([
                                        'xvmatcode'=>$item->xvmatcode,
                                        'xvstkdocno'=>$docNo,
                                        'xvstktype'=>1,
                                        'xistkqty'=>$item->XIGrdQtyStk,
                                        'xistkqtyuse'=>$item->XIGrdQtyStk - $item->tempXIGrdQty,
                                        'xistkqtyleft'=>$item->tempXIGrdQty,
                                        'xfstkcost'=>$item->XFGrdCostAvg,
                                        'xdstkdate'=>$GrHD->XDGrhDocDate,
                                    ]);
                            }
                        }

                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '4' : // Requeste Change
                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '5' :
                    if (canItBe_Cancle($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't ( 1 , 2 , 4)
                        // Do Someting
                    }
//                case '6' :
//                    if (canItBe_Expire($DocStatus)) {
//                        $this->UpdateStatus($docNo, $requestChange);
//                        DB::table('TDocTPoHD')
//                            ->where('XVPohDocNo', '=', $GrHD->XVGrhDocNoPO)
//                            ->update([
//                                'XDPohDocDateReceive' => null,
//                                'XBPohIsRefered' => null,
//                            ]);
//                    } else {
//                        // Can't Update Status Because DocStatus Isn't ( 3)
//                        // Do Someting
//                    }
//                    break;
            }
            DB::commit();
            return redirect()->back();

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }

    }

    public function UpdateStatus($docNo, $docStatus)
    {
        DB::table('tdoctgrhd')
            ->where('XVGrhDocNo', '=', $docNo)
            ->update([
                'XVGrhDocStatus' => $docStatus
            ]);
    }

    public function getDataForPDF($docNo)
    {
        $oldHD = DB::table('tdoctgrhd')
            ->where('XVGrhDocNo', '=', $docNo)
            ->leftjoin('vk2_users', 'tdoctgrhd.XIGrhUsrID', 'vk2_users.id')
            ->leftjoin('TDocTPoHD', 'tdoctgrhd.XVGrhDocNoPO', 'TDocTPoHD.XVPohDocNo')
            ->select('tdoctgrhd.*','name','XVPohDeliveryPlace')
            ->leftjoin('tmstmsupplier', 'tdoctgrhd.XVSplCode', 'tmstmsupplier.XVSplCode')
            ->first();
        $oldDT = DB::table('tdoctgrdt')
            ->where('XVGrhDocNo', '=', $docNo)
            ->leftjoin('TMstMMaterial', 'tdoctgrdt.xvmatcode', 'TMstMMaterial.xvmatcode')
            ->leftjoin('tmstmunit', 'tdoctgrdt.xvuntcode', 'tmstmunit.xvuntcode')
            ->get();
        $dataSend = [
            'hd' => $oldHD,
            'dt' => $oldDT,

        ];
        return response()->json($dataSend);
    }
}
