<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MasterItemController extends Controller
{
    public function index()
    {
        $HD = DB::table('tmstmproduct')
            ->leftjoin('tmstmmaterial', 'tmstmproduct.xvmatcode', 'tmstmmaterial.xvmatcode')
            ->orderBy('xvpdtcode', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
        ];
        return view('MasterItem.index', $data);
    }

    public function FormInsert()
    {
        return view('MasterItem.frm_add');
    }

    public function FormEdit($xvpdtcode)
    {
        $hd = DB::table('tmstmproduct')->where('xvpdtcode', '=', $xvpdtcode)->first();
        $dt = DB::table('tmstmbom')
            ->where('xvpdtcode', '=', $xvpdtcode)
            ->join('tmstmunit', 'tmstmbom.xvuntcode', 'tmstmunit.xvuntcode')
            ->join('tmstmmaterial', 'tmstmbom.xvmatcode', 'tmstmmaterial.xvmatcode')
            ->get();
        foreach ($dt as $item) {
            $item->unitType = DB::table('tmstmmat_unit')
                ->where('xvmatcode', '=', $item->xvmatcode)
                ->leftjoin('tmstmunit', 'tmstmunit.xvuntcode', 'tmstmmat_unit.xvuntcode')
                ->get()->toArray();
        }
        return view('MasterItem.frm_edit', [
            'hd' => $hd,
            'dt' => $dt
        ]);
    }

    public function Store(Request $request)
    {
       //  dd($request);
        if (isset($request->ImgResize)) {
            $imageName = "images/" .time() . '.' . $request->ImgResize->extension();
        } else {
            
            if ($request->imgDs <> "")
            {
                $imageName = $request->imgDs;
            }
            else {
                $imageName = "images/" ."not-found.jpg";
            } 
        }
        try {
          
            DB::beginTransaction();
            $docNo = GeneratePrimaryKeyDate('tmstmproduct', 'xvpdtcode', 'Pdt');
            DB::table('tmstmproduct')->insert([
                'XVDsCode' => $request->SelectDesign,
                'xvpdtcode' => $docNo,
                'xvpdtname' => $request->xvpdtname,
                'XVPdtImg' =>  $imageName,
                'XFPdtCost' => $request->XFPdtCost,
                'XFPdtPrice' => $request->XFPdtPrice,
                'XVPdtColor' => $request->XVPdtColor,
                'XISeasonCode' => $request->SelectSeason,
                'XIForCode' => $request->SelectForUse,
                'XIGenerateCode' => $request->SelectGenerate,
                'XIShapeCode' => $request->SelectShape,
                'xvmatcode' => $request->SelectPureMaterial, // meaing Farbic Material
//                new Required
                'XVPdtPatternNo' => $request->XVPdtPatternNo,
                'XVPdtClothFace' => $request->XVPdtClothFace,
                'XVPdtCrotchFabric' => $request->XVPdtCrotchFabric,
                'XVPdtFarbicA' => $request->XVPdtFarbicA,
                'XVPdtFarbicB' => $request->XVPdtFarbicB,
                'XVPdtCmtDetail' => $request->XVPdtCmtDetail,
                'XVPdtCmtDetailMore' => $request->XVPdtCmtDetailMore,
                'XVPdtCmtZipSize' => $request->XVPdtCmtZipSize,
                'XVPdtCmtButton' => $request->XVPdtCmtButton,
                'XVPdtCmtSecretBag' => $request->XVPdtCmtSecretBag,
                'XVPdtCmtBackPocket' => $request->XVPdtCmtBackPocket,
                'XVPdtCmtEarSize' => $request->XVPdtCmtEarSize,
                'XVPdtCmtSewing' => $request->XVPdtCmtSewing,
                'XVPdtCmtTwill' => $request->XVPdtCmtTwill,
                'XVPdtCmtTagging' => $request->XVPdtCmtTagging,
                'XVPdtCmtTung' => $request->XVPdtCmtTung,
                'XVPohDocRmk' => $request->XVPohDocRmk,
                'XVPdtCmtSpecial' => $request->XVPdtCmtSpecial,
            ]);
            if (isset($request->xvmatcode)) {
            for ($i = 0; $i < count($request->xvmatcode); $i++) {
                DB::table('tmstmbom')->insert([
                    'xvpdtcode' => $docNo,
                    'xvmatcode' => $request->xvmatcode[$i],
                    'xvuntcode' => $request->xvuntcode[$i],
                    'XIBomQty' => ($request->XIBomQty[$i]),
                ]);
            }
        }
            if (isset($request->xvmatcode2)){
                for ($i = 0; $i < count($request->xvmatcode2); $i++) {
                    DB::table('tmstmbom')->insert([
                        'xvpdtcode' => $docNo,
                        'xvmatcode' => $request->xvmatcode2[$i],
                        'xvuntcode' => $request->xvuntcode2[$i],
                        'XIBomQty' => ($request->XIBomQty2[$i]),
                    ]);
                }

            }
            if (isset($request->ImgResize)) {
                $request->ImgResize->move(public_path('images'), $imageName);
            }

            DB::commit();
            return redirect()->route('item.index');
//            return redirect()->route('mat.edit',['XVPohDocNo'=>$docNo])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }

    }

    public function Update(Request $request)
    {
        try {
            $isUploadNew = false;
            if (isset($request->ImgResize)) {
                $isUploadNew = true;
                $imageName = time() . '.' . $request->ImgResize->extension();
            } else {
                $imageName = $request->oldImg;
            }

            DB::beginTransaction();
            $docNo = $request->xvpdtcode;
            DB::table('tmstmproduct')
                ->where('xvpdtcode', '=', $docNo)
                ->update([
                    'XVDsCode' => $request->SelectDesign,
                    'xvpdtname' => $request->xvpdtname,
                    'XVPdtImg' => $isUploadNew ? "images/" . $imageName : $imageName,
                    'XFPdtCost' => $request->XFPdtCost,
                    'XFPdtPrice' => $request->XFPdtPrice,
                    'XVPdtColor' => $request->XVPdtColor,
                    'XISeasonCode' => $request->SelectSeason,
                    'XIForCode' => $request->SelectForUse,
                    'XIGenerateCode' => $request->SelectGenerate,
                    'XIShapeCode' => $request->SelectShape,
                    'xvmatcode' => $request->SelectPureMaterial, // meaing Farbic Material
//                new Required
                    'XVPdtPatternNo' => $request->XVPdtPatternNo,
                    'XVPdtClothFace' => $request->XVPdtClothFace,
                    'XVPdtCrotchFabric' => $request->XVPdtCrotchFabric,
                    'XVPdtFarbicA' => $request->XVPdtFarbicA,
                    'XVPdtFarbicB' => $request->XVPdtFarbicB,
                    'XVPdtCmtDetail' => $request->XVPdtCmtDetail,
                    'XVPdtCmtDetailMore' => $request->XVPdtCmtDetailMore,
                    'XVPdtCmtZipSize' => $request->XVPdtCmtZipSize,
                    'XVPdtCmtButton' => $request->XVPdtCmtButton,
                    'XVPdtCmtSecretBag' => $request->XVPdtCmtSecretBag,
                    'XVPdtCmtBackPocket' => $request->XVPdtCmtBackPocket,
                    'XVPdtCmtEarSize' => $request->XVPdtCmtEarSize,
                    'XVPdtCmtSewing' => $request->XVPdtCmtSewing,
                    'XVPdtCmtTwill' => $request->XVPdtCmtTwill,
                    'XVPdtCmtTagging' => $request->XVPdtCmtTagging,
                    'XVPdtCmtTung' => $request->XVPdtCmtTung,
                    'XVPohDocRmk' => $request->XVPohDocRmk,
                    'XVPdtCmtSpecial' => $request->XVPdtCmtSpecial,
                ]);
            DB::table('tmstmbom')
                ->where('xvpdtcode', '=', $docNo)
                ->delete();
               
                if (isset($request->xvmatcode)){
            for ($i = 0; $i < count($request->xvmatcode); $i++) {
                DB::table('tmstmbom')->insert([
                    'xvpdtcode' => $docNo,
                    'xvmatcode' => $request->xvmatcode[$i],
                    'xvuntcode' => $request->xvuntcode[$i],
                    'XIBomQty' => ($request->XIBomQty[$i]),
                ]);
            }
        }
            if (isset($request->xvmatcode2)){
            for ($i = 0; $i < count($request->xvmatcode2); $i++) {
                DB::table('tmstmbom')->insert([
                    'xvpdtcode' => $docNo,
                    'xvmatcode' => $request->xvmatcode2[$i],
                    'xvuntcode' => $request->xvuntcode2[$i],
                    'XIBomQty' => ($request->XIBomQty2[$i]),
                ]);
            }
        }
            if ($isUploadNew) {
                $request->ImgResize->move(public_path('images'), $imageName);
//                if (File::exists(public_path($request->oldImg))) {
//                    File::delete(public_path($request->oldImg));
//                }
            }
            DB::commit();
            return redirect()->back();
//            return redirect()->route('mat.index');
//            return redirect()->route('mat.edit',['XVPohDocNo'=>$docNo])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function FormUpload($xvpdtcode)
    {
        $hd = DB::table('tmstmproduct')->where('xvpdtcode', '=', $xvpdtcode)->first();
        $size = DB::table('tmstmproductsize')->where('xvpdtcode', '=', $xvpdtcode)->get();
        $images =DB::table('tmstmproductfile')->where('xvpdtcode', '=', $xvpdtcode)->get();
        $pdtLink =DB::table('tmstmproductlink')->where('xvpdtcode', '=', $xvpdtcode)->get();
        $data = [
            'hd' => $hd,
            'size' => $size,
            'images'=>$images,
            'pdtLink'=>$pdtLink
        ];
        return view('MasterItem.frm_upload', $data);
    }

    public function StorePicture(Request $request)
{
    try {
        $fileType = $request->ImageUpload->extension();
        $imageName = $request->xvpdtcode . '_' . time() . '.' . $fileType;
        DB::beginTransaction();
        DB::table('tmstmproductfile')->insert([
            'xvpdtcode' => $request->xvpdtcode,
            'xvpdffile' => "images/" . $imageName,
            'xvpdffiletype' => $fileType,
        ]);
        $request->ImageUpload->move(public_path('images'), $imageName);
        DB::commit();
        return response()->json(['uploaded' => '/images/' . $imageName]);
    } catch (\Exception $e) {
        DB::rollback();
        dd($e);
        abort(500, 'Internal error');
    }
}
    public function deletePicture(Request $request){
        try {
            $imageName = $request->key;
            DB::beginTransaction();
            DB::table('tmstmproductfile')
                ->where('xvpdtcode', '=', $request->xvpdtcode)
                ->where('xvpdffile', '=', $imageName)
                ->delete();
            if (File::exists(public_path($imageName))) {
                File::delete(public_path($imageName));
            }
            DB::commit();
            return response()->json(['deleted' => '/images/' . $imageName]);
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }

    }

    public function StoreLink(Request $request)
    {
        try {
            DB::beginTransaction();
            DB::table('tmstmproductlink')->insert([
                'xvpdtcode' => $request->xvpdtcode,
                'xvpdtlinkname' => $request->xvpdtlinkname,
                'xvpdtlinkurl' =>$request->xvpdtlinkurl,
            ]);
            DB::commit();
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }
    public function DeleteLink(Request $request)
    {
        try {
            DB::beginTransaction();
            DB::table('tmstmproductlink')
                ->where('xvpdtcode','=',$request->xvpdtcode)
                ->where('xvpdtlinkname','=',$request->xvpdtlinkname)
                ->where('xvpdtlinkurl','=',$request->xvpdtlinkurl)
                ->delete();
            DB::commit();
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }
    public function removeImg(Request  $request){
        $docNo = $request->F_Pk;
        $hd = DB::table('tmstmproduct')
            ->where('xvpdtcode', '=', $docNo)
            ->first();
        if($request->xvmatpic == "images/not-found.jpg"){
            return redirect()->back();
        }
        if (File::exists(public_path($hd->XVPdtImg))) {
            File::delete(public_path($hd->XVPdtImg));
        }
        DB::table('tmstmproduct')
            ->where('xvpdtcode', '=', $docNo)
            ->update([
                'XVPdtImg' => "images/not-found.jpg"
            ]);
        return redirect()->back();
    }
}
