<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class MaterialController extends Controller
{
    //
    public function materialType()
    {
        $mattype = DB::table('tmstmmattype')
            ->orderBy('xvmtycode', 'desc')
            ->get()->toArray();
        $data = [
            'mattypes' => $mattype,
        ];
        return view('material.material_type', $data);
    }

    public function addMatType(Request $request)
    {
        //dd($this->genTypeCode());
        DB::beginTransaction();
        try {
            $findName = DB::table('tmstmmattype')->where('xvmtyname', '=', $request->XVMtyName)->get();
            if (count($findName) > 0) {
                return redirect()->route('material_type')->with('msg', 'Duplicate');
            }
            DB::table('tmstmmattype')->insert([
                'xvmtycode' => $this->genTypeCode(),
                'xvmtyname' => $request->XVMtyName,
            ]);
            DB::commit();
            return redirect()->route('material_type')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function editMatType(Request $request)
    {
        $TypeInMaterial = DB::table('tmstmmaterial')->where('xvmtycode','=',$request->XVMtyCode)->count();
        if($TypeInMaterial > 0 ){
            return redirect()->route('material_type')->with('msg', 'busyEdit');
        }
        DB::beginTransaction();
        try {
            $findName = DB::table('tmstmmattype')->where('xvmtyname', '=', $request->XVMtyName)->get();
            if (count($findName) > 0) {
                return redirect()->route('material_type')->with('msg', 'Duplicate');
            }
            DB::table('tmstmmattype')->where('xvmtycode', $request->XVMtyCode)
                ->update([
                    'xvmtyname' => $request->XVMtyName,
                ]);
            DB::commit();
            return redirect()->route('material_type')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function delMatType($id)
    {
        $TypeInMaterial = DB::table('tmstmmaterial')->where('xvmtycode','=',$id)->count();
        if($TypeInMaterial > 0 ){
            return redirect()->route('material_type')->with('msg', 'busy');
        }
        DB::beginTransaction();
        try {
            DB::table('tmstmmattype')->where('xvmtycode', $id)->delete();
            DB::commit();
            return redirect()->route('material_type')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function materialGroup()
    {

        $group = DB::table('TMstMMatGroup')
            ->orderBy('xvmgpcode', 'desc')
            ->get()->toArray();
        $data = ['groups' => $group];
        return view('material.material_group', $data);
    }

    public function addMatGroup(Request $request)
    {
        DB::beginTransaction();
        try {
            $findName = DB::table('tmstmmatgroup')->where('xvmgpname', '=', $request->XVMgpName)->get();
            if (count($findName) > 0) {
                return redirect()->route('material_group')->with('msg', 'Duplicate');
            }
            DB::table('tmstmmatgroup')->insert([
                'xvmgpcode' => $this->genGroupCode(),
                'xvmgpname' => $request->XVMgpName,
            ]);
            DB::commit();
            return redirect()->route('material_group')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function editMatGroup(Request $request)
    {
        $GroupInMaterial = DB::table('tmstmmaterial')->where('xvmgpcode','=',$request->XVMgpCode)->count();
        if($GroupInMaterial > 0 ){
            return redirect()->route('material_group')->with('msg', 'busyEdit');
        }
        DB::beginTransaction();
        try {
            $findName = DB::table('tmstmmatgroup')->where('xvmgpname', '=', $request->XVMgpName)->get();
            if (count($findName) > 0) {
                return redirect()->route('material_group')->with('msg', 'Duplicate');
            }
            DB::table('tmstmmatgroup')->where('xvmgpcode', $request->XVMgpCode)
                ->update([
                    'xvmgpname' => $request->XVMgpName,
                ]);
            DB::commit();
            return redirect()->route('material_group')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function delMatGroup($id)
    {
        $GroupInMaterial = DB::table('tmstmmaterial')->where('xvmgpcode','=',$id)->count();
        if($GroupInMaterial > 0 ){
            return redirect()->route('material_group')->with('msg', 'busy');
        }
        DB::beginTransaction();
        try {
            DB::table('tmstmmatgroup')->where('xvmgpcode', $id)->delete();
            DB::commit();
            return redirect()->route('material_group')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function materialUnit()
    {
        $unit = DB::table('tmstmunit')
            ->orderBy('xvuntcode', 'desc')
            ->get()->toArray();
        $data = [
            'units' => $unit,
        ];
        return view('material.material_unit', $data);
    }

    public function addMatUnit(Request $request)
    {
        //dd($this->genUnitCode());
        DB::beginTransaction();
        try {
            $findName = DB::table('tmstmunit')->where('xvuntname', '=', $request->xvuntname)->get();
            if (count($findName) > 0) {
                return redirect()->route('material_unit')->with('msg', 'Duplicate');
            }
            DB::table('tmstmunit')->insert([
                'xvuntcode' => $this->genUnitCode(),
                'xvuntname' => $request->xvuntname,
            ]);
            DB::commit();
            return redirect()->route('material_unit')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function editMatUnit(Request $request)
    {

        DB::beginTransaction();
        try {
            $UnitInMatUnit = DB::table('tmstmmat_unit')->where('xvuntcode','=',$request->xvuntcode)->count();
            if($UnitInMatUnit > 0 ){
                return redirect()->route('material_unit')->with('msg', 'busyEdit');
            }

            $findName = DB::table('tmstmunit')->where('xvuntname', '=', $request->xvuntname)->get();
            if (count($findName) > 0) {
                return redirect()->route('material_unit')->with('msg', 'Duplicate');
            }
            DB::table('tmstmunit')->where('xvuntcode', $request->xvuntcode)
                ->update([
                    'xvuntname' => $request->xvuntname,
                ]);
            DB::commit();
            return redirect()->route('material_unit')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function delMatUnit($id)
    {
        $UnitInMatUnit = DB::table('tmstmmat_unit')->where('xvuntcode','=',$id)->count();
        if($UnitInMatUnit > 0 ){
            return redirect()->route('material_unit')->with('msg', 'busy');
        }
        DB::beginTransaction();
        try {
            DB::table('tmstmunit')->where('xvuntcode', $id)->delete();
            DB::commit();
            return redirect()->route('material_unit')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function material()
    {
        $mat = DB::table('tmstmmaterial')
            ->leftjoin('tmstmmattype', 'tmstmmattype.xvmtycode', 'tmstmmaterial.xvmtycode')
            ->leftjoin('tmstmmatgroup', 'tmstmmatgroup.xvmgpcode', 'tmstmmaterial.xvmgpcode')
            ->leftjoin('tmstmsupplier', 'tmstmsupplier.XVSplCode', 'tmstmmaterial.xvsplcode')
            ->get()->toArray();
        //dd($mat);
        $unit = DB::table('tmstmunit')->get()->toArray();
        $mat_unit = DB::table('tmstmmat_unit')
            ->leftjoin('tmstmunit', 'tmstmunit.xvuntcode', 'tmstmmat_unit.xvuntcode')
            ->get()->toArray();
        // dd($mat_unit);
        $data = [
            'mats' => $mat,
            'units' => $unit,
            'mat_units' => $mat_unit,
        ];
        return view('material.material', $data);
    }

    public function frm_add_material()
    {
        $type = DB::table('tmstmmattype')->get()->toArray();
        $group = DB::table('tmstmmatgroup')->get()->toArray();
        $data = [
            'spls' => $this->getSupplier(),
            'types' => $type,
            'groups' => $group,
        ];
        return view('material.frm_add_material', $data);
    }

    public function frm_edit_material($id)
    {

        $type = DB::table('tmstmmattype')->get()->toArray();
        $group = DB::table('tmstmmatgroup')->get()->toArray();
        $mat = DB::table('tmstmmaterial')->where('xvmatcode', $id)->first();
        $data = [
            'spls' => $this->getSupplier(),
            'types' => $type,
            'groups' => $group,
            'mat' => $mat,
        ];
        return view('material.frm_edit_material', $data);
    }

    public function addMat(Request $request)
    {

        $chk = DB::table('tmstmmaterial')->where('xvmatcode', $request->xvmatcode)->count();
        if ($chk > 0) {
            return redirect()->route('material')->with('msg', 'warning');
        } else {
            DB::beginTransaction();
            try {

                DB::table('tmstmmaterial')->insert([
                    'xvmatcode' => $request->xvmatcode,
                    'xvmatname' => $request->xvmatname,
                    'xvmtycode' => $request->xvmtycode,
                    'xvmgpcode' => $request->xvmgpcode,
                    'xvsplcode' => $request->xvsplcode,
                    'xvmatdes' => $request->xvmatdes,
                ]);
                DB::commit();
                return redirect()->route('material')->with('msg', 'success');
            } catch (\Exception $e) {
                DB::rollback();
                abort(500, 'Internal error');
            }
        }
    }

    public function delMatMat($xvmatcode, $xvuntcode)
    {
        DB::beginTransaction();
        try {
            DB::table('tmstmmat_unit')
                ->where('xvmatcode', $xvmatcode)
                ->where('xvuntcode', $xvuntcode)->delete();
            DB::commit();
            return redirect()->route('material')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function editMat(Request $request)
    {
        DB::beginTransaction();
        try {

            DB::table('tmstmmaterial')->where('xvmatcode', $request->xvmatcode)->update([
                'xvmatcode' => $request->xvmatcode,
                'xvmatname' => $request->xvmatname,
                'xvmtycode' => $request->xvmtycode,
                'xvmgpcode' => $request->xvmgpcode,
                'xvsplcode' => $request->xvsplcode,
                'xvmatdes' => $request->xvmatdes,
            ]);
            DB::commit();
            return redirect()->route('material')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function delMat($id)
    {
        DB::beginTransaction();
        try {
            DB::table('tmstmmaterial')->where('xvmatcode', $id)->delete();
            DB::commit();
            return redirect()->route('material')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function addMatMat(Request $request)
    {
        //dd($request->all());
        DB::beginTransaction();
        try {
            if ($request->xvuntcode == "") {
                return redirect()->route('material')->with('msg', 'NoDataFound');
            }
            if ($request->ximunfactor == "") {
                return redirect()->route('material')->with('msg', 'NoDataFound_Factor');
            }
            DB::table('tmstmmat_unit')->insert([
                'xvmatcode' => $request->xvmatcode,
                'xvuntcode' => $request->xvuntcode,
                'ximunfactor' => $request->ximunfactor,
            ]);
            DB::commit();
            return redirect()->route('material')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            if ($e->getCode() == '23000') {
                return redirect()->route('material')->with('msg', 'error_duplicate');
            } else {
                abort(500, 'Internal error');
            }
        }
    }

    public function getSupplier()
    {
        $spl = DB::table('tmstmsupplier')->get()->toArray();
        return $spl;
    }

    public function genUnitCode()
    {
        $unit = DB::table('tmstmunit')->orderBy('xvuntcode', 'DESC')->first();
        if ($unit == null) {
            $num = 1;
        } else {
            $num = substr($unit->xvuntcode, -3) + 1;
        }
        $xvuntcode = sprintf('Mgp-' . '%03d', $num);
        return $xvuntcode;
    }

    public function genTypeCode()
    {
        $type = DB::table('tmstmmattype')->orderBy('xvmtycode', 'DESC')->first();
        if ($type == null) {
            $num = 1;
        } else {
            $num = substr($type->xvmtycode, -3) + 1;
        }
        $XVMtyCode = sprintf('MatType-' . '%03d', $num);
        return $XVMtyCode;
    }

    public function genGroupCode()
    {
        $group = DB::table('tmstmmatgroup')->orderBy('xvmgpcode', 'DESC')->first();
        if ($group == null) {
            $num = 1;
        } else {
            $num = substr($group->xvmgpcode, -3) + 1;
        }
        $XVMgpCode = sprintf('Mgp-' . '%03d', $num);
        return $XVMgpCode;
    }
}
