<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MaterialsController extends Controller
{
    public function index()
    {
        $HD = DB::table('tmstmmaterial')
            ->leftjoin('tmstmsupplier', 'tmstmmaterial.XVSplCode', 'tmstmsupplier.XVSplCode')
            ->leftjoin('tmstmmattype', 'tmstmmaterial.xvmtycode', 'tmstmmattype.xvmtycode')
            ->leftjoin('tmstmmatgroup', 'tmstmmaterial.xvmgpcode', 'tmstmmatgroup.xvmgpcode')
            ->orderBy('xvmatcode', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
        ];
        return view('Materials.index', $data);
    }

    public function FormInsert()
    {
        return view('Materials.frm_add');
    }

    public function FormEdit($xvmatcode)
    {
        $hd = DB::table('tmstmmaterial')->where('xvmatcode', '=', $xvmatcode)->first();
        $dt = DB::table('tmstmmat_unit')
            ->where('xvmatcode', '=', $xvmatcode)
            ->join('tmstmunit', 'tmstmmat_unit.xvuntcode', 'tmstmunit.xvuntcode')
            ->get();
        $matsup = DB::table('tmnymmatsup')
            ->where('xvmatcode', '=', $xvmatcode)
            ->leftjoin('tmstmsupplier', 'tmnymmatsup.XVSplCode', 'tmstmsupplier.XVSplCode')
            ->get();
        return view('Materials.frm_edit', [
            'hd' => $hd,
            'dt' => $dt,
            'matsup'=>$matsup
        ]);
    }

    public function Store(Request $request)
    {
        try {
            $docNo = GeneratePrimaryKeyDate('tmstmmaterial', 'xvmatcode', 'Mat');
            $isDup = $this->checkDup($request->XVSplCode,$request->xvmatname,$docNo);
            if($isDup){
                return redirect()->back()->with('msg', 'Duplicate');
            }
            if(isset($request->ImgResize)){
                $imageName = time() . '.' . $request->ImgResize->extension();
            }else{
                $imageName = "not-found.jpg";
            }
            DB::beginTransaction();
            DB::table('tmstmmaterial')->insert([
                'xvmatcode' => $docNo,
                'xvmatname' => $request->xvmatname,
                'xvmatdes' => $request->xvmatdes,
                'xvmtycode' => $request->SelectMaterialType,
                'xvmgpcode' => $request->SelectMaterialGroup,
                // 'XVSplCode' => $request->XVSplCode,
                'xvmatpic' => "images/" . $imageName

            ]);

            for ($i = 0; $i < count($request->xvuntcode); $i++) {
                DB::table('tmstmmat_unit')->insert([
                    'xvmatcode' => $docNo,
                    'xvuntcode' => $request->xvuntcode[$i],
                    'ximunfactor' => $request->ximunfactor[$i],
                    'xfmunprice' => $request->xfmunprice[$i]
                ]);
            }
            if(isset($request->xvsupcode))
            {
            for ($i = 0; $i < count($request->xvsupcode); $i++) {
                DB::table('tmnymmatsup')->insert([
                    'xvmatcode' => $docNo,
                    'XVSplCode' => $request->xvsupcode[$i],
                ]);
            }
        }
            DB::commit();
            if(isset($request->ImgResize)){
                $request->ImgResize->move(public_path('images'), $imageName);
            }
            return redirect()->route('mat.index');
//            return redirect()->route('mat.edit',['XVPohDocNo'=>$docNo])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }

    }

    public function Update(Request $request)
    {
        try {
            $docNo = $request->xvmatcode;

            $isDup = $this->checkDup($request->XVSplCode,$request->xvmatname,$docNo);
            if($isDup){
                return redirect()->back()->with('msg', 'Duplicate');
            }
            $isUploadNew = false;
            if (isset($request->ImgResize)) {
                $isUploadNew =true;
                $imageName = time() . '.' . $request->ImgResize->extension();
            }else{
                $imageName = $request->oldImg;
            }

            DB::beginTransaction();
            DB::table('tmstmmaterial')
                ->where('xvmatcode', '=', $docNo)
                ->update([
                    'xvmatname' => $request->xvmatname,
                    'xvmatdes' => $request->xvmatdes,
                    'xvmtycode' => $request->SelectMaterialType,
                    'xvmgpcode' => $request->SelectMaterialGroup,
                    'XVSplCode' => $request->XVSplCode,
                    'xvmatpic' => $isUploadNew ? "images/" . $imageName : $imageName

                ]);
            DB::table('tmstmmat_unit')
                ->where('xvmatcode', '=', $docNo)
                ->delete();
            for ($i = 0; $i < count($request->xvuntcode); $i++) {
                DB::table('tmstmmat_unit')->insert([
                    'xvmatcode' => $docNo,
                    'xvuntcode' => $request->xvuntcode[$i],
                    'ximunfactor' => $request->ximunfactor[$i],
                    'xfmunprice' => $request->xfmunprice[$i]
                ]);
            }
            DB::table('tmnymmatsup')
            ->where('xvmatcode',$docNo)
                ->delete();
            for ($i = 0; $i < count($request->xvsupcode); $i++) {
                DB::table('tmnymmatsup')->insert([
                    'xvmatcode' => $docNo,
                    'XVSplCode' => $request->xvsupcode[$i],
                ]);
            }
            if ($isUploadNew){
                $request->ImgResize->move(public_path('images'), $imageName);
//                if (File::exists(public_path($request->oldImg))) {
//                    File::delete(public_path($request->oldImg));
//                }
            }
            DB::commit();
            return redirect()->back();
//            return redirect()->route('mat.index');
//            return redirect()->route('mat.edit',['XVPohDocNo'=>$docNo])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }
    public function checkDup($XVSplCode,$xvmatname,$xvmatcode){
        $checkDuplicate = DB::table('tmstmmaterial')
            ->where('XVSplCode','=',$XVSplCode)
            ->where('xvmatname','=',$xvmatname)
            ->where('xvmatcode','!=',$xvmatcode)
            ->get();
        if(count($checkDuplicate)>0){
            return true;
        }else{
            return false;
        }
    }
    public function removeImg(Request  $request){
        $docNo = $request->F_pk_xvmatcode;
        $hd = DB::table('tmstmmaterial')
            ->where('xvmatcode', '=', $docNo)
            ->first();
        if($request->xvmatpic == "images/not-found.jpg"){
            return redirect()->back();
        }
        if (File::exists(public_path($hd->xvmatpic))) {
            File::delete(public_path($hd->xvmatpic));
        }
        DB::table('tmstmmaterial')
            ->where('xvmatcode', '=', $docNo)
            ->update([
                'xvmatpic' => "images/not-found.jpg"
            ]);
        return redirect()->back();
    }
}
