<?php

namespace App\Http\Controllers;

use App\Helper\Helper;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Session;
//use App\Helper\Helper;

class OrderController extends Controller
{
    public function __construct()
    {
        $this->BomeSize = new BomSizeController();
    }

    public function index()
    {
        $roleperm = Session::get('role_perm') ?? [];

        if (in_array(20,$roleperm))
        {
            $product = DB::table('TDocTOrHD')
            ->where('XVOrhDocStatus', '=', '2')
            ->orWhere('XVOrhDocStatus', '=', '3')
            ->leftJoin('tmstmcustomer', 'TDocTOrHD.XVCstCode', 'tmstmcustomer.XVCstCode')
            ->leftJoin('tmstmproduct', 'TDocTOrHD.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->orderBy('XVOrhDocNo', 'desc')
            ->get();
        }
        else {
            $product = DB::table('TDocTOrHD')
            ->leftJoin('tmstmcustomer', 'TDocTOrHD.XVCstCode', 'tmstmcustomer.XVCstCode')
            ->leftJoin('tmstmproduct', 'TDocTOrHD.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->orderBy('XVOrhDocNo', 'desc')
            ->get();
        }
       
        $data = [
            'products' => $product,
        ];
        return view('order.index', $data);
    }

    public function Approveindex()
    {
        $product = DB::table('TDocTOrHD')
            ->leftJoin('tmstmcustomer', 'TDocTOrHD.XVCstCode', 'tmstmcustomer.XVCstCode')
            ->leftJoin('tmstmproduct', 'TDocTOrHD.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->orderBy('XVOrhDocNo', 'desc')
            ->Where('XVOrhDocStatus','2')
            ->get();
        $data = [
            'products' => $product,
        ];
        return view('order.index', $data);
    }
       


    public function FormInsert()
    {
        return view('order.frm_add');
    }

    public function FormEdit($XVOrhDocNo)
    {
        $xvpdtcode = null;
        $hd = DB::table('TDocTOrHD')
            ->where('XVOrhDocNo', '=', $XVOrhDocNo)
            ->first();
        $pdtImg = DB::table('tmstmproduct')
            ->where('xvpdtcode', '=', $hd->xvpdtcode)
            ->select('XVPdtImg')
            ->first();
        $img = $hd->XVOrhImg ?? $pdtImg->XVPdtImg;
        $xvpdtcode = $hd->xvpdtcode;
        $dt = DB::table('TDocTOrDT')
            ->where('XVOrhDocNo', '=', $XVOrhDocNo)
            ->join('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
            ->get();
        foreach ($dt as $item) {
            $item->Mt = DB::table('TDocTOrMT')
                ->where('XVOrhDocNo', '=', $XVOrhDocNo)
                ->where('XVPszName', '=', $item->XVPszName)
                ->join('tmstmmaterial', 'TDocTOrMT.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
                ->join('tmstmunit', 'TDocTOrMT.xvuntcode', '=', 'tmstmunit.xvuntcode')
                ->get()->toArray();
        }
        return view('order.frm_edit', [
            'hd' => $hd,
            'dt' => $dt,
            'xvpdtcode' => $xvpdtcode,
            'DocStatus' => $hd->XVOrhDocStatus,
            'imgUrl'=>$img
        ]);
    }

    public function Store(Request $request)
    {
        $isupload = false;
        if (isset($request->ImgResize)) {
            $isupload=true;
            $imageName = time() . '.' . $request->ImgResize->extension();
        } else {
            $pdtImg = DB::table('tmstmproduct')
                ->where('xvpdtcode', '=', $request->SelectMasterItems)
                ->select('XVPdtImg')
                ->first();
            $imageName = $pdtImg->XVPdtImg;
        }
        $date = Carbon::createFromFormat('d-m-Y', $request->XDOrhDocDate);
        $XDOrhDocDateReceive = Carbon::createFromFormat('d-m-Y', $request->XDOrhDocDateReceive);

        try {
            DB::beginTransaction();
            $code = GeneratePrimaryKeyDate('TDocTOrHD', 'XVOrhDocNo', 'OR',2);
            DB::table('TDocTOrHD')->insert([
                'XVOrhDocNo' => $code,
                'XDOrhDocDate' => $date->format('Y-m-d'),
                'XDOrhDocDateReceive' => $XDOrhDocDateReceive->format('Y-m-d'),
                'XVCstCode' => $request->XVCstCode,
                'XVOrhDocStatus' => 1,
//                New Req
                'XVOrhCutter' => $request->XVOrhCutter,
                'XVPdtCmtDetail' => $request->XVPdtCmtDetail,
                'XVPdtCmtDetailMore' => $request->XVPdtCmtDetailMore,
                'XVPdtCmtZipSize' => $request->XVPdtCmtZipSize,
                'XVPdtCmtButton' => $request->XVPdtCmtButton,
                'XVPdtCmtSecretBag' => $request->XVPdtCmtSecretBag,
                'XVPdtCmtBackPocket' => $request->XVPdtCmtBackPocket,
                'XVPdtCmtEarSize' => $request->XVPdtCmtEarSize,
                'XVPdtCmtSewing' => $request->XVPdtCmtSewing,
                'XVPdtCmtTwill' => $request->XVPdtCmtTwill,
                'XVPdtCmtTagging' => $request->XVPdtCmtTagging,
                'XVPdtCmtTung' => $request->XVPdtCmtTung,
                'XVPohDocRmk' => $request->XVPohDocRmk,
                'XVPdtCmtSpecial' => $request->XVPdtCmtSpecial,
                'xvpdtcode' => $request->SelectMasterItems,
                'XVOrderNo' => $request->XVOrderNo,
                'XVOrderYear' => $request->XVOrderYear,
                'XVOrhImg'=>$isupload ? "images/" . $imageName : $imageName
            ]);
            foreach ($request->XVPszName as $key => $item) {
                DB::table('TDocTOrDT')->insert([
                    'XVOrhDocNo' => $code,
                    'xvpdtcode' => $request->xvpdtcode[$key][0],
                    'XVPszName' => $request->XVPszName[$key][0],
                    'XIOrdQty' => $request->XIOrdQty[$key][0],
                ]);
                foreach ($request->xvmatcode[$key] as $key1 => $itemMat) {

                    DB::table('TDocTOrMT')->insert([
                        'XVOrhDocNo' => $code,
                        'xvpdtcode' => $request->xvpdtcode[$key][0],
                        'XVPszName' => $request->XVPszName[$key][0],
                        'xvmatcode' => $itemMat,
                        'xvuntcode' => $request->xvuntcode[$key][$key1],
                        'XIOrmFactor' => $request->XIBomQty[$key][$key1],
                        'XIOrmQtyBom' => $request->XIOrmFactor[$key][$key1],
                        'XIOrmQtyStock' => 0,
                        'XIOrmQtyNeed' => 0,
                    ]);
                }
            }
            if (isset($request->ImgResize)) {
                $request->ImgResize->move(public_path('images'), $imageName);
            }
            DB::commit();
            return redirect()->route('order.edit', ['XVOrhDocNo' => $code])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function Update(Request $request)
    {
        $date = Carbon::createFromFormat('d-m-Y', $request->XDOrhDocDate);
        $XDOrhDocDateReceive = Carbon::createFromFormat('d-m-Y', $request->XDOrhDocDateReceive);
        try {
//            dd($request->all());

            $isUploadNew = false;
            if (isset($request->ImgResize)) {
                $isUploadNew = true;
                $imageName = time() . '.' . $request->ImgResize->extension();
            } else {
                $imageName = $request->oldImg;
            }
            DB::beginTransaction();
            $code = $request->XVOrhDocNo;
            DB::table('TDocTOrHD')
                ->where('XVOrhDocNo', '=', $code)
                ->update([
                    'XDOrhDocDate' => $date->format('Y-m-d'),
                    'XDOrhDocDateReceive' => $XDOrhDocDateReceive->format('Y-m-d'),
                    'XVCstCode' => $request->XVCstCode,
//                New Req
                    'XVOrhCutter' => $request->XVOrhCutter,
                    'XVPdtCmtDetail' => $request->XVPdtCmtDetail,
                    'XVPdtCmtDetailMore' => $request->XVPdtCmtDetailMore,
                    'XVPdtCmtZipSize' => $request->XVPdtCmtZipSize,
                    'XVPdtCmtButton' => $request->XVPdtCmtButton,
                    'XVPdtCmtSecretBag' => $request->XVPdtCmtSecretBag,
                    'XVPdtCmtBackPocket' => $request->XVPdtCmtBackPocket,
                    'XVPdtCmtEarSize' => $request->XVPdtCmtEarSize,
                    'XVPdtCmtSewing' => $request->XVPdtCmtSewing,
                    'XVPdtCmtTwill' => $request->XVPdtCmtTwill,
                    'XVPdtCmtTagging' => $request->XVPdtCmtTagging,
                    'XVPdtCmtTung' => $request->XVPdtCmtTung,
                    'XVPohDocRmk' => $request->XVPohDocRmk,
                    'XVPdtCmtSpecial' => $request->XVPdtCmtSpecial,
                    'xvpdtcode' => $request->SelectMasterItems,
                    'XVOrderNo' => $request->XVOrderNo,
                    'XVOrderYear' => $request->XVOrderYear,
                    'XVOrhImg' => $isUploadNew ? "images/" . $imageName : $imageName,
                ]);
            DB::table('TDocTOrDT')
                ->where('XVOrhDocNo', '=', $code)
                ->delete();
            DB::table('TDocTOrMT')
                ->where('XVOrhDocNo', '=', $code)
                ->delete();
            foreach ($request->XVPszName as $key => $item) {
                DB::table('TDocTOrDT')->insert([
                    'XVOrhDocNo' => $code,
                    'xvpdtcode' => $request->xvpdtcode[$key][0],
                    'XVPszName' => $request->XVPszName[$key][0],
                    'XIOrdQty' => $request->XIOrdQty[$key][0],
                ]);
                foreach ($request->xvmatcode[$key] as $key1 => $itemMat) {
                    DB::table('TDocTOrMT')->insert([
                        'XVOrhDocNo' => $code,
                        'xvpdtcode' => $request->xvpdtcode[$key][0],
                        'XVPszName' => $request->XVPszName[$key][0],
                        'xvmatcode' => $itemMat,
                        'xvuntcode' => $request->xvuntcode[$key][$key1],
                        'XIOrmFactor' => $request->XIBomQty[$key][$key1],
                        'XIOrmQtyBom' => $request->XIOrmFactor[$key][$key1],
                        'XIOrmQtyStock' => 0,
                        'XIOrmQtyNeed' => 0,
                    ]);
                }
            }
            if ($isUploadNew) {
                $request->ImgResize->move(public_path('images'), $imageName);
//                if (File::exists(public_path($request->oldImg))) {
//                    File::delete(public_path($request->oldImg));
//                }
            }
            DB::commit();
            return redirect()->back()->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function ChangeStatus(Request $request)
    {
        try {
            DB::beginTransaction();
            $docNo = $request->XVOrhDocNo;
            $requestChange = $request->eventRequest;
            $TDocTOrHD = DB::table('TDocTOrHD')
                ->where('XVOrhDocNo', '=', $docNo)
                ->first();
            $DocStatus = $TDocTOrHD->XVOrhDocStatus;
            switch ($requestChange) {
                case '2' : // Ask for Approve
                    if (canItBeSave($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 1 or 4
                        // Do Someting
                    }
                    break;
                case '3' :  // Approve
                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                        $mtQ = DB::table('TDocTOrMT')
                            ->where('XVOrhDocNo', '=', $docNo)
                            ->groupBy('TDocTOrMT.xvmatcode', 'TDocTOrMT.xvuntcode')
                            ->select('TDocTOrMT.xvmatcode', DB::raw('SUM(XIOrmQtyBom) as SumQty'))
                            ->join('tmstmmaterial', 'TDocTOrMT.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
                            ->join('tmstmunit', 'TDocTOrMT.xvuntcode', '=', 'tmstmunit.xvuntcode')
                            ->get()->toArray();
                        $DT = DB::table('TDocTOrDT')
                            ->where('XVOrhDocNo', '=', $docNo)
                            ->first();
                        foreach ($mtQ as $key => $item){
                            $itemStockMat = DB::table('tstktmatstockcard')
                                    ->where('xvmatcode', '=', $item->xvmatcode)
                                    ->where('xistkqtyleft', '!=', 0)
                                    ->select(DB::raw('SUM(xistkqtyleft) as SumQtyStk'))
                                    ->first();
                            $item->InStock = $itemStockMat->SumQtyStk ?? 0 ;
                            DB::table('TDocTOrMT')
                                ->where('XVOrhDocNo', '=', $docNo)
                                ->where('XVPszName', '=', $DT->XVPszName)
                                ->where('xvmatcode', '=', $item->xvmatcode)
                                ->update([
                                    'XIOrmQtyStock'=>$item->InStock,
                                    'XIOrmQtyNeed'=>$item->SumQty-$item->InStock,
                                ]);
                        }

//                    $OrMT
//                    dd($TDocTOrHD);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '4' : // Requeste Change
                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '5' :
                    if (canItBe_Cancle($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't ( 1 , 2 , 4)
                        // Do Someting
                    }
                case '6' :
                    if (canItBe_Expire($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't ( 3)
                        // Do Someting
                    }
                    break;
            }
            DB::commit();
            return redirect()->back();

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }

    }

    public function UpdateStatus($docNo, $docStatus)
    {
        DB::table('TDocTOrHD')
            ->where('XVOrhDocNo', '=', $docNo)
            ->update([
                'XVOrhDocStatus' => $docStatus
            ]);
    }

    public function getOldDataByDocNO($docNo)
    {
        $hd_Pure = DB::table('TDocTOrHD')
            ->where('TDocTOrHD.XVOrhDocNo', '=', $docNo)
            ->first();
        $hd = DB::table('TDocTOrHD')
            ->where('TDocTOrHD.XVOrhDocNo', '=', $docNo)
            ->join('tmstmcustomer','TDocTOrHD.XVCstCode','tmstmcustomer.XVCstCode')
            ->join('tmstmproduct','TDocTOrHD.xvpdtcode','tmstmproduct.xvpdtcode')
            ->join('tmforuse','tmstmproduct.XIForCode','tmforuse.XIForCode')
            ->join('tmgenerate','tmstmproduct.XIGenerateCode','tmgenerate.XIGenerateCode')
            ->join('tmseason','tmstmproduct.XISeasonCode','tmseason.XISeasonCode')
            ->join('tmshape','tmstmproduct.XIShapeCode','tmshape.XIShapeCode')
            ->join('TMstMMaterial','tmstmproduct.xvmatcode','TMstMMaterial.xvmatcode')
            ->first();
        $dt = DB::table('TDocTOrDT')
            ->where('XVOrhDocNo', '=', $docNo)
            ->join('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
            ->get();
        $mt = DB::table('TDocTOrMT')
            ->where('XVOrhDocNo', '=', $docNo)
            ->join('tmstmmaterial', 'TDocTOrMT.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
            ->join('tmstmunit', 'TDocTOrMT.xvuntcode', '=', 'tmstmunit.xvuntcode')
            ->get()->toArray();
        $data = [
            'hd' => $hd,
            'hdPure'=>$hd_Pure,
            'dt' => $dt,
            'mt' => $mt
        ];
        return response()->json($data);
    }
    public function getOldDataByDocNOPDFBoom($docNo)
    {
        $hd_Pure = DB::table('TDocTOrHD')
            ->where('TDocTOrHD.XVOrhDocNo', '=', $docNo)
            ->first();
        $hd = DB::table('TDocTOrHD')
            ->where('TDocTOrHD.XVOrhDocNo', '=', $docNo)
            ->join('tmstmcustomer','TDocTOrHD.XVCstCode','tmstmcustomer.XVCstCode')
            ->join('tmstmproduct','TDocTOrHD.xvpdtcode','tmstmproduct.xvpdtcode')
            ->join('tmforuse','tmstmproduct.XIForCode','tmforuse.XIForCode')
            ->join('tmgenerate','tmstmproduct.XIGenerateCode','tmgenerate.XIGenerateCode')
            ->join('tmseason','tmstmproduct.XISeasonCode','tmseason.XISeasonCode')
            ->join('tmshape','tmstmproduct.XIShapeCode','tmshape.XIShapeCode')
            ->join('TMstMMaterial','tmstmproduct.xvmatcode','TMstMMaterial.xvmatcode')
            ->first();
        $dt = DB::table('TDocTOrDT')
            ->where('XVOrhDocNo', '=', $docNo)
            ->join('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
            ->get();
        $mt = DB::table('TDocTOrMT')
            ->where('XVOrhDocNo', '=', $docNo)
            ->join('tmstmmaterial', 'TDocTOrMT.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
            ->join('tmstmunit', 'TDocTOrMT.xvuntcode', '=', 'tmstmunit.xvuntcode')
            ->get()->toArray();
        $data = [
            'hd' => $hd,
            'hdPure'=>$hd_Pure,
            'dt' => $dt,
            'mt' => $mt
        ];
        return response()->json($data);
    }
    public function getDataForPDFBOM($docNo)
    {
        $hd_Pure = DB::table('TDocTOrHD')
            ->where('TDocTOrHD.XVOrhDocNo', '=', $docNo)
            ->first();
        $hd = DB::table('TDocTOrHD')
            ->where('TDocTOrHD.XVOrhDocNo', '=', $docNo)
            ->join('tmstmcustomer','TDocTOrHD.XVCstCode','tmstmcustomer.XVCstCode')
            ->join('tmstmproduct','TDocTOrHD.xvpdtcode','tmstmproduct.xvpdtcode')
            ->join('tmforuse','tmstmproduct.XIForCode','tmforuse.XIForCode')
            ->join('tmgenerate','tmstmproduct.XIGenerateCode','tmgenerate.XIGenerateCode')
            ->join('tmseason','tmstmproduct.XISeasonCode','tmseason.XISeasonCode')
            ->join('tmshape','tmstmproduct.XIShapeCode','tmshape.XIShapeCode')
            ->join('TMstMMaterial','tmstmproduct.xvmatcode','TMstMMaterial.xvmatcode')
            ->first();
        $dt = DB::table('TDocTOrDT')
            ->where('XVOrhDocNo', '=', $docNo)
            ->join('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
            ->get();
        $mt = DB::table('TDocTOrMT')
            ->where('XVOrhDocNo', '=', $docNo)
            ->join('tmstmmaterial', 'TDocTOrMT.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
            ->join('tmstmunit', 'TDocTOrMT.xvuntcode', '=', 'tmstmunit.xvuntcode')
            ->get()->toArray();
        $mtCreate = DB::table('TDocTOrMT')
            ->where('XVOrhDocNo', '=', $docNo)
            ->where('xvmtycode', '=', 'MatType-001')
            ->groupBy('TDocTOrMT.xvmatcode','TDocTOrMT.xvuntcode')
            ->select('TDocTOrMT.*',DB::raw('SUM(XIOrmQtyBom) as SumQty'),'tmstmmaterial.*','tmstmunit.*')
            ->join('tmstmmaterial', 'TDocTOrMT.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
            ->join('tmstmunit', 'TDocTOrMT.xvuntcode', '=', 'tmstmunit.xvuntcode')
            ->get()->toArray();
        $mtPack = DB::table('TDocTOrMT')
            ->where('XVOrhDocNo', '=', $docNo)
            ->where('xvmtycode', '=', 'MatType-002')
            ->groupBy('TDocTOrMT.xvmatcode','TDocTOrMT.xvuntcode')
            ->select('TDocTOrMT.*',DB::raw('SUM(XIOrmQtyBom) as SumQty'),'tmstmmaterial.*','tmstmunit.*')
            ->join('tmstmmaterial', 'TDocTOrMT.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
            ->join('tmstmunit', 'TDocTOrMT.xvuntcode', '=', 'tmstmunit.xvuntcode')
            ->get()->toArray();
//        dd($mt);
        $data = [
            'hd' => $hd,
            'hdPure'=>$hd_Pure,
            'dt' => $dt,
            'mt' => $mt,
            'mtCreate'=>$mtCreate,
            'mtPack'=>$mtPack 
        ];
        return response()->json($data);
    }

}
