<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report306Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index306');
    }
    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MatStart = $request->input('MatStart');
        $MatEnd = $request->input('MatEnd');
        $isAllMat = $request->input("isAllMat") === 'true' ? true : false;
        //        Section Data
        $material = DB::table('tmstmmaterial');
        $material = condition_LCR($material, 'xvmatcode', $isAllMat, $MatStart, $MatEnd);
        foreach ($material as $item) {
            $OrderHD =DB::table('tdoctgidt')
                ->leftJoin('tdoctgihd','tdoctgidt.XVGihDocNo','tdoctgihd.XVGihDocNo')
                ->where('XVGihDocStatus', '=', '3')
                ->where('tdoctgidt.xvmatcode', '=', $item->xvmatcode)
                ->select('tdoctgidt.XVGihDocNo', 'XIGidQty', 'XIGidQtyOr','XDGihDocDate');
            $OrderHD = condition_LCR($OrderHD, 'XDGihDocDate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($material);
    }
    public function datexcel(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MatStart = $request->input('MatStart');
        $MatEnd = $request->input('MatEnd');
        $isAllMat = $request->input("isAllMat") === 'true' ? true : false;
        //        Section Data
        $material = DB::table('tdoctgidt')
                 ->Join('tdoctgihd', 'tdoctgidt.XVGihDocNo', 'tdoctgihd.XVGihDocNo')
                 ->Join('tmstmmaterial','tdoctgidt.xvmatcode','tmstmmaterial.xvmatcode')
                ->where('XVGihDocStatus', '=', '3');
                
         $material = condition_LCRVOutide($material, 'tdoctgidt.xvmatcode', $isAllMat, $MatStart, $MatEnd);
         $material = condition_LCR($material, 'XDGihDocDate', $isAllTime, $DateStart, $DateEnd);

        return response()->json($material);
    }
}
