// import {selfRowTotal} from'./LogicCalculate.js'
$(document).ready(function () {
    $('#datepicker').datepicker({
        uiLibrary: 'bootstrap4',
        format: 'dd-mm-yyyy'
    });
    $('#datepicker1').datepicker({
        uiLibrary: 'bootstrap4',
        format: 'dd-mm-yyyy'
    });


    let SelectedFarbic;
    let DT = $('#SelectMaterial').on('select2:select', function (e) {
        var {id, text} = (e.params.data);
        let unitType = JSON.parse(e.params.data?.element?.attributes[1]?.nodeValue) ?? [];
        let img = (e.params.data?.element?.attributes[2]?.nodeValue) ?? null;
        createRowTable(id, text, unitType, img)
    });
    $('#SelectPureMaterial').on('select2:select', function (e) {
        var {id, text} = (e.params.data);
        if (SelectedFarbic) {
            removeRow(SelectedFarbic)
        }
        SelectedFarbic = id;
        let unitType = JSON.parse(e.params.data?.element?.attributes[0]?.nodeValue) ?? [];
        let img = (e.params.data?.element?.attributes[1]?.nodeValue).length > 0 ? (e.params.data?.element?.attributes[1]?.nodeValue) : null;
        createRowTable(id, text, unitType, img, true)
    });
   
    window.TriggerChange = function (oldArr) {
        DT.val(oldArr).trigger("change");
    }
    window.TriggerFarbic = function (oldArr) {
        SelectedFarbic = oldArr;
        $('#SelectPureMaterial').val(oldArr).trigger("change")
    }
    window.RemoveSelectedFarbic = function () {
        SelectedFarbic = null;
        $('#SelectPureMaterial').val(null).trigger("change")
    }

});

function createRowTable(id, text, unitType, img, isFarbic = false) {
    const url = document.getElementById("CurrentUrl").value;
    let str = text.replace(/ /g, '');
    str = replaceQuotes(str);
    let txt = str.split(":");
    let unitOption = renderOption(unitType, 'xvuntcode', 'xvuntname', 'xfmunprice')
    fetch(`${url}/Stockcard/SumQty/${txt[0]}`)
        .then(response => response.json())
        .then(data =>{

            const Control = document.getElementById("Control")
            Control.insertAdjacentHTML('beforebegin', `
                                <tr id="${id}" class="dtItems">
                                    <th scope="row">${txt[0]}</th>
                                    <th scope="row">${txt[1]}</th>
                                    <th >
                                    <select class="form-control"  name="xvuntcode[]">
                                        ${unitOption}
                                    </select>
                                    </th>
                                    <th scope="row" class="text-right">${data.Qty}</th>
                                    <td>
                                        <input type="text" class="form-control text-right" name="XIAjdQty[]"
                                        required
                                        onkeypress='return isNumberKeyNoDot(event)' value="1"/>
                                    </td>
                                    <td class="text-center">
                                           ${img ? `<a href="${url}/${img}" target="_blank"> <i class="fas fa-eye "></i></a>` : ''}
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-circle btn-sm" ${isFarbic ? `onclick="removeRowFarbic('${id}')"` : `onclick="removeRow('${id}')"`}>X</button>
                                    </td>
                                    <input type="hidden" name="xvmatcode[]" value="${id}">
                                    <input type="hidden" name="XVPodName[]" value="${txt[1]}">
                                </tr>`)
        });
}


function renderOption(arr, key, text, custom) {
    let options = ""
    for (let i = 0; i < arr.length; i++) {
        options += `<option id="option_${arr[i][key]}" value="${arr[i][key]}" data-custom="${arr[i][custom]}">${arr[i][text]}</option>`
    }
    return options
}

function removeRow(id) {
    document.getElementById(id).remove();
    updateCurrentDT()
}

function updateCurrentDT() {
    var oldList = document.getElementsByClassName("dtItems")
    let oldArr = [];
    for (let i = 0; i < oldList.length; i++) {
        oldArr.push(oldList[i].id)
    }
    TriggerChange(oldArr)
}

function removeRowFarbic(id) {
    RemoveSelectedFarbic();
    document.getElementById(id).remove();
}


//Helper

function SumArray(arrAmount) {
    return arrAmount
        .filter((item) => item !== '')
        .reduce((prev, curr) => parseFloat(prev) + parseFloat(curr))
}

function getArrayInput(NameElement) {
    var input = document.getElementsByName(NameElement);
    let arr = []
    for (var i = 0; i < input.length; i++) {
        arr.push(input[i].value)
    }
    return arr;
}

function replaceQuotes(text) {
    return text.replace(/"/g, "&quot;");
}

//Form

function validateForm() {
    const xvuntcode = getArrayInput('xvuntcode[]');
    if (
        checkValue(xvuntcode, "กรุณาเลือกวัสดุ")
    ) {
        if (xvuntcode.length > 0) {
            return true
        } else {
            swal('กรุณาเลือกวัสดุ', "กรุณาเลือกวัสดุอย่างน้อย 1 ชนิด", "warning")
        }
    }
    return false
}

function checkValue(arrVal, responseText) {
    const itemFillter = arrVal.filter((item) => item.trim().length === 0)
    if (itemFillter.length > 0) {
        swal(responseText, responseText, "warning")
        return false
    } else {
        return true;
    }
}

function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if ((charCode > 31 && (charCode < 46 || charCode > 57)))
        return false;
    return true;
}
function isNumberKeyNoDot(evt){
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if ((charCode > 31 && (charCode < 48 || charCode > 57)) )
        return false;
    return true;
}
