$(document).ready(function () {
    $('#datepicker').datepicker({
        uiLibrary: 'bootstrap4',
        format: 'dd-mm-yyyy'
    });
    var SelectMasterItemsSize = $('#SelectMasterItemsSize').select2({
        placeholder: "เลือกสินค้า",
        theme: 'bootstrap4',
    });
    $('#SelectMasterItemsSize').on('select2:select', function (e) {
        var {id, text} = (e.params.data);
        let [xvpdtcode, size] = id.split("_");
        let StockQty = e.params.data?.element.attributes[2].nodeValue ?? 0

        createProduct(xvpdtcode, text, size, StockQty)
    });
    $('#SelectMasterItemsSize').on('select2:unselect', function (e) {
        var data = (e.params.data);
        // let unitType = e.params.data?.element?.attributes[0]?.nodeValue  ? JSON.parse(e.params.data?.element?.attributes[0]?.nodeValue) :JSON.parse(e.params.data?.element?.attributes[1]?.nodeValue)  ;

        document.getElementById(data.id).remove()
    });
    window.TriggerChange = function (oldArr) {
        SelectMasterItemsSize.val(oldArr).trigger("change");
    }
})

async function createProduct(id, text, sizeType, StockQty) {
    // let sizeOption = renderOption(sizeType,'XVPszName','XVPszName','xvpdtcode')
    // let BomDefault = await getBom(id,sizeType)

    let parentID = `${id}_${sizeType}`
    // let childID = `group-of-rows-${parentID}`
    let str = text.replace(/ /g, '');
    str = replaceQuotesText(str);
    let txt = str.split(":");
    const Control = document.getElementById("Control")
    Control.insertAdjacentHTML('beforeend',
        `<tr id="${parentID}" class="dtItems " >
                                    <th scope="row">${txt[0]}</th>
                                    <th scope="row">${txt[1]}</th>
                                    <th >
                                    ${sizeType}
                                    </th>
                                     <th >
                                    ${StockQty}
                                    </th>
                                    <td>
                                        <input type="text" class="form-control text-right" name="XIFadQty[]"
                                        required
                                        style="height: 25px"
                                        onkeypress='return textNumber(event)' value="${StockQty}"/>
                                    </td>

                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-circle btn-sm" onclick="removeRow('${parentID}')">X</button>
                                    </td>
                                    <input type="hidden" name="xvpdtcode[]" value="${id}">
                                    <input type="hidden" name="XVPszName[]" value="${sizeType}">
                                    <input type="hidden" name="StockQty[]" value="${StockQty}">
                                </tr>
`)
}

async function getBom(xvpdtcode, XVPszName) {
    const AppUrl = document.getElementById('urlGlobal').value;
    const response = await fetch(`${AppUrl}/bomSize/recepie/${xvpdtcode}/${XVPszName}`)
    return response.json();
}

function removeRow(id) {
    document.getElementById(id).remove();
    // document.getElementById(childID).remove();
    updateCurrentDT()
}

function updateCurrentDT() {
    var oldList = document.getElementsByClassName("dtItems")
    let oldArr = [];
    for (let i = 0; i < oldList.length; i++) {
        oldArr.push(oldList[i].id)
    }
    TriggerChange(oldArr)
}

function validateForm() {
    // const XIFadQty = getArrayInput('XIFadQty[]');
    // const StockQty = getArrayInput('StockQty[]');
    // console.log(XIFadQty)
    // console.log(StockQty)
    // let isMoreThanStock = false;
    // for (let i = 0; i < XIFadQty.length; i++) {
    //     if (XIFadQty[i] > StockQty[i]) {
    //         isMoreThanStock = true;
    //         break;
    //     }
    // }
    // if (isMoreThanStock) {
    //     swal('จำนวนสินค้าในสต็อคไม่เพียงพอ', "กรุณาเบิกสินค้าไม่เกินจำนวนคงเหลือ", "warning")
    // }
    // return !!!isMoreThanStock;
    return true;
}

function getArrayInput(NameElement) {
    var input = document.getElementsByName(NameElement);
    let arr = []
    for (var i = 0; i < input.length; i++) {
        arr.push(input[i].value)
    }
    return arr;
}
