const miniMumRow = 25;
function countLineSpace(text){
    return Math.floor((text.length/20))*10;
}
function renderPdf(url) {
    fetch(url)
        .then(response => response.json())
        .then(async data => {
            // let line = countLineSpace(data.hd.XVSplAddress)
            let date = convertDateToLocale(data.hd.XDGrhDocDate)
            let header = SectionHeader(date, data.hd.XVGrhDocNo);
            let subHeader = SectionSubHeaderV3(date, data.hd);
            let ItemPo = ListItemPo(data.hd, data.dt);
            let Footer = await SectionFooter(data.hd)
            var dd = {
                pageSize: 'A4',
                // pageMargins: [20, 20],
                pageMargins: [20,140, 20, 20],
                header: function (currentPage, pageCount, pageSize) {
                    return {
                        stack: [...header, ...subHeader],
                        margin: [20, 15, 20, 0]
                    }
                },
                content: [
                    // ...header,
                    // ...subHeader,
                    ...ItemPo,
                    ...Footer
                ],
                defaultStyle: {
                    font: "Sarabun",
                    fontSize: 7,

                }
            }
            pdfMake.createPdf(dd).open()
        });

}

// ซ้าย บน ขวา ล่าง

function SectionHeader(date, DocNo) {
    return [
        {
            text: 'บริษัท วี เค การ์เม้นท์ จำกัด',
            alignment: 'center',
            fontSize: 11,
            bold: true,
        },
        {
            text: '48, 50, 52, 54, 56, 126, 128, 130 ซอยสมเด็จพระเจ้าตากสิน 13 ถนนสมเด็จพระเจ้าตากสิน แขวงสำเหร่ เขตธนบุรี กรุงเทพมหานคร 10600',
            fontSize: 9,
            alignment: 'center'
        },
        {
            text: 'Tel: 02-860-7770 Fax: 02-438-9929',
            fontSize: 10,
            alignment: 'center'
        },
        {
            margin: [0, 5, 0, 0],
            text: "ใบรับวัสดุ \n GOODS RECEIVED",
            fontSize: 10,
            bold: true,
            alignment: 'center'
        },
        {
            alignment: 'justify',
            columns: [
                {
                    alignment: 'right',
                    text: 'GR No.' + DocNo,
                    fontSize: 11,
                    bold: true
                }
            ]
        },
    ]
}

function SectionSubHeaderV3(date, hd) {
    let usr_name = "สุชญา ภู่แสง (อิ๊บ)"
    let usr_phone = "02-8607770-4 ต่อ 131"
    return [
        {
            margin: [0, 5, 0, 0],

            table: {
                widths: [50, 100,50, '*'],
                body: [
                    [
                        {
                            text: 'Date : ',
                        },
                        {
                            text: date,
                        },

                        {
                            text: 'ผู้รับ',
                        },
                        {
                            text: hd.name ?? "",
                        },
                    ],
                    [
                        {
                            text: 'เลขที่ใบสั่งซื้อ',
                        },
                        {
                            text: hd.XVGrhDocNoPO,
                        },
                        {
                            text: 'สถานที่รับของ : ',
                        },
                        {
                            text: hd.XVPohDeliveryPlace,
                        },
                    ],
                ]

            },
            layout: {
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}

function ListItemPo(hd, dt) {
    let DateReceive = hd.XDGrhDocDate ? convertDateToLocale(hd.XDGrhDocDate) : ""

    let ItemPo = renderItemPo(dt,DateReceive);
    if (ItemPo.length <= miniMumRow) {
        ItemPo = renderEmpty(ItemPo)
    }
    return [
        {
            table: {
                // widths: [27,40, '*', 45,35, 65, 30, 65],
                widths: [27, 62, 70, 35,60, 60, 60,55, 45],
                body: [
                    [
                        {text: 'ลำดับ', fontSize: 9, alignment: 'center'},
                        {text: 'รหัส', fontSize: 9, alignment: 'center'},
                        {text: 'รายการ', fontSize: 9, alignment: 'center'},
                        {text: 'หน่วย', fontSize: 9, alignment: 'center'},
                        {text: 'จำนวน', fontSize: 9, alignment: 'center'},
                        {text: 'ราคาต่อหน่วย', fontSize: 9, alignment: 'center'},
                        {text: 'จำนวนเงิน', fontSize: 9, alignment: 'center'},
                        {text: 'จำนวนที่รับ', fontSize: 9, alignment: 'center'},
                        {text: 'วันที่รับของ', fontSize: 9, alignment: 'center'},
                    ],
                    ...ItemPo,
                    [
                        {text: 'ราคารวม', colSpan: 5, fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {},
                        {},
                        {},
                        {},
                        {text: 'TOTAL', fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {text: formatMoney(hd.XFGrhTotal), fontSize: 9, alignment: 'right',fillColor: '#CCCCCC',},
                        {text: '', fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {text: '', fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                    ],
                    [
                        {text: '', colSpan: 5, fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {},
                        {},
                        {},
                        {},
                        {text: `Vat ${hd.XBGrhIsTax ? hd.XIGrhTax : 0} %`, fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {text: formatMoney(hd.XFGrhTotalVat), fontSize: 9, alignment: 'right',fillColor: '#CCCCCC',},
                        {text: '', fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {text: '', fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                    ],
                    [
                        {text: 'ราคารวมภาษีมูลค่าเพิ่ม', colSpan: 5, fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {},
                        {},
                        {},
                        {},
                        {text: `GrandTotal`, fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {text: formatMoney(hd.XFGrhNet), fontSize: 9, alignment: 'right',fillColor: '#CCCCCC',},
                        {text: '', fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {text: '', fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                    ],
                ]
            },

            layout: {
                fillColor: function (rowIndex, node, columnIndex) {
                    return (rowIndex === 0) ? '#CCCCCC' : null;
                },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}

function renderEmpty(ItemPo) {
    for (let i = ItemPo.length; i <= miniMumRow; i++) {
        ItemPo.push([
            {text: i + 1, fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
        ],)
    }
    return ItemPo
}

function renderItemPo(dt,DateReceive) {
    let Item = []
    for (let i = 0; i < dt.length; i++) {
        Item.push([
            {text: i + 1, fontSize: 8, alignment: 'center'},
            {text: dt[i].xvmatcode, fontSize: 8, alignment: 'center'},
            {text: dt[i].xvmatname, fontSize: 8, alignment: 'left'},
            {text: dt[i].XVGrdUnitName, fontSize: 8, alignment: 'center'},
            {text: formatMoney(dt[i].XIGrdQtyPo), fontSize: 8, alignment: 'right'},
            {text: formatMoney(dt[i].XFGrdUnitCost), fontSize: 8, alignment: 'right'},
            {text: formatMoney(dt[i].XFGrdCostTotal), fontSize: 8, alignment: 'right'},
            {text: formatMoney(dt[i].XIGrdQty), fontSize: 8, alignment: 'right'},
            {text: DateReceive, fontSize: 8, alignment: 'center'},
        ],)
    }
    return Item
}

async function SectionFooter(hd) {
    return [
        {
            table: {
                heights: function (row) {
                    return row === 1 ? 40 : 0
                },
                widths: ['*', '*', '*'],
                body: [
                    [
                        {text: 'รับวัสดุโดย \nReceived By', fontSize: 10, alignment: 'center', border: [true, false]},
                        {text: 'ตรวจสอบโดย \n Checked By ', fontSize: 10, alignment: 'center', border: [true, false]},
                        {
                            text: 'อนุมัติโดย \nApproved By',
                            fontSize: 10,
                            alignment: 'center',
                            border: [true, false, true, false]
                        },
                    ],
                    [
                        {
                            text: '\n.............................',
                            fontSize: 10,
                            alignment: 'center',
                            margin: [0, 15, 0, 0], border: [true, false]
                        },
                        {
                            text: '\n.............................',
                            fontSize: 10,
                            alignment: 'center',
                            margin: [0, 15, 0, 0], border: [true, false]
                        },
                        {
                            text: '\n.............................',
                            fontSize: 10,
                            alignment: 'center',
                            margin: [0, 15, 0, 0], border: [true, false, true, false]
                        },
                    ],
                    [
                        {text: '', fontSize: 10, alignment: 'center', border: [true, false]},
                        {
                            text: '',
                            fontSize: 10,
                            alignment: 'center',
                            border: [true, false]
                        },
                        {text: '', fontSize: 10, alignment: 'center', border: [true, false, true, false]},
                    ],
                    [
                        {
                            text: '......../......../........', fontSize: 10,
                            alignment: 'center',
                            // border: [true, false]
                        },
                        {
                            text: '......../......../........',
                            fontSize: 10,
                            alignment: 'center',
                            // border: [true, false]
                        },
                        {
                            text: '......../......../........',
                            fontSize: 10,
                            alignment: 'center',
                            // border: [true, false, true, false]
                        },
                    ],
                    // [
                    //     {
                    //         text: 'หมายเหตุ / Remarks :\n' +
                    //             '\t1.ใบสั่งซื้อฉบับนี้สมบูรณ์ต่อเมื่อข้อมูลในช่องว่างข้างบนครบสมบูรณ์ พร้อมลายเซ็นผู้มีอำนาจ\n' +
                    //             '\t\tThis purchase order will be valid when it is completed & signed by the authorised signatories.\n' +
                    //             '\t2.โปรดแนบใบสั่งซื้อพร้อมกับใบแจ้งหนี้หรือเอกสารในการเรียกเก็บเงินประจำเดือนของท่านทุกครั้ง\n' +
                    //             '\t\tPurchase order is required to be attached to the invoice or monthly statement of accounts.',
                    //         colSpan: 2,
                    //         lineHeight:1.5,
                    //         fontSize: 8.5,
                    //         alignment: 'left',
                    //         preserveLeadingSpaces: true,
                    //         border: [false, true, false, false],
                    //         margin: [0, 5, 0, 0],
                    //     },
                    //     {},
                    //     {},
                    // ],

                ]
            },

            layout: {
                // fillColor: function (rowIndex, node, columnIndex) {
                //     console.log(rowIndex,node,columnIndex)
                //     return (rowIndex === 0) ? '#CCCCCC' : null;
                // },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}

//Utility

function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function getBase64ImageFromURL(url) {
    return new Promise((resolve, reject) => {
        var img = new Image();
        img.setAttribute("crossOrigin", "anonymous");
        img.onload = () => {
            var canvas = document.createElement("canvas");
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext("2d");
            ctx.drawImage(img, 0, 0);
            var dataURL = canvas.toDataURL("image/png");
            resolve(dataURL);
        };
        img.onerror = error => {
            reject(error);
        };
        img.src = url;
    });
}

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
