const miniMumRow = 19;
function countLineSpace(text){
    return Math.floor((text.length/50))*10;
}
function renderPdf(url) {
    fetch(url)
        .then(response => response.json())
        .then(async data => {
            let line = countLineSpace(data.hd.XVSplAddress)
            let date = convertDateToLocale(data.hd.XDPohDocDate)
            let header = SectionHeader(date, data.hd.XVPohDocNo);
            let subHeader = SectionSubHeaderV3(date, data.hd);
            let ItemPo = ListItemPo(data.hd, data.dt);
            let Footer = await SectionFooter(data.hd)
            var dd = {
                pageSize: 'A4',
                // pageMargins: [20, 20],
                pageMargins: [20,180+line, 20, 20],
                header: function (currentPage, pageCount, pageSize) {
                    return {
                        stack: [...header, ...subHeader],
                        margin: [20, 15, 20, 0]
                    }
                },
                
                content: [
                    // ...header,
                    // ...subHeader,
                    ...ItemPo,
                    ...Footer
                ],
                defaultStyle: {
                    font: "Sarabun",
                    fontSize: 7,

                }
            }
            pdfMake.createPdf(dd).open()
        });

}

// ซ้าย บน ขวา ล่าง

function SectionHeader(date, DocNo) {
    return [
        {
            text: 'บริษัท วี เค การ์เม้นท์ จำกัด',
            alignment: 'center',
            fontSize: 11,
            bold: true,
        },
        {
            text: '48, 50, 52, 54, 56, 126, 128, 130 ซอยสมเด็จพระเจ้าตากสิน 13 ถนนสมเด็จพระเจ้าตากสิน แขวงสำเหร่ เขตธนบุรี กรุงเทพมหานคร 10600',
            fontSize: 9,
            alignment: 'center'
        },
        {
            text: 'Tel: 02-860-7770 Fax: 02-438-9929',
            fontSize: 10,
            alignment: 'center'
        },
        {
            margin: [0, 5, 0, 0],
            text: "ใบสั่งซื้อ \n PURCHASE ORDER",
            fontSize: 10,
            bold: true,
            alignment: 'center'
        },
        {
            alignment: 'justify',
            columns: [
                {
                    alignment: 'right',
                    text: 'PO No.' + DocNo,
                    fontSize: 11,
                    bold: true
                }
            ]
        },
    ]
}

function SectionSubHeaderV3(date, hd) {
    let usr_name = "สุชญา ภู่แสง (อิ๊บ)"
    let usr_phone = "02-8607770-4 ต่อ 131"
    return [
        {
            margin: [0, 5, 0, 0],

            table: {
                widths: [50, '*', 65, '*', 65, '*'],
                body: [
                    [
                        {
                            text: 'Date : ',
                        },
                        {
                            text: date,
                        },
                        {
                            text: 'ใบขอซื้อเลขที่ : \n(Ref.PR No.)',
                            rowSpan: 2
                        },
                        {
                            text: hd.XVPohRefNo,
                            rowSpan: 2
                        },
                        {
                            text: 'ส่งของที่ : \n(Delivered)',
                            rowSpan: 2
                        },
                        {
                            text: hd.XVPohDeliveryPlace,
                            rowSpan: 2
                        },
                    ],
                    [
                        {
                            text: 'ผู้จัดจำหน่าย : ',
                        },
                        {
                            text: hd.XVSplName,
                        },


                    ],
                    [
                        {
                            text: 'ผู้ติดต่อ : ',
                        },
                        {
                            text: hd.xvsqlcontactname,
                        },
                        {
                            text: 'ผู้จัดทำใบสั่งซื้อ : \n(Prepared By)',
                            rowSpan: 2
                        },
                        {
                            text: `${usr_name}\n${usr_phone} `,
                            alignment: 'left',
                            rowSpan: 2
                        },
                        {
                            text: 'เงื่อนไขการชำระเงิน : \n(Term of Payment)',
                            rowSpan: 2
                        },
                        {
                            text: hd.XVPohBillDays ? hd.XVPohBillDays : '',
                            rowSpan: 2
                        },
                    ],
                    [
                        {
                            text: 'Tel : ',
                        },
                        {
                            text: hd.XVSplPhone,
                        },
                    ],
                    [
                        {
                            text: hd.XVSplAddress,
                            colSpan: 2
                        },
                        {},
                        {
                            text: "โปรดออกใบแจ้งหนี้ชื่อ",
                        },
                        {
                            text: "บริษัท วี เค การ์เม้นท์ จำกัด (ที่อยู่ตามหัวกระดาษ)",
                            colSpan: 3
                        },

                    ],
                ]
            },
            layout: {
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}

function ListItemPo(hd, dt) {
    let DateReceive = hd.XBPohIsRefered ? convertDateToLocale(hd.XDPohDocDateReceive) : ""

    let ItemPo = renderItemPo(dt,DateReceive);
    if (ItemPo.length <= miniMumRow) {
        ItemPo = renderEmpty(ItemPo)
    }
    return [
        {
            table: {
                // widths: [27,40, '*', 45,35, 65, 30, 65],
                widths: [27, 62, '*', 40,65, 65, 65, 45],
                body: [
                    [
                        {text: 'ลำดับ', fontSize: 9, alignment: 'center'},
                        {text: 'รหัส', fontSize: 9, alignment: 'center'},
                        {text: 'รายการ', fontSize: 9, alignment: 'center'},
                        {text: 'หน่วย', fontSize: 9, alignment: 'center'},
                        {text: 'จำนวน', fontSize: 9, alignment: 'center'},
                        {text: 'ราคาต่อหน่วย', fontSize: 9, alignment: 'center'},
                        {text: 'จำนวนเงิน', fontSize: 9, alignment: 'center'},
                        {text: 'วันที่ส่งของ', fontSize: 9, alignment: 'center'},
                    ],
                    ...ItemPo,
                    [
                        {text: 'ราคารวม', colSpan: 5, fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {},
                        {},
                        {},
                        {},
                        {text: 'TOTAL', fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {text: formatMoney(hd.XFPohTotal), fontSize: 9, alignment: 'right',fillColor: '#CCCCCC',},
                        {text: '', fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                    ],
                    [
                        {text: '', colSpan: 5, fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {},
                        {},
                        {},
                        {},
                        {text: `Vat ${hd.XBPohIsTax ? hd.XIPohTax : 0} %`, fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {text: formatMoney(hd.XFPohTotalVat), fontSize: 9, alignment: 'right',fillColor: '#CCCCCC',},
                        {text: '', fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                    ],
                    [
                        {text: 'ราคารวมภาษีมูลค่าเพิ่ม', colSpan: 5, fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {},
                        {},
                        {},
                        {},
                        {text: `GrandTotal`, fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {text: formatMoney(hd.XFPohNet), fontSize: 9, alignment: 'right',fillColor: '#CCCCCC',},
                        {text: '', fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                    ],
                ]
            },

            layout: {
                fillColor: function (rowIndex, node, columnIndex) {
                    return (rowIndex === 0) ? '#CCCCCC' : null;
                },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}

function renderEmpty(ItemPo) {
    for (let i = ItemPo.length; i <= miniMumRow; i++) {
        ItemPo.push([
            {text: i + 1, fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
        ],)
    }
    return ItemPo
}

function renderItemPo(dt,DateReceive) {
    let Item = []
    for (let i = 0; i < dt.length; i++) {
        // Item.push([
        //     {text: i + 1, fontSize: 8, alignment: 'center'},
        //     {text: dt[0].xvmatcode, fontSize: 8, alignment: 'center'},
        //     {text: dt[0].xvmatname, fontSize: 8, alignment: 'left'},
        //     {text: formatMoney(dt[0].XFPodUnitCost), fontSize: 8, alignment: 'right'},
        //     {text: formatMoney(dt[0].XIPodQty, 0), fontSize: 8, alignment: 'right'},
        //     {text: formatMoney(dt[0].XFPodCostTotal), fontSize: 8, alignment: 'right'},
        //     {text: "", fontSize: 8, alignment: 'center'},
        // ],)
        Item.push([
            {text: i + 1, fontSize: 8, alignment: 'center'},
            {text: dt[i].xvmatcode, fontSize: 8, alignment: 'center'},
            {text: dt[i].xvmatname, fontSize: 8, alignment: 'left'},
            {text: dt[i].XVPodUnitName, fontSize: 8, alignment: 'center'},
            {text: formatMoney(dt[i].XIPodQty), fontSize: 8, alignment: 'right'},
            {text: formatMoney(dt[i].XFPodUnitCost), fontSize: 8, alignment: 'right'},
            {text: formatMoney(dt[i].XFPodCostTotal), fontSize: 8, alignment: 'right'},
            {text: DateReceive, fontSize: 8, alignment: 'center'},
        ],)
    }
    return Item
}

async function SectionFooter(hd) {
    let urlApp = document.getElementById('url').value
    let imgUrl, picture;
    if (hd.XVPohImg) {
        imgUrl = `${urlApp}/${hd.XVPohImg}`
    } else {
        imgUrl = `${urlApp}/images/not-found.jpg`
    }
    try {
        picture = await getBase64ImageFromURL(imgUrl)
    } catch (e) {
        imgUrl = `${urlApp}/images/not-found.jpg`
        picture = await getBase64ImageFromURL(imgUrl)
    }
    return [
        {
            table: {
                heights: function (row) {
                    return row === 1 ? 40 : 0
                },
                widths: ['*', '*', '*'],
                body: [
                    [
                        {text: 'สั่งของโดย \nOrdered By', fontSize: 10, alignment: 'center', border: [true, false]},
                        {text: 'ยืนยันโดย \nConfirmed By', fontSize: 10, alignment: 'center', border: [true, false]},
                        {
                            text: 'อนุมัติโดย \nApproved By',
                            fontSize: 10,
                            alignment: 'center',
                            border: [true, false, true, false]
                        },
                    ],
                    [
                        {
                            text: '\n.............................',
                            fontSize: 10,
                            alignment: 'center',
                            margin: [0, 15, 0, 0], border: [true, false]
                        },
                        {
                            text: '\n.............................',
                            fontSize: 10,
                            alignment: 'center',
                            margin: [0, 15, 0, 0], border: [true, false]
                        },
                        {
                            text: '\n.............................',
                            fontSize: 10,
                            alignment: 'center',
                            margin: [0, 15, 0, 0], border: [true, false, true, false]
                        },
                    ],
                    [
                        {text: 'ฝ่ายจัดซื้อ(Purchaser)', fontSize: 10, alignment: 'center', border: [true, false]},
                        {
                            text: 'เจ้าหน้าที่บัญชี (Accountant)',
                            fontSize: 10,
                            alignment: 'center',
                            border: [true, false]
                        },
                        {text: '', fontSize: 10, alignment: 'center', border: [true, false, true, false]},
                    ],
                    [
                        {text: '......../......../........', fontSize: 10, alignment: 'center', border: [true, false]},
                        {text: '......../......../........', fontSize: 10, alignment: 'center', border: [true, false]},
                        {
                            text: '......../......../........',
                            fontSize: 10,
                            alignment: 'center',
                            border: [true, false, true, false]
                        },
                    ],
                    [
                        {
                            text: 'หมายเหตุ / Remarks :\n' +
                                '\t1.ใบสั่งซื้อฉบับนี้สมบูรณ์ต่อเมื่อข้อมูลในช่องว่างข้างบนครบสมบูรณ์ พร้อมลายเซ็นผู้มีอำนาจ\n' +
                                '\t\tThis purchase order will be valid when it is completed & signed by the authorised signatories.\n' +
                                '\t2.โปรดแนบใบสั่งซื้อพร้อมกับใบแจ้งหนี้หรือเอกสารในการเรียกเก็บเงินประจำเดือนของท่านทุกครั้ง\n' +
                                '\t\tPurchase order is required to be attached to the invoice or monthly statement of accounts.',
                            colSpan: 2,
                            lineHeight:1.5,
                            fontSize: 8.5,
                            alignment: 'left',
                            preserveLeadingSpaces: true,
                            border: [false, true, false, false],
                            margin: [0, 5, 0, 0],
                        },
                        {},
                        {
                            image: picture,
                            width: 150,
                            height: 100,
                            alignment: 'center',
                        },
                    ],

                ]
            },

            layout: {
                // fillColor: function (rowIndex, node, columnIndex) {
                //     console.log(rowIndex,node,columnIndex)
                //     return (rowIndex === 0) ? '#CCCCCC' : null;
                // },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}

//Utility

function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function getBase64ImageFromURL(url) {
    return new Promise((resolve, reject) => {
        var img = new Image();
        img.setAttribute("crossOrigin", "anonymous");
        img.onload = () => {
            var canvas = document.createElement("canvas");
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext("2d");
            ctx.drawImage(img, 0, 0);
            var dataURL = canvas.toDataURL("image/png");
            resolve(dataURL);
        };
        img.onerror = error => {
            reject(error);
        };
        img.src = url;
    });
}

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
