

function countLineSpace(text) {
    return Math.floor((text.length / 50)) * 10;
}

function renderPdf(data,datestart,dateend) {
  
            // let line = countLineSpace(data.XVSplAddress)
            // console.log(line);
            // let date = convertDateToLocale(data.hd.XDPohDocDate)
            let header = SectionHeader("kanin",datestart,dateend);
            // let subHeader = SectionSubHeaderV3(date, data.hd);
             let ItemPo =  ListItemPo(data);
            // let Footer = await SectionFooter(data.hd)
            var dd = {
                pageSize: 'A4',
                pageMargins: [20, 20],

                content: [
                    ...header,
                    // ...subHeader,
                     ...ItemPo,
                    // ...Footer
                ],
                defaultStyle: {
                    font: "Sarabun",
                    fontSize: 7,

                }
            }
            pdfMake.createPdf(dd).open()
        ;

}

// ซ้าย บน ขวา ล่าง

function SectionHeader(DocNo,datestart,dateend) {
    console.log(datestart,dateend);
    var dateee ="";
    var datee2 ="";
    console.log(datestart);
    if (datestart!=null && dateend!=null)
    {
       dateee = "ระว่างวันที่ "+convertDateToLocale(datestart)+" ถึงวันที่ "+convertDateToLocale(dateend);
       datee2 = "AT "+convertDateToEN(datestart)+" TO "+convertDateToEN(dateend);
    }
    else
    {
        dateee = "ทั้งหมด";
        datee2 = "ALL" ;
    }
    return [{
            text: '201 รายงานการสังซื้อจากผู้จำหน่าย',
            alignment: 'center',
            fontSize: 11,
            bold: true,
        },
        {
            margin: [0, 5, 0, 0],
            text: dateee ,
            fontSize: 9,
            alignment: 'center'
        },
        {
            text: 'จากผู้จำหน่าย......................',
            fontSize: 10,
            alignment: 'center'
        },
        {
            margin: [0, 0, 0, 10],
            text: 'ถึง......................',
            fontSize: 10,
            alignment: 'center'
        },
    ]
}


function ListItemPo(data) {
    let ItemPo = renderItemPo(data);
    return [{
            table: { 
                // widths: [27,40, '*', 45,35, 65, 30, 65],
                widths: [200,'*',150,100],
                body: [
                    [{
                            text: 'ลูกค้า',
                            fontSize: 9,
                            alignment: 'center'
                            ,border:
                            [true, true, false, true]
                            
                        },
                        {
                            text: 'วันที่',
                            fontSize: 9,
                            alignment: 'center',
                            border:[false, true, false, true]

                        },
                        {
                            text: 'ชื่อผู้จำหน่าย',
                            fontSize: 9,
                            alignment: 'center',
                            border:[false, true, false, true]

                        },
                        {
                            text: 'รวม',
                            fontSize: 9,
                            alignment: 'center',
                            border:[false, true, true, true]
                            
                        }, 
                    ],
                    ...ItemPo,
                   
                ]
            },
            layout: {
				defaultBorder: false,
			}
            // layout: 'headerLineOnly'
        },

    ]
}

function renderItemPo(dt) {
    console.log(dt);
    let Item = []
    let detail = []
    for (let i = 0; i < dt.length; i++) {
        for (var E = 0;E < dt[i].DT.length; E++) 
            {
                detail.push(dt[i].DT[E].xvmatcode+" "+dt[i].DT[E].XVPodName+"\t\t\t\t"+dt[i].DT[E].XFPodCostTotal+"\n")
            }
        Item.push([
            {
                text: (i==0)? dt[i].HD.XVSplCode+" "+dt[i].HD.XVSplName
                :(dt[i-1].HD.XVSplCode==dt[i].HD.XVSplCode)?"":dt[i].HD.XVSplCode+" "+dt[i].HD.XVSplName,
                fontSize: 8,
                alignment: 'left'
            },
            {
                text: (i==0)?convertDateToLocale(dt[i].HD.XDPohDocDate)
                :(dt[i-1].HD.XDPohDocDate==dt[i].HD.XDPohDocDate)?"" :convertDateToLocale(dt[i].HD.XDPohDocDate),
                fontSize: 8,
                alignment: 'center'
            },
            {
                
                text:  [dt[i].HD.XVPohDocNo+"\n",
                {text:detail,alignment: 'center'},
                ],
                fontSize: 8,
                alignment: 'left'
            },
            {
             
                text: dt[i].HD.XFPohTotal,
                fontSize: 8,
                alignment: 'right'
            },

        ],(i==0)? [{colSpan: 4, text:''}]
        :(dt[i-1].HD.XVSplCode==dt[i].HD.XVSplCode)?[{colSpan: 4, text:''}]:[{colSpan: 4, text:'รวม'}], 
         ),
         detail=[];
    }
    return Item
}

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
function convertDateToEN(date) {
    return new Date(date).toLocaleDateString('en')
}


