const miniMumRow = 30;
const HeaderName = "301 รายงานการรับเข้าวัสดุแยกตามผู้จำหน่าย";
const column = 6;

function countLineSpace(text) {
    return Math.floor((text.length / 20)) * 10;
}

function renderPdf(result,filter) {
    let header = SectionHeader(filter);
    let ListItems = ListItem(result);
    let SubHeaderX = SubHeader();

    var dd = {
        pageSize: 'A4',
        // pageMargins: [20, 20],
        pageMargins: [20, 103, 20, 20],
        header: function (currentPage, pageCount, pageSize) {
            return {
                stack: [...header,...SubHeaderX],
                margin: [20, 15, 20, 0]
            }
        },
        content: [
            ...ListItems,
        ],
        defaultStyle: {
            font: "Sarabun",
            fontSize: 7,

        }
    }
    pdfMake.createPdf(dd).open()
}

// ซ้าย บน ขวา ล่าง

function SectionHeader(filter) {

    let DateStart,DateEnd,CstNameStart,CstNameEnd
    if(!!filter.isAllTime){
         DateStart = "ทั้งหมด"
         DateEnd = "ทั้งหมด"
    }else{
         DateStart = convertDateToLocale(filter.DateStart)
         DateEnd = convertDateToLocale(filter.DateEnd)
    }
    if(!!filter.isAllSpl){
         CstNameStart = "ทั้งหมด"
         CstNameEnd = "ทั้งหมด"
    }else{
         CstNameStart = (filter.SplStart)
         CstNameEnd = (filter.SplEnd)
    }
    return [
        {
            text: HeaderName,
            alignment: 'center',
            fontSize: 11,
            bold: true,

        },
        {
            text: `จากวันที่ ${DateStart}  ถึงวันที่ ${DateEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
        {
            text: `จากผู้จำหน่าย ${CstNameStart}\nถึง ${CstNameEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
    ]
}

function SubHeader() {
    return [
        {
            table: {
                widths: [80, 60, '*', 50, 50, 50],
                body: [
                    [
                        {text: 'ผู้จำหน่าย', fontSize: 9, alignment: 'left', rowSpan: 2, border: [true, true,true,true]},
                        {text: 'วันที่', fontSize: 9, alignment: 'left', rowSpan: 2, border: [true, true,true,true]},
                        {text: 'เลขที่ใบรับวัสดุ', fontSize: 9, alignment: 'left', border: [true, true,true,false]},
                        {text: 'หน่วย', fontSize: 9, alignment: 'left', rowSpan: 2 , border: [true, true,true,true]},
                        {text: 'จำนวนสั่ง', fontSize: 9, alignment: 'left', rowSpan: 2 , border: [true, true,true,true]},
                        {text: 'จำนวนรับ', fontSize: 9, alignment: 'left', rowSpan: 2 , border: [true, true,true,true]},
                    ],
                    [
                        {},
                        {},
                        {text: '\tวัสดุ', fontSize: 9, alignment: 'left',preserveLeadingSpaces: true, border: [true, false,true,true]},
                        {},
                        {},
                        {},

                    ],
                ]
            },
            layout: {
                fillColor: function (rowIndex, node, columnIndex) {
                    return (rowIndex === 0 || rowIndex === 1) ? '#CCCCCC' : null;
                },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}
function ListItem(result) {
    let arrayItems = [] ;
    for(let i = 0 ; i < result.length ; i++){
        let {Items} = renderItem(result[i]);
        // if(Items.length >0){
        //     Items = renderSumRow(Items);
        // }
        arrayItems = [...arrayItems,...Items]
    }
    return [
        {
            table: {
                widths: [80, 60, '*', 50, 50, 50],
                body: [
                    ...arrayItems,
                ]
            },
        },

    ]
}

function renderItem({XVSplCode,XVSplName,OrderHD}) {
    let Item = []
    for (let i = 0; i < OrderHD.length; i++) {
        const {XVGrhDocNo,XDGrhDocDate,OrderDT} = OrderHD[i];
        const oldValue = OrderHD[i-1] ?? {XVGrhDocNo :null , XDGrhDocDate:null};
        let DateDisplay;
        if(XDGrhDocDate == oldValue.XDGrhDocDate){
            DateDisplay=""
            // NameDisplay = '';
        }else{
            DateDisplay = convertDateToLocale(XDGrhDocDate)
            // NameDisplay = `${XVSplCode+" "+XVSplName}`
        }
        const NameDisplay = i==0 ? `${XVSplCode+" "+XVSplName}` : '';
        const GlobalHeader = i == OrderHD.length-1 ? {border: [true, false,true,true]} : {border: [true, false,true,false]};
        Item.push([
            {text: NameDisplay, fontSize: 8, alignment: 'left',rowSpan:OrderDT.length+1,...GlobalHeader},
            {text: DateDisplay, fontSize: 8, alignment: 'center',rowSpan:OrderDT.length+1,...GlobalHeader},
            {text: XVGrhDocNo, fontSize: 8, alignment: 'left',border: [true, false,true,false]},
            {text: "", fontSize: 8, alignment: 'center',border: [true, false,true,false]},
            {text: "", fontSize: 8, alignment: 'center',border: [true, false,true,false]},
            {text: "", fontSize: 8, alignment: 'center',border: [true, false,true,false]}
        ],)
        for (let j = 0; j < OrderDT.length; j++) {
            const DetailBorder = (i == OrderHD.length-1 && j == OrderDT.length-1) ? {border: [true, false,true,true]} : {border: [true, false,true,false]}

            const {XIGrdQtyPo,xvmatcode,XVGrdName,XVGrdUnitName,XIGrdQty,XIGrdFactor} = OrderDT[j]
            Item.push([
                {},
                {},
                {text: `\t${xvmatcode} ${XVGrdName}`, fontSize: 8, alignment: 'left',preserveLeadingSpaces: true,...DetailBorder},
                {text: XVGrdUnitName+ " / "+XIGrdFactor, fontSize: 8, alignment: 'left',...DetailBorder},
                {text: formatMoney(XIGrdQtyPo,0,''), fontSize: 8, alignment: 'right',...DetailBorder},
                {text: formatMoney(XIGrdQty,0,''), fontSize: 8, alignment: 'right',...DetailBorder},
            ],)
        }

    }
    return {Items: Item }
}
function renderSumRow(Items){
    Items.push([
        {text: "", fontSize: 8, alignment: 'center',colSpan:3},
        {},
        {},
        {},
        {},
        {text: "", fontSize: 8, alignment: 'right'},
    ],)
    return Items;
}
//Utility


function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
