const miniMumRow = 30;
const HeaderName = "306 รายงานการเบิกวัสดุแยกตามวัสดุ";
const column = 6;

function countLineSpace(text) {
    return Math.floor((text.length / 20)) * 10;
}

function renderPdf(result,filter) {
    let header = SectionHeader(filter);
    let ListItems = ListItem(result);
    let SubHeaderX = SubHeader();

    var dd = {
        pageSize: 'A4',
        // pageMargins: [20, 20],
        pageMargins: [20, 86, 20, 20],
        header: function (currentPage, pageCount, pageSize) {
            return {
                stack: [...header,...SubHeaderX],
                margin: [20, 15, 20, 0]
            }
        },
        content: [
            ...ListItems,
        ],
        defaultStyle: {
            font: "Sarabun",
            fontSize: 7,

        }
    }
    pdfMake.createPdf(dd).open()
}

// ซ้าย บน ขวา ล่าง

function SectionHeader(filter) {

    let DateStart,DateEnd,CstNameStart,CstNameEnd
    if(!!filter.isAllTime){
         DateStart = "ทั้งหมด"
         DateEnd = "ทั้งหมด"
    }else{
         DateStart = convertDateToLocale(filter.DateStart)
         DateEnd = convertDateToLocale(filter.DateEnd)
    }
    if(!!filter.isAllMat){
         CstNameStart = "ทั้งหมด"
         CstNameEnd = "ทั้งหมด"
    }else{
         CstNameStart = (filter.MatStart)
         CstNameEnd = (filter.MatEnd)
    }
    return [
        {
            text: HeaderName,
            alignment: 'center',
            fontSize: 11,
            bold: true,

        },
        {
            text: `จากวันที่ ${DateStart}  ถึงวันที่ ${DateEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
        {
            text: `จากวัสดุ ${CstNameStart}\nถึง ${CstNameEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
    ]
}

function SubHeader() {
    return [
        {
            table: {
                widths: [120, 60, '*', 80, 80],
                body: [
                    [
                        {text: 'วัสดุ', fontSize: 9, alignment: 'left',   border: [true, true,true,true]},
                        {text: 'วันที่', fontSize: 9, alignment: 'left',   border: [true, true,true,true]},
                        {text: 'เลขที่ใบเบิกวัสดุ', fontSize: 9, alignment: 'left', border: [true, true,true,true]},
                        {text: 'แนะนำ', fontSize: 9, alignment: 'right',  border: [true, true,true,true]},
                        {text: 'เบิก', fontSize: 9, alignment: 'right',  border: [true, true,true,true]},
                    ],
                ]
            },

            layout: {
                fillColor: function (rowIndex, node, columnIndex) {
                    return (rowIndex === 0 ) ? '#CCCCCC' : null;
                },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}
function ListItem(result) {
    let arrayItems = [] ;
    for(let i = 0 ; i < result.length ; i++){
        let {Items} = renderItem(result[i]);
        // if(Items.length >0){
        //     Items = renderSumRow(Items);
        // }
        arrayItems = [...arrayItems,...Items]
    }
    return [
        {
            table: {
                widths: [120, 60, '*', 80, 80],
                body: [
                    ...arrayItems,
                ]
            },
        },

    ]
}
function renderItem({xvmatcode,xvmatname,OrderHD}) {
    let Item = []

    for (let i = 0; i < OrderHD.length; i++) {
        const {XVGihDocNo,XDGihDocDate,XIGidQtyOr,XIGidQty} = OrderHD[i];
        const oldValue = OrderHD[i-1] ?? {XVGihDocNo :null , XDGihDocDate:null};
        let DateDisplay ;
        if(XDGihDocDate == oldValue.XDGihDocDate){
            DateDisplay=""
        }else{
            DateDisplay = convertDateToLocale(XDGihDocDate)
        }
        let NameDisplay = i == 0 ? `${xvmatcode+" "+xvmatname}`:'';
        const DetailBorder = (i == OrderHD.length-1) ? {border: [true, false,true,true]} : {border: [true, false,true,false]}
        const GlobalHeader = i == OrderHD.length-1 ? {border: [true, false,true,true]} : {border: [true, false,true,false]};
        if(i == 0 ){
            Item.push([
                {text: NameDisplay, fontSize: 8, alignment: 'left',rowSpan:OrderHD.length},
                {text: DateDisplay, fontSize: 8, alignment: 'center',...GlobalHeader},
                {text: XVGihDocNo, fontSize: 8, alignment: 'left',...DetailBorder},
                {text: formatMoney(XIGidQtyOr,0,''), fontSize: 8, alignment: 'right',...DetailBorder},
                {text: formatMoney(XIGidQty,0,''), fontSize: 8, alignment: 'right',...DetailBorder},
            ],)
        }else{
            Item.push([
                {},
                {text: DateDisplay, fontSize: 8, alignment: 'center',...GlobalHeader},
                {text: XVGihDocNo, fontSize: 8, alignment: 'left',...DetailBorder},
                {text: formatMoney(XIGidQtyOr,0,''), fontSize: 8, alignment: 'right',...DetailBorder},
                {text: formatMoney(XIGidQty,0,''), fontSize: 8, alignment: 'right',...DetailBorder},
            ],)
        }

    }
    return {Items: Item }
}
function renderSumRow(Items){
    Items.push([
        {},
        {},
        {},
        {},
        {},
    ],)
    return Items;
}
//Utility


function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
