const miniMumRow = 30;
const HeaderName = "404 รายงานการเบิกจ่ายสินค้าแยกตามสินค้า";
const column = 6;

function countLineSpace(text) {
    return Math.floor((text.length / 20)) * 10;
}

function renderPdf(result,filter) {
    let header = SectionHeader(filter);
    let ListItems = ListItem(result);
    let SubHeaderX = SubHeader();

    var dd = {
        pageSize: 'A4',
        // pageMargins: [20, 20],
        pageMargins: [20, 86, 20, 20],
        header: function (currentPage, pageCount, pageSize) {
            return {
                stack: [...header,...SubHeaderX],
                margin: [20, 15, 20, 0]
            }
        },
        content: [
            ...ListItems,
        ],
        defaultStyle: {
            font: "Sarabun",
            fontSize: 7,

        }
    }
    pdfMake.createPdf(dd).open()
}

// ซ้าย บน ขวา ล่าง

function SectionHeader(filter) {

    let DateStart,DateEnd,CstNameStart,CstNameEnd
    if(!!filter.isAllTime){
         DateStart = "ทั้งหมด"
         DateEnd = "ทั้งหมด"
    }else{
         DateStart = convertDateToLocale(filter.DateStart)
         DateEnd = convertDateToLocale(filter.DateEnd)
    }
    if(!!filter.isAllMst){
         CstNameStart = "ทั้งหมด"
         CstNameEnd = "ทั้งหมด"
    }else{
         CstNameStart = (filter.MstItemStart)
         CstNameEnd = (filter.MstItemEnd)
    }
    return [
        {
            text: HeaderName,
            alignment: 'center',
            fontSize: 11,
            bold: true,

        },
        {
            text: `จากวันที่ ${DateStart}  ถึงวันที่ ${DateEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
        {
            text: `จากสินค้า ${CstNameStart}\nถึง ${CstNameEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
    ]
}

function SubHeader() {
    return [
        {
            table: {
                widths: [80, 60, '*',  80],
                body: [
                    [
                        {text: 'สินค้า', fontSize: 9, alignment: 'left',   border: [true, true,true,true]},
                        {text: 'วันที่', fontSize: 9, alignment: 'left',   border: [true, true,true,true]},
                        {text: 'เลขที่ใบเบิกจ่ายสินค้า', fontSize: 9, alignment: 'left', border: [true, true,true,true]},
                        {text: 'จำนวน', fontSize: 9, alignment: 'left',  border: [true, true,true,true]},
                    ],
                ]
            },

            layout: {
                fillColor: function (rowIndex, node, columnIndex) {
                    return (rowIndex === 0 ) ? '#CCCCCC' : null;
                },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}
function ListItem(result) {
    let arrayItems = [] ;
    for(let i = 0 ; i < result.length ; i++){
        let Items = renderItem(result[i]);
        arrayItems = [...arrayItems,...Items]
    }
    return [
        {
            table: {
                widths: [80, 60, '*',  80],
                body: [
                    ...arrayItems,
                ]
            },

        },

    ]
}
function renderItem({xvpdtcode,xvpdtname,OrderHD}) {
    let Item = []
    for (let i = 0; i < OrderHD.length; i++) {
        const {XVFihDocNo,XDFihDocDate,SumQty} = OrderHD[i];
        // const oldValue = OrderHD[i-1] ?? {XVFihDocNo :null , XDFihDocDate:null};
        let DateDisplay,DateHeader;
        // if(XDFihDocDate == oldValue.XDFihDocDate){
        //     DateDisplay=""
        //     // DateHeader =  {border: [true, false,true,true]}
        // }else{
        //     // DateHeader =  {border: [true, false,true,true]};
        // }
        DateDisplay = convertDateToLocale(XDFihDocDate)

        let NameDisplay = i == 0 ? `${xvpdtcode+" "+xvpdtname}`:'';

        const GlobalHeader = i == OrderHD.length-1 ? {border: [true, false,true,true]} : {border: [true, false,true,true]};
        Item.push([
            {text: NameDisplay, fontSize: 8, alignment: 'left',rowSpan:OrderHD.length ,...GlobalHeader},
            {text: DateDisplay, fontSize: 8, alignment: 'center',...GlobalHeader},
            {text: XVFihDocNo, fontSize: 8, alignment: 'left',...GlobalHeader},
            {text: formatMoney(SumQty,0,''), fontSize: 8, alignment: 'left',...GlobalHeader},
            // {text: SumOrder, fontSize: 8, alignment: 'right'},
            // {text: SumFR, fontSize: 8, alignment: 'right'},
        ],)
    }
    return Item
}

//Utility


function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
