@extends('layouts.master')
@section('header')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.8/dist/css/select2.min.css" rel="stylesheet"/>
@endsection
@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-6">
                    <h5>ฟอร์มเพิ่มข้อมูล Product</h5>
                </div>
                <div class="col-6 text-right">
                    <a href="{{route('product.index')}}" class="btn btn-success"><i
                            class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-12 pr-5 pl-5">
                    <form action="{{route('bomSize.store')}}" method="POST" id="Form_Submit"
                          onsubmit="return validateForm()">
                        @csrf
                        <div class="form-row mt-3">
                            <div class="col-4">
                                <label for="">รหัส Product</label>
                                <input type="text" class="form-control" name="xvpdtcode" value="{{$Product->xvpdtcode}}"
                                       readonly>
                            </div>
                            <div class="col-4">
                                <label for="">ชื่อ Product</label>
                                <input type="text" class="form-control" name="xvpdtname" value="{{$Product->xvpdtname}}"
                                       readonly id="xvpdtname">
                            </div>
                            <div class="col-1">
                                <label for="">Size</label>
                                <input type="text" class="form-control" name="XVPszName" value="{{$sizeCode}}"
                                       readonly id="XVPszName">
                            </div>
                        </div>
                        <div class="dropdown-divider"></div>



                        <div class="form-row mt-3">
                            <div class="col-12">
                                <label for="">เลือกกลุ่ม Material</label>
                                <select class="form-control" id="SelectMat" multiple="multiple">
                                    <option></option>
                                @foreach ($Material as $key => $item)
                                        <option  value="{{$item->xvmatcode}}_{{$item->xvuntcode}}">{{$item->xvmatname}} // {{$item->xvuntname}} // {{$item->xvmatdes}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="dropdown-divider"></div>

                        <div id="Control">
                            @foreach($oldItem as $key => $item)
                                <div class="form-row mt-3 MatControl" id="{{$item->xvmatcode}}_{{$item->xvuntcode}}">
                                    <div class="col-5">
                                        <label for="">Material</label>
                                        <input type="text" class="form-control" value="{{$item->xvmatname}} // {{$item->xvuntname}} // {{$item->xvmatdes}}"
                                               readonly>
                                        <input type="hidden" name="xvmatcode[]" value="{{$item->xvmatcode}}">
                                        <input type="hidden" name="xvuntcode[]" value="{{$item->xvuntcode}}">
                                    </div>
                                    <div class="col-2">
                                        <label for="">จำนวน</label>
                                        <input type="number" class="form-control" name="XIBomQty[]" value="{{$item->XIBomQty}}">
                                    </div>
                                    <!--                                <button type="button" class="btn btn-danger mt-3" onclick="remove(this)">Remove</button>-->
                                </div>
                            @endforeach
                        </div>
                        <div class="dropdown-divider"></div>
                        <div class="form-row mt-3 mb-5">
                            <div class="col-6 text-center">
                                <a href="{{route('product.index')}}" class="btn btn-danger">ยกเลิก</a>
                            </div>
                            <div class="col-6 text-center">
                                <button type="submit" class="btn btn-primary">บันทึก</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


@endsection
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.8/js/select2.min.js" defer></script>
<script>
    $(document).ready(function () {
        var oldList = document.getElementsByClassName("MatControl")
        let oldArr = [];
        for(let i = 0 ; i < oldList.length; i++){
            oldArr.push(oldList[i].id)
        }
        console.log(oldArr)
        var s2 = $('#SelectMat').select2({
            placeholder: "เลือก Material",
        });
        s2.val(oldArr).trigger("change");
        $('#SelectMat').on('select2:select', function (e) {
            var {id,text} = (e.params.data);
            createMaterial(id,text)
        });
        $('#SelectMat').on('select2:unselect', function (e) {
            var data = (e.params.data);
            // console.log(data)
            document.getElementById(data.id).remove()
            // createMaterial(id,text)
        });
    });

    function getArrayInput(NameElement) {
        var input = document.getElementsByName(NameElement);
        let arr = []
        for (var i = 0; i < input.length; i++) {
            arr.push(input[i].value)
        }
        return arr;
    }

    function createMaterial(id,text) {
        let item = id.split("_")
        // console.log(text.trim())
        const Control = document.getElementById("Control")
        Control.insertAdjacentHTML('beforeend', `<div class="form-row mt-3" id="${id}">
                                <div class="col-5">
                                    <label for="">Material</label>
                                    <input type="text" class="form-control" value="${text.trim()}"
                                           readonly>
                                    <input type="hidden" name="xvmatcode[]" value="${item[0]}">
                                    <input type="hidden" name="xvuntcode[]" value="${item[1]}">
                                </div>
                                <div class="col-2">
                                    <label for="">จำนวน</label>
                                    <input type="number" class="form-control" name="XIBomQty[]" >
                                </div>
<!--                                <button type="button" class="btn btn-danger mt-3" onclick="remove(this)">Remove</button>-->
                            </div>
`)
    }

    function remove(e) {
        e.parentNode.remove()
    }
    function validateForm() {
        const input = getArrayInput('XIBomQty[]');
        const itemFillter = input.filter((item) => item.trim().length === 0)
        if (itemFillter.length > 0) {
            swal('กรุณากรอกจำนวน', "กรุณากรอกจำนวนของวัตถุดิบ", "warning")
        } else {
            return true
        }
        return false
    }
</script>
