@extends('layouts.master')
@php
$menuperm = Illuminate\Support\Facades\Session::get('menu_perm') ?? [];
@endphp
@section('header')
    <link href="{{ asset('css/gijgo.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap4.min.css') }}">
@endsection
<style>
    div.sticky {
        position: sticky;
        top: 0;
        background-color: #ffffff;
        padding-top: 8px;
        z-index: 100;
    }

    form.noStyle {
        margin: 0;
    }

    .btn-circle.btn-sm {
        width: 30px;
        height: 30px;
        padding: 6px 0px;
        border-radius: 15px;
        font-size: 8px;
        text-align: center;
    }

    .form-control {
        display: inline-block !important;
    }

    tr:hover {
        background-color: #f5f5f5;
    }

</style>
@section('content')
    <form action="{{ route('fa.updateStatus') }}" method="POST" style="margin: 0" onkeypress="return event.keyCode != 13;"
        id="updateForm" onsubmit="event.preventDefault(); return Swal_Ask('{{ getDocStatusByCode(3) }}',this)">
        @csrf
        <div class="col-1 text-left">
            <input type="hidden" class="form-control" name="XVFahDocNo" value="{{ $hd->XVFahDocNo }}" readonly>
            <input type="hidden" class="form-control" id="eventRequest" name="eventRequest" value="3" readonly>
            <input type="hidden" class="form-control" id="docStatus" name="docStatus" value="{{ $DocStatus }}" readonly>
        </div>
    </form>
    <form action="{{ route('fa.update') }}" method="POST" id="Form_Submit" class="noStyle" onsubmit="return validateForm()">
        @csrf
        @method('PUT')
        <div class="card ">
            <div class="card-body">
                <div class="sticky">
                    <div class="row ">
                        <div class="col-3 ">
                            <h5>ฟอร์มแก้ไขข้อมูลใบเบิกสินค้า</h5>
                        </div>

                        @if (in_array(15, $menuperm))
                            @php
                                $routeBack = 'fa.index';
                            @endphp
                        {{-- @else
                            @php
                                $routeBack = 'Approve.fa';
                            @endphp --}}
                        @endif
                        @component('Components.HandleDocStatus', ['routeBack' => $routeBack, 'DocStatus' => $DocStatus])
                        @endcomponent

                    </div>
                    <hr>
                </div>
                <h5>ข้อมูลเอกสาร</h5>

                <div class="row border">

                    <div class="col border-right ">

                        @component('FA.components.hd', ['oldHD' => $hd])
                        @endcomponent
                    </div>
                    <div class="col border-right ">

                        @component('FA.components.rmk', ['XVFahDocRmk' => $hd->XVFahDocRmk ?? ''])
                        @endcomponent
                    </div>

                </div>
                <div class="row border">
                    <div class="col border-right ">

                        @component('FA.components.dt', ['oldDT' => $dt, 'DocStatus' => $DocStatus])
                        @endcomponent

                    </div>

                </div>
            </div>
        </div>
        </div>
    </form>
    <input type="hidden" name="msg" value="{{ session()->get('msg') }}">
@endsection
<script src="{{ asset('js/helper.js') }}"></script>
<script src="{{ asset('js/jquery-3.5.1.min.js') }}"></script>
<script src="{{ asset('js/gijgo.min.js') }}" defer type="text/javascript"></script>
<script src="{{ asset('js/select2.min.js') }}" defer></script>
<script src="{{ asset('js/sweetalert.min.js') }}"></script>
<script src="{{ asset('js/pages/Fa/form.js') }}"></script>
<script src="{{ asset('js/ThbNumber.js') }}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
<script src="{{ asset('js/pages/Fr/pdf.js') }}"></script>
<script>
    // SelectMasterItems
</script>

<script>
    async function Swal_Ask(text, form) {
        let resp = swal({
            title: `ยืนยันการ ${text} ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk) form.submit();
    }

    async function updateStatus(statusCode, text) {
        const ApproveForm = document.getElementById("updateForm");
        const eventRequest = document.getElementById("eventRequest");
        let resp = swal({
            title: `ยืนยันการ ${text} ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk) {
            eventRequest.value = statusCode
            ApproveForm.submit()
        };
    }

    $(document).ready(function() {
        if ($('input[name="msg"]').val() == 'IsMoreThanStock') {
            swal("อนุมัติไม่สำเร็จ", "สินค้าใน Stock ไม่เพียงพอต่อการเบิก", "warning");
        }
        if ($('input[name="msg"]').val() == 'IsNotBalanced') {
            swal("เกิดข้อผิดพลาด", "กรุณาทำรายการยอดยกมาสินค้าของเดือนที่แล้วก่อนทำการอนุมัติ", "warning");
        }
        var oldList = document.getElementsByClassName("dtItems")
        let oldArr = [];
        for (let i = 0; i < oldList.length; i++) {
            oldArr.push(oldList[i].id)
        }
        TriggerChange(oldArr)
    })
</script>
