@extends('layouts.master')
@section('header')
    <link href="{{ asset('css/gijgo.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap4.min.css') }}">

@endsection
@php
$menuperm = Illuminate\Support\Facades\Session::get('menu_perm') ?? [];
@endphp
<style>
    div.sticky {
        position: sticky;
        top: 0;
        background-color: #ffffff;
        padding-top: 8px;
        z-index: 100;
    }

    form.noStyle {
        margin: 0;
    }

    .btn-circle.btn-sm {
        width: 30px;
        height: 30px;
        padding: 6px 0px;
        border-radius: 15px;
        font-size: 8px;
        text-align: center;
    }

    .form-control {
        display: inline-block !important;
    }

</style>
@section('content')
    <form action="{{ route('gr.updateStatus') }}" method="POST" style="margin: 0" onkeypress="return event.keyCode != 13;"
        id="updateForm" onsubmit="event.preventDefault(); return Swal_Ask('{{ getDocStatusByCode(3) }}',this)">
        @csrf
        <div class="col-1 text-left">
            <input type="hidden" class="form-control" name="XVGrhDocNo" value="{{ $hd->XVGrhDocNo }}" readonly>
            <input type="hidden" class="form-control" id="eventRequest" name="eventRequest" value="3" readonly>
            <input type="hidden" class="form-control" id="docStatus" name="docStatus" value="{{ $DocStatus }}" readonly>
        </div>
    </form>
    <form action="{{ route('gr.update') }}" method="POST" id="Form_Submit" enctype="multipart/form-data" class="noStyle"
        onsubmit="return validateForm()">
        @csrf
        @method('PUT')
        <div class="card">
            <div class="card-body">
                <div class="sticky">
                    <div class="row ">
                        <div class="col-md-4  col-xl-2">
                            <h5>ฟอร์มแก้ไขข้อมูล ใบรับวัสดุ</h5>
                        </div>
                        {{-- @if ($DocStatus == '1')
                            <div class="col-1 text-left">
                                <button type="submit" class="btn btn-primary">บันทึก</button>
                            </div>
                            <div class="col-1 text-left">
                                <button type="button" class="btn btn-{{getCssDocStatusByCode(3)}}"
                                        id="btn_updateStatus"
                                        onclick="updateStatus(3,'{{getDocStatusByCode(3)}}')">{{getDocStatusByCode(3)}}</button>
                            </div>
                            <div class="col-1 text-left">
                                <button type="button" class="btn btn-{{getCssDocStatusByCode(5)}}"
                                        id="btn_cancle"
                                        onclick="updateStatus(5,'{{getDocStatusByCode(5)}}')">{{getDocStatusByCode(5)}}</button>
                            </div>
                        @endif --}}

                     
                            @php
                                $routeBack = 'gr.index';
                            @endphp

                        {{-- @else
                            @php
                                $routeBack = 'Approve.gr';
                            @endphp --}}

                        
                        @component('Components.HandleDocStatus', ['routeBack' => $routeBack, 'DocStatus' => $DocStatus])
                            <div class="col-1 text-left">
                                <a href="#" type="button" class="btn btn-info"
                                    onclick="renderPdf('{{ route('gr.pdf', ['docNo' => $hd->XVGrhDocNo]) }}')"><i
                                        class="far fa-file-pdf"></i> PDF</a>
                                <input type="hidden" id="url" value="{{ url('') }}">
                            </div>
                            <input type="hidden" id="isView" value="true" readonly>
                        @endcomponent
                        {{-- @if ($DocStatus == '3')
                            <div class="col-1 text-left">
                                <a href="#" type="button" class="btn btn-info"
                                   onclick="renderPdf('{{route('gr.pdf',['docNo'=>$hd->XVGrhDocNo])}}')"><i class="far fa-file-pdf"></i> PDF</a>
                                <input type="hidden" id="url" value="{{url('')}}">
                            </div>
                            <input type="hidden" id="isView" value="true" readonly>
                        @endif

                        <div class="col text-right">
                            <label for="" class="mr-2 fontsi">สถานะเอกสาร : {{getDocStatusByCode($DocStatus)}}</label>

                            <a href="{{route('gr.index')}}" class="btn btn-success"><i
                                    class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
                        </div> --}}
                    </div>
                    <hr>
                </div>
                <h5>ข้อมูลเอกสาร</h5>

                <div class="row border mb-1 pb-0">

                    <div class="col border-right " style="display: none">
                        @component('Components.Supplier', ['oldValue' => $hd->XVSplCode, 'isReadOnly' => true])
                        @endcomponent
                    </div>

                    <div class="col  ">
                        @component('GR.components.hd', ['oldHD' => $hd])
                        @endcomponent
                    </div>
                    <div class="col border-right ">
                        <label class="col-md-4  col-xl-2 col-form-label">สถานที่รับวัสดุ</label>
                        <div class="col-11">
                            <input type="text" class="form-control" name="XVPohDeliveryPlace"
                                value="{{ $hd->XVPohDeliveryPlace }}" readonly>
                        </div>
                        <div class="col-11">
                            <label for="">หมายเหตุ</label>
                            <textarea type="text" class="form-control" name="XVGrhDocRmk" maxlength="100"
                                rows="5">{{ $hd->XVGrhDocRmk ?? '' }}</textarea>
                        </div>
                    </div>

                </div>

                <div class="row mb-1 pb-0">
                    <div class="col border ">
                        @component('GR.components.dt', ['oldHD' => $hd, 'oldDT' => $dt])
                        @endcomponent
                    </div>
                </div>
            </div>
        </div>
    </form>
    <input type="hidden" name="msg" value="{{ session()->get('msg') }}">
@endsection
<script src="{{ asset('js/jquery-3.5.1.min.js') }}"></script>
<script src="{{ asset('js/gijgo.min.js') }}" defer type="text/javascript"></script>
<script src="{{ asset('js/select2.min.js') }}" defer></script>
<script src="{{ asset('js/sweetalert.min.js') }}"></script>
<script src="{{ asset('js/pages/GR/form.js') }}"></script>
<script src="{{ asset('js/ThbNumber.js') }}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
<script src="{{ asset('js/pages/gr/pdf.js') }}"></script>

<script>
    /*
    How to Use Swal_ask add this to form
    {{-- onsubmit="event.preventDefault(); return Swal_Ask('{{getDocStatusByCode($arrayCase[$i])}}',this)" --}}
    */
    async function Swal_Ask(text, form) {
        let resp = swal({
            title: `ยืนยันการ ${text} ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk) form.submit();
    }

    async function updateStatus(statusCode, text) {
        const ApproveForm = document.getElementById("updateForm");
        const eventRequest = document.getElementById("eventRequest");
        let resp = swal({
            title: `ยืนยันการ ${text} ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk) {
            eventRequest.value = statusCode
            ApproveForm.submit()
        };
    }

    $(document).ready(function() {
        if ($('input[name="msg"]').val() == 'IsRefered') {
            swal("เกิดข้อผิดพลาด", "เอกสาร PO ที่ถูกอ้างอิงถูกอนุมัติโดยเอกสาร Order อื่นแล้ว", "warning");
        }
        if ($('input[name="msg"]').val() == 'IsNotBalanced') {
            swal("เกิดข้อผิดพลาด", "กรุณาทำรายการยอดยกมาวัสดุของเดือนที่แล้วก่อนทำการอนุมัติ", "warning");
        }

        let DocStatus = document.getElementById('docStatus').value
        if (DocStatus == 5 || DocStatus == 6) {
            $("#Form_Submit :input").prop("disabled", true);
        }
        const isView = document.getElementById("isView")
        if (isView) {
            $("#Form_Submit :input").prop("disabled", true);
            $("#btn_updateStatus").attr('disabled', false)
            $("#btn_cancle").attr('disabled', false)
        }
    })
</script>
