@extends('layouts.master')
@section('header')
    <link href="{{asset('css/gijgo.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{asset('css/select2.min.css')}}" rel="stylesheet"/>
    <link rel="stylesheet"
          href="{{asset('css/select2-bootstrap4.min.css')}}">
@endsection
<style>
    div.sticky {
        position: sticky;
        top: 0;
        background-color: #ffffff;
        padding-top: 8px;
        z-index: 100;
    }

    form.noStyle {
        margin: 0;
    }

    .btn-circle.btn-sm {
        width: 30px;
        height: 30px;
        padding: 6px 0px;
        border-radius: 15px;
        font-size: 8px;
        text-align: center;
    }

    .form-control {
        display: inline-block !important;
    }

</style>
@section('content')
    <form action="{{route('mat.store')}}" method="POST" id="Form_Submit"
          enctype="multipart/form-data"
          class="noStyle"
          onsubmit="return validateForm()">
        @csrf
        <div class="card ">
            <div class="card-body">
                <div class="sticky">
                    <div class="row ">
                        <div class="col-2 ">
                            <h5>ฟอร์มเพิ่มข้อมูลวัสดุ</h5>
                        </div>

                        <div class="col text-right">
                            <a href="{{route('mat.index')}}" class="btn btn-danger"><i
                                    class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
                                    <button type="submit" class="btn btn-success">บันทึก</button>
                        </div>
                    </div>
                    <hr>
                </div>
                <h5>ข้อมูลเอกสาร</h5>

                <div class="row border">

                    <div class="col border-right ">

                        @component('Materials.components.hd')
                        @endcomponent
                    </div>

                    <div class="col  ">
                        @component('Components.SupplierForMat',['isMultiple'=>true])
                        @endcomponent
                        
                    </div>

                </div>

                <div class="row">
                    <div class="col border-right  ">
                        @component('Materials.components.dt')
                        @endcomponent
                    </div>
                    <div class="col  ">
                        @component('Components.upload')
                        @endcomponent
                    </div>
                </div>
            </div>
        </div>
        </div>
    </form>
    <input type="hidden" name="msg" value="{{session()->get('msg')}}">

@endsection
<script src="{{asset('js/helper.js')}}"></script>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/gijgo.min.js')}}" defer type="text/javascript"></script>
<script src="{{asset('js/select2.min.js')}}" defer></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{asset('js/pages/Material/form.js')}}"></script>
