@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-6">
                    <h5 style="font-weight: bold;">วัสดุ</h5>
                </div>
                <div class="col-6 text-right">
                    <a href="{{route('mat.add')}}" class="btn btn-success"><i class="fas fa-plus-square"></i>
                        เพิ่มข้อมูล</a>
                </div>
            </div>
            <hr>
            <div class="row mt-5">
                <div class="col-12 table-responsive ">
                    <table id="tb_mat" class="table table-striped mt-5">
                        <thead class="thead-light">
                        <tr>
                            <td class="text-left">ลำดับ</td>
                            <td class="text-left">เลขที่วัสดุ</td>
                            <td class="text-left">ชื่อวัสดุ</td>
                            <td class="text-left" style="width:20%;">กลุ่มวัสดุ</td>
                            <td class="text-left" style="width:20%;">ประภทวัสดุ</td>
                            <td class="text-center" style="width:5%;">แก้ไข</td>
                            <td class="text-center">ความเคลื่อนไหววัสดุ</td>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($HD as $key => $item)
                            <tr>
                                <td class="text-left">{{$key += 1}}</td>
                                <td class="text-left">{{$item->xvmatcode}}</td>
                                <td class="text-left">{{$item->xvmatname}}</td>
                                <td class="text-left">{{$item->xvmgpname}}</td>
                                <td class="text-left">{{$item->xvmtyname}}</td>
                                <td class="text-center">
                                    <a href="{{route('mat.edit',$item->xvmatcode)}}" class="btn-sm btn-info"><i
                                            class="fas fa-edit fa-1x"></i></a>
                                </td>
                                <td class="text-center">
                                    <a href="{{route('stk.index',['xvmatcode'=>$item->xvmatcode])}}" class="btn-sm btn-success" target="_blank"><i class="fas fa-store"></i></a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" name="msg" value="{{session()->get('msg')}}">
@endsection
<style>
    #tb_mat thead {
        font-weight: bold;
    }

    #tb_mat tbody {
        font-size: 14px;
    }

    #tb_mat tbody tr:hover {
        background-color: azure;
    }

    #tb_mat tbody td {
        height: 35px;
        vertical-align: middle;
        cursor: pointer;
    }

    #tb_mat_filter {
        margin-bottom: 1cm;
        margin-top: 0.3cm;
    }
</style>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{ asset('js/app.js') }}"></script>
<script src="{{asset('js/pages/po/pdf.js')}}"></script>
<script>
    // renderPdf();
    $(document).ready(function () {
        if ($('input[name="msg"]').val() == 'success') {
            swal("บันทึกข้อมูลเรียบร้อย", "คลิก ตกลง", "success");
        }
        if ($('input[name="msg"]').val() == 'warning') {
            swal('มีรหัส Material นี้แล้ว', "กรุณาตั้งรหัส Material ใหม่", "warning")
        }
        if ($('input[name="msg"]').val() == 'error_duplicate') {
            swal('มีรหัส Unit นี้แล้ว', "กรุณาตั้งรหัส Unit ใหม่", "warning")
        }
        if ($('input[name="msg"]').val() == 'NoDataFound') {
            swal('กรุณาเลือกประเภท Unit ', "กรุณาเลือกประเภท Unit ของ Material", "warning")
        }
        if ($('input[name="msg"]').val() == 'NoDataFound_Factor') {
            swal('กรุณากรอกจำนวนสินค้าของประเภท Unit', "กรุณากรอกจำนวนสินค้าของประเภท Unit", "warning")
        }
        // New
        if ($('input[name="msg"]').val() == 'error_notfound') {
            swal('ไม่พบข้อมูล', "ไม่พบข้อมูลรายการแก้ไขที่เลือก", "warning")
        }

        $('#tb_mat').DataTable({
            "language": {
                "search": "ค้นหา"
            },
        });
    })

    function setData(xvpdtcode, xvmatname) {
        $('#modal-form-material-mat input[name="xvpdtcode"]').val(xvpdtcode)
        $('#modal-form-material-mat .modal-title').text('เพิ่ม หน่วยนับ Material รหัส ' + xvpdtcode);
    }

    function del(id) {
        swal({
            title: "คุณต้องลบข้อมูลหรือไม่",
            // text: "Once deleted, you will not be able to recover this imaginary file!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete == true) {
                    let formID = "frm_" + id
                    let frm = document.getElementById(formID)
                    frm.submit()
                }
            })
    }

    function del_Size(xvpdtcode, xvSizeName) {
        swal({
            title: "คุณต้องลบ Size :" + xvSizeName + " ของ Product รหัส " + xvpdtcode + " หรือไม่",
            // text: "Once deleted, you will not be able to recover this imaginary file!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete == true) {
                    let formID = `pdt_${xvpdtcode}_size_${xvSizeName}`
                    let frm = document.getElementById(formID)
                    frm.submit()
                    // location.href = 'del_material_mat/' + xvpdtcode + '/' + xvuntcode + '';
                }
            })
    }
</script>
