@php
    $menuperm = Illuminate\Support\Facades\Session::get('menu_perm') ?? [];
    $roleperm = Illuminate\Support\Facades\Session::get('role_perm') ?? [];
@endphp
@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-6">
                    <h5 style="font-weight: bold;">ใบสั่งซื้อ</h5>
                </div>
               
                @if (in_array(8,$menuperm ))
                    @if (in_array(20,$roleperm) )
                        @if (in_array(1,$roleperm))
                      
                            <div class="col-6 text-right">
                                <a href="{{route('po.add')}}" class="btn btn-success"><i class="fas fa-plus-square"></i>เพิ่มข้อมูล</a>
                            </div>
                        @endif
                    @else
                    <div class="col-6 text-right">
                    <a href="{{route('po.add')}}" class="btn btn-success"><i class="fas fa-plus-square"></i>เพิ่มข้อมูล</a>
                </div>
                    @endif
                @endif
                
              
            </div>
            <hr>
            <div class="row mt-5">
                <div class="col-12 table-responsive ">
                    <table id="tb_mat" class="table table-striped mt-5">
                        <thead class="thead-light">
                        <tr>
                            <td class="text-left">ลำดับ</td>
                            <td class="text-left">เลขที่ PO</td>
                            <td class="text-left">วันที่เอกสาร</td>
                            <td class="text-left">ผู้จัดจำหน่าย</td>
                            <td class="text-right">รวมทั้งสิ้น</td>
                            <td class="text-left">สถานะเอกสาร</td>
                            <td class="text-center">แก้ไข</td>
                            <td class="text-center">PDF</td>
                            {{-- <td class="text-center">ใบรับของ</td> --}}
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($HD as $key => $item)
                            <tr>
                                <td class="text-left">{{$key += 1}}</td>
                                <td class="text-left">{{$item->XVPohDocNo}}</td>
                                <td class="text-left">{{date_YmdTodmY($item->XDPohDocDate)}}</td>
                                <td class="text-left">{{$item->XVSplName}}</td>
                                <td class="text-right">{{number_format($item->XFPohNet,2)}}</td>
                                <td class="text-left">{{getDocStatusByCode($item->XVPohDocStatus)}} @if($item->XBPohIsRefered)
                                        ( รับของแล้ว ) @endif</td>
                                <td class="text-center">
                                    <a href="{{route('po.edit',$item->XVPohDocNo)}}" class="btn-sm btn-info"><i
                                            class="fas fa-edit fa-1x"></i></a></td>
                                <td class="text-center">
                                    @if($item->XVPohDocStatus == "3")
                                        <a href="#"
                                           onclick="renderPdf('{{route('po.getOld',['docNo'=>$item->XVPohDocNo])}}')"
                                           class="btn-sm btn-info">
                                            <i class="far fa-file-pdf"></i></a>
                                    @endif
                                </td>
                                {{-- <td class="text-center">
                                    @if($item->XVPohDocStatus == "3")
                                        <a href="{{route('gr.add',$item->XVPohDocNo)}}" class="btn-sm btn-success">
                                            <i class="fas fa-list-alt"></i></a>
                                @endif
                            </td> --}}
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" name="msg" value="{{session()->get('msg')}}">
    <input type="hidden" id="url" value="{{url('')}}">
@endsection
<style>
    #tb_mat thead {
        font-weight: bold;
    }

    #tb_mat tbody {
        font-size: 14px;
    }

    #tb_mat tbody tr:hover {
        background-color: azure;
    }

    #tb_mat tbody td {
        height: 35px;
        vertical-align: middle;
        cursor: pointer;
    }

    #tb_mat_filter {
        margin-bottom: 1cm;
        margin-top: 0.3cm;
    }
</style>
<script src="{{asset('js/ThbNumber.js')}}"></script>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
<script src="{{asset('js/pages/po/pdf.js')}}"></script>
<script>
    $(document).ready(function () {
        if ($('input[name="msg"]').val() == 'success') {
            swal("บันทึกข้อมูลเรียบร้อย", "คลิก ตกลง", "success");
        }
        if ($('input[name="msg"]').val() == 'warning') {
            swal('มีรหัส Material นี้แล้ว', "กรุณาตั้งรหัส Material ใหม่", "warning")
        }
        if ($('input[name="msg"]').val() == 'error_duplicate') {
            swal('มีรหัส Unit นี้แล้ว', "กรุณาตั้งรหัส Unit ใหม่", "warning")
        }
        if ($('input[name="msg"]').val() == 'NoDataFound') {
            swal('กรุณาเลือกประเภท Unit ', "กรุณาเลือกประเภท Unit ของ Material", "warning")
        }
        if ($('input[name="msg"]').val() == 'NoDataFound_Factor') {
            swal('กรุณากรอกจำนวนสินค้าของประเภท Unit', "กรุณากรอกจำนวนสินค้าของประเภท Unit", "warning")
        }
        // New
        if ($('input[name="msg"]').val() == 'error_notfound') {
            swal('ไม่พบข้อมูล', "ไม่พบข้อมูลรายการแก้ไขที่เลือก", "warning")
        }
        if ($('input[name="msg"]').val() == 'cantrefapprove') {
            swal("ไม่สามารถใช้เอกสาร PO ที่เลือกเพื่อทำใบเอกสาร GR ได้กรุณายืนยันใบ PO ก่อนสั่ง", "คลิก ตกลง", "success");
        }

        $('#tb_mat').DataTable({
            "language": {
                "search": "ค้นหา"
            }
        });
    })

    function setData(xvpdtcode, xvmatname) {
        $('#modal-form-material-mat input[name="xvpdtcode"]').val(xvpdtcode)
        $('#modal-form-material-mat .modal-title').text('เพิ่ม หน่วยนับ Material รหัส ' + xvpdtcode);
    }

    function del(id) {
        swal({
            title: "คุณต้องลบข้อมูลหรือไม่",
            // text: "Once deleted, you will not be able to recover this imaginary file!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete == true) {
                    let formID = "frm_" + id
                    let frm = document.getElementById(formID)
                    frm.submit()
                }
            })
    }

    function del_Size(xvpdtcode, xvSizeName) {
        swal({
            title: "คุณต้องลบ Size :" + xvSizeName + " ของ Product รหัส " + xvpdtcode + " หรือไม่",
            // text: "Once deleted, you will not be able to recover this imaginary file!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete == true) {
                    let formID = `pdt_${xvpdtcode}_size_${xvSizeName}`
                    let frm = document.getElementById(formID)
                    frm.submit()
                    // location.href = 'del_material_mat/' + xvpdtcode + '/' + xvuntcode + '';
                }
            })
    }
</script>
