@extends('layouts.master')
@section('header')
    <link href="{{ asset('css/gijgo.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap4.min.css') }}">

@endsection
@php
use Illuminate\Support\Facades\DB;
$DataSource = DB::table('vk2_users')
->get()->toArray();
$pk = "id";
$display = "name";
@endphp
@section('content')

    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <div class="card">
        <div class="card-body">
            <div class="row ">
                <div class="col-6">
                    <h5 style="font-weight: bold;">รายงานการเบิกวัสดุแยกตามผู้เบิก</h5>
                </div>
                <div class="col-6 text-right">
                    <a href="{{route('report.dashboard.index')}}" class="btn btn-danger ">ย้อนกลับ</a>
                </div>
            </div>
            <hr>
            <div class="card-body">
                <div class="row mt-1 ">
                    <div class="card " style="max-width: 650px;min-width: 650px;margin: auto;
                        padding: 10px;">
                        <div class="col-12 text-center mt-2">
                            <h6 style="font-weight: bold ">เงื่อนไขในการเลือก</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 ">
                                    <h6 style="font-weight: bold">วันที่</h6>
                                    <input type="checkbox" class="mr-2" id="AllDate" onclick="AllDate()" checked>ทั้งหมด
                                    <div class="row mt-3">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3 pr-2 text-right">
                                            ตั้งแต่วันที่</p>
                                        <input class="form-control" type="date" value="" name="DateStart" id="DateStart"
                                            style="max-width: 180px;min-width: 180px;">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">
                                            ถึงวันที่</p>
                                        <input class="form-control" type="date" value="" name="DateEnd" id="DateEnd"
                                            style="max-width: 180px;min-width: 180px;">
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6 style="font-weight: bold">พนักงาน</h6>
                                    <input type="checkbox" class="mr-2" id="AllUser" onclick="AllUser()" checked>ทั้งหมด
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">จาก</p>
                                        <select class="form-control" id="SelectUsersStart"
                                        name="SelectUsers"
                                         style="max-width: 480px;min-width: 480px;"
                                >
                                    <option></option>
                                    @foreach ($DataSource as $key => $item)
                                        <option
                                            @if(isset($oldValue) && $oldValue==$item->$pk) selected @endif
                                        value="{{$item->$pk}}">{{$item->$pk}} : {{$item->$display}}</option>
                                    @endforeach
                                </select>

                                    </div>
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">ถึง</p>
                                        <select class="form-control" id="SelectUsersEnd"
                                        name="SelectUsers"
                                        style="max-width: 480px;min-width: 480px;"
                                >
                                    <option></option>
                                    @foreach ($DataSource as $key => $item)
                                        <option
                                            @if(isset($oldValue) && $oldValue==$item->$pk) selected @endif
                                        value="{{$item->$pk}}">{{$item->$pk}} : {{$item->$display}}</option>
                                    @endforeach
                                </select>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="row mt-1">

                            <div class="col-8 text-right">
                                <button class="btn btn-info bottom " style="vertical-align: bottom;" onclick="datareport()">
                                    export pdf</button>
                                <button class="btn btn-success bottom " style="vertical-align: bottom;" onclick=" datareportexcel()">export
                                    excel</button>
                            </div>
                        </div>
                        <div style=" visibility: hidden;" id="a">
                            <table id="example" ></table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" id="UserStart">
    <input type="hidden" id="UserEnd">
    </div>
    <script src="//unpkg.com/xlsx/dist/xlsx.full.min.js" type="text/javascript"></script>
    <script>
        $(document).ready(function() {
            AllDate();
            AllUser();
            const UserStart = $('#SelectUsersStart').select2({
                placeholder: "กรุณาเลือกพนักงาน",
                theme: 'bootstrap4',
            });
            const UserEnd =  $('#SelectUsersEnd').select2({
                placeholder: "กรุณาเลือกพนักงาน",
                theme: 'bootstrap4',
            });
            UserStart.on('select2:select', function(e) {
                var {
                    id,
                    text
                } = (e.params.data);
                $("#UserStart").val(text.trim());
            });
            UserEnd.on('select2:select', function(e) {
                var {
                    id,
                    text
                } = (e.params.data);
                $("#UserEnd").val(text.trim());
            });
            Date.prototype.toDateInputValue = (function() {
                var local = new Date(this);
                local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
                return local.toJSON().slice(0, 10);
            });

            document.getElementById('DateStart').value = new Date().toDateInputValue();
            document.getElementById('DateEnd').value = new Date().toDateInputValue();

        })

        function lll(sss) {
            console.log(sss);

        }

    </script>

    <script>
         function excel()
        {
            var wb = XLSX.utils.table_to_book(document.getElementById('example'));
            XLSX.writeFile(wb, 'sample.xlsx');
            return false;
        }
          function AllUser() {
            var checkBox = document.getElementById("AllUser");
            if (checkBox.checked == true) {
                document.getElementById('SelectUsersStart').disabled = true;
                document.getElementById('SelectUsersEnd').disabled = true;
            } else {
                document.getElementById('SelectUsersStart').disabled = false;
                document.getElementById('SelectUsersEnd').disabled = false;
            }
        }

        function AllDate() {
            var checkBox = document.getElementById("AllDate");
            if (checkBox.checked == true) {
                document.getElementById('DateStart').disabled = true;
                document.getElementById('DateEnd').disabled = true;
            } else {
                document.getElementById('DateStart').disabled = false;
                document.getElementById('DateEnd').disabled = false;
            }
        }
          function datareport() {
              var dataSet = [];
              let _token = $('meta[name="csrf-token"]').attr('content');
              const DateStart = document.getElementById('DateStart').value;
              const DateEnd = document.getElementById('DateEnd').value;
              const XVUserCodeStart = document.getElementById('SelectUsersStart').value;
              const XVUserCodeEnd = document.getElementById('SelectUsersEnd').value;
              const isAllTime = document.getElementById('AllDate').checked;
              const isAllUser = document.getElementById('AllUser').checked;
              //ShowValue
              const CstStart = document.getElementById('UserStart').value;
              const CstEnd = document.getElementById('UserEnd').value;

              //End Show Value
              let JsonFilter = {
                  DateStart,
                  DateEnd,
                  XVUserCodeStart: CstStart,
                  XVUserCodeEnd: CstEnd,
                  isAllTime,
                  isAllUser,
              }
              $.ajax({
                  url: '{{ route('report.307.data') }}',
                  type: "POST",
                  data: {
                      _token: _token,
                      DateStart,
                      DateEnd,
                      XVUserCodeStart,
                      XVUserCodeEnd,
                      isAllTime,
                      isAllUser,
                  },
                  success: function(result) {
                      console.log(result);
                      renderPdf(result, JsonFilter);

                  }
              });
          }
          function datareportexcel() {
              var dataSet = [];
              let _token = $('meta[name="csrf-token"]').attr('content');
              const DateStart = document.getElementById('DateStart').value;
              const DateEnd = document.getElementById('DateEnd').value;
              const XVUserCodeStart = document.getElementById('SelectUsersStart').value;
              const XVUserCodeEnd = document.getElementById('SelectUsersEnd').value;
              const isAllTime = document.getElementById('AllDate').checked;
              const isAllUser = document.getElementById('AllUser').checked;
              //ShowValue
              const CstStart = document.getElementById('UserStart').value;
              const CstEnd = document.getElementById('UserEnd').value;

              //End Show Value
              let JsonFilter = {
                  DateStart,
                  DateEnd,
                  XVUserCodeStart: CstStart,
                  XVUserCodeEnd: CstEnd,
                  isAllTime,
                  isAllUser,
              }
              $.ajax({
                  url: '{{ route('report.307.dataexcel') }}',
                  type: "POST",
                  data: {
                      _token: _token,
                      DateStart,
                      DateEnd,
                      XVUserCodeStart,
                      XVUserCodeEnd,
                      isAllTime,
                      isAllUser,
                  },
                  success: function(result) {
                    console.log(result);
                    var dataSet = [];
                    var i = 0;
                    for (let index = 0; index < result.length; index++) {
                        var nf = new Intl.NumberFormat();

                        var row = [
                            result[index].id,
                            result[index].name,
                            result[index].XDGihDocDate,
                            result[index].XVGihDocNo,
                            result[index].xvmatcode,
                            result[index].xvmatname,
                            result[index].XIGidQtyOr,
                            result[index].XIGidQtyStk,
                            result[index].XVGidUnitName+'/'+result[index].XIGidFactor,
                        ];
                        dataSet.push(row);
                    }
                    $('table tbody').remove()

                    $('#example').DataTable({
                        "destroy": true,
                        paging: false,
                        "data": dataSet,
                        "columns": [

                            {
                                "title": "ไอดีผู้เบิก",
                            },
                            {
                                "title": "ชื่อผู้เบิก",
                            },
                            {
                                "title": "วันที่",
                            },
                            {   "title": "เลขที่ใบเบิกวัสดุ",
                            },
                            {   "title": "รหัสวัสดุ",
                            },
                            {   "title": "ชื่อวัสดุ",
                            },

                             {   "title": "แนะนำ",
                            },
                            {   "title": "เบิก",
                            },
                            {   "title": "หน่วย",
                            },

                        ]
                    });

                    if(isAllTime)
                    {

                        start = "ทั้งหมด";
                         end= "ทั้งหมด";
                    }
                    else
                    {
                        start = convertDateToLocale(DateStart);
                        end= convertDateToLocale(DateEnd);
                    }
                    if(isAllUser)
                    {

                      userstart = "ทั้งหมด";
                       userend= "ทั้งหมด";
                    }
                    else
                    {
                      userstart = UserStart;
                      userend= UserEnd;
                    }
                    var htmltb = document.getElementById('example').innerHTML;
                    console.log(htmltb)
                    console.log(document.getElementsByTagName('thead')[0].innerHTML)
                    console.log(document.getElementsByTagName('tbody')[0].innerHTML)
                    document.getElementById('example').innerHTML =
                    "<thead>"+
                    "<tr><th  colspan='6' class='text-center' style='text-align:center;'>307 รายงานการเบิกวัสดุแยกตามผู้เบิก</th></tr>"+
                    "<tr><th  colspan='6' class='text-center'>จากวันที่ "+start+" ถึงวันที่ "+end+ "</th></tr> "+
                    "<tr><th  colspan='6' class='text-center'>จากผู้เบิก"+userstart+" ถึง "+userend+"</th></tr>"+
                    document.getElementsByTagName('thead')[0].innerHTML+
                    "</thead>"+
                    document.getElementsByTagName('tbody')[0].innerHTML
                    ;
                     excel();
                    $('table tbody').remove()
                    document.getElementById('a').innerHTML =" <table id='example' ></table>"
                  }
              });
          }

    </script>
@endsection
<script src="{{ asset('js/pages/report/R307.js') }}"></script>
<script src="{{ asset('js/jquery-3.5.1.min.js') }}"></script>
<script src="{{ asset('js/gijgo.min.js') }}" defer type="text/javascript"></script>
<script src="{{ asset('js/select2.min.js') }}" defer></script>
<script src="{{ asset('js/sweetalert.min.js') }}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
