@extends('layouts.master')
@section('header')
    <link href="{{ asset('css/gijgo.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap4.min.css') }}">

@endsection
@php
use Illuminate\Support\Facades\DB;
$MasterItems = DB::table('tmstmproduct');
if (isset($WhereType) && isset($ValueWhere) && isset($operator)) {
    $MasterItems->where($WhereType, $operator, $ValueWhere);
}
if (isset($FullJoin) && $FullJoin == true) {
    $MasterItems = $MasterItems
        ->join('tmseason', 'tmstmproduct.XISeasonCode', '.tmseason.XISeasonCode')
        ->join('tmforuse', 'tmstmproduct.XIForCode', '.tmforuse.XIForCode')
        ->join('tmgenerate', 'tmstmproduct.XIGenerateCode', '.tmgenerate.XIGenerateCode')
        ->join('tmshape', 'tmstmproduct.XIShapeCode', '.tmshape.XIShapeCode')
        ->join('tmstmmaterial', 'tmstmproduct.xvmatcode', '.tmstmmaterial.xvmatcode');
}
$MasterItems = $MasterItems
    ->orderBy('xvpdtcode', 'desc')
    ->get()
    ->toArray();
foreach ($MasterItems as $item) {
    $item->size = DB::table('tmstmproductsize')
        ->where('xvpdtcode', '=', $item->xvpdtcode)
        ->get()
        ->toArray();
}
@endphp
@section('content')

    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <div class="card">
        <div class="card-body">
            <div class="row ">
                <div class="col-6">
                    <h5 style="font-weight: bold;">รายงานความเคลื่อนไหวของสินค้า</h5>
                </div>
                <div class="col-6 text-right">
                    <a href="{{route('report.dashboard.index')}}" class="btn btn-danger ">ย้อนกลับ</a>
                </div>
            </div>
            <hr>
            <div class="card-body">
                <div class="row mt-1 ">
                    <div class="card " style="max-width: 650px;min-width: 650px;margin: auto;
                        padding: 10px;">
                        <div class="col-12 text-center mt-2">
                            <h6 style="font-weight: bold ">เงื่อนไขในการเลือก</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 ">
                                    <h6 style="font-weight: bold">วันที่</h6>
                                    <input type="checkbox" class="mr-2" id="AllDate" onclick="AllDate()"checked>ทั้งหมด
                                    <div class="row mt-3">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3 pr-2 text-right">
                                            ตั้งแต่วันที่</p>
                                        <input class="form-control" type="date" value="" name="DateStart" id="DateStart"
                                            style="max-width: 180px;min-width: 180px;">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">
                                            ถึงวันที่</p>
                                        <input class="form-control" type="date" value="" name="DateEnd" id="DateEnd"
                                            style="max-width: 180px;min-width: 180px;">
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6 style="font-weight: bold">สินค้า</h6>
                                    <input type="checkbox" class="mr-2" id="AllCst" onclick="AllCst()"checked>ทั้งหมด
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">จาก</p>
                                        <select class="form-control"  style="max-width: 480px;min-width: 480px;" id="SelectMasterItemsStart" name="SelectMasterItemsStart" @if (isset($isMultiple) && $isMultiple == true) multiple @endif @if (isset($isRequired) && $isRequired == true) required @endif
                                    @if (isset($isReadOnly) && $isReadOnly == true)
                                        readonly @endif
                                    >
                                    <option></option>
                                    @foreach ($MasterItems as $key => $item)
                                        <option value="{{ $item->xvpdtcode }}" @if (isset($oldValue) && $oldValue != null && $oldValue == $item->xvpdtcode) selected @endif
                                            data-Size="{{ json_encode($item->size) }}"
                                            data-item="{{ json_encode($item) }}">
                                            {{ $item->xvpdtcode }} : {{ $item->xvpdtname }}</option>
                                    @endforeach
                                </select>
                                    </div>
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">ถึง</p>

                                        <select class="form-control "  style="max-width: 480px;min-width: 480px;"  id="SelectMasterItemsEnd" name="SelectMasterItemsEnd" @if (isset($isMultiple) && $isMultiple == true) multiple @endif @if (isset($isRequired) && $isRequired == true) required @endif
                                        @if (isset($isReadOnly) && $isReadOnly == true)
                                            readonly @endif
                                        >
                                        <option></option>
                                        @foreach ($MasterItems as $key => $item)
                                            <option value="{{ $item->xvpdtcode }}" @if (isset($oldValue) && $oldValue != null && $oldValue == $item->xvpdtcode) selected @endif
                                                data-Size="{{ json_encode($item->size) }}"
                                                data-item="{{ json_encode($item) }}">
                                                {{ $item->xvpdtcode }} : {{ $item->xvpdtname }}</option>
                                        @endforeach
                                    </select>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="row mt-1">

                            <div class="col-8 text-right">
                                <button class="btn btn-info bottom " style="vertical-align: bottom;" onclick="datareport()">
                                    export pdf</button>
                                <button class="btn btn-success bottom " style="vertical-align: bottom;" onclick="datareportexcel()">export
                                    excel</button>
                            </div>
                        </div>
                    </div>
                    <div id="a" style=" visibility: hidden;" > 
                    
                        <table id="example" >
                        </table>
                </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <input type="hidden" id="MstEnd" >
    <input type="hidden" id="MstStart" >
    <script src="//unpkg.com/xlsx/dist/xlsx.full.min.js" type="text/javascript"></script>
    <script>
        $(document).ready(function() {
            AllDate();
            AllCst();

            const CstStart = $('#SelectMasterItemsStart').select2({
                placeholder: "เลือกสินค้า",
                theme: 'bootstrap4',
            });
            const CstEnd = $('#SelectMasterItemsEnd').select2({
                placeholder: "เลือกสินค้า",
                theme: 'bootstrap4',
            });
            Date.prototype.toDateInputValue = (function() {
                var local = new Date(this);
                local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
                return local.toJSON().slice(0, 10);
            });

            document.getElementById('DateStart').value = new Date().toDateInputValue();
            document.getElementById('DateEnd').value = new Date().toDateInputValue();

            CstEnd.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#MstEnd").val(text.trim());
            });
            CstStart.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#MstStart").val(text.trim());
            });

        })

        function lll(sss) {
            console.log(sss);

        }

    </script>
    <script>
          function excel() 
        {
            var wb = XLSX.utils.table_to_book(document.getElementById('example'));
            XLSX.writeFile(wb, '405 รายงานความเคลื่อนไหวของสินค้า.xlsx');
      return false;
        }
        function AllCst() {
            var checkBox = document.getElementById("AllCst");
            if (checkBox.checked == true) {
                document.getElementById('SelectMasterItemsStart').disabled = true;
                document.getElementById('SelectMasterItemsEnd').disabled = true;
            } else {
                document.getElementById('SelectMasterItemsStart').disabled = false;
                document.getElementById('SelectMasterItemsEnd').disabled = false;
            }
        }

        function AllDate() {
            var checkBox = document.getElementById("AllDate");
            if (checkBox.checked == true) {
                document.getElementById('DateStart').disabled = true;
                document.getElementById('DateEnd').disabled = true;
            } else {
                document.getElementById('DateStart').disabled = false;
                document.getElementById('DateEnd').disabled = false;
            }
        }
        function getTextStockCardByCode(code)
{
    switch (code) {
        case '0' :
            return "ยอดยกมา";
            break;
        case '1' :
            return "รับเข้า";
            break;
        case '2' :
            return "เบิกออก";
            break;
        case '3' :
            return "ขาย";
            break;
        case '4' :
            return "คืน";
        case '5' :
            return "ปรับปรุง ( เพิ่ม )";
            break;
        case '6' :
            return "ปรับปรุง ( ลบ )";
            break;
        default :
            return " ";
            break;
    }
}
function calculateStockByCode(code,tempQty,qtystk)
{
    switch (code) {
        case '1' :
        case '5' :
            return tempQty + parseFloat(qtystk)
        case '2' :
        case '6' :
        case '3' :
            return tempQty - parseFloat(qtystk)
        default :
            return qtystk;
    }
}
        function datareport() {
            var dataSet = [];
            let _token = $('meta[name="csrf-token"]').attr('content');
            const DateStart = document.getElementById('DateStart').value;
            const DateEnd = document.getElementById('DateEnd').value;
            const MstItemStart = document.getElementById('SelectMasterItemsStart').value;
            const MstItemEnd = document.getElementById('SelectMasterItemsEnd').value;
            const isAllTime = document.getElementById('AllDate').checked;
            const isAllMst = document.getElementById('AllCst').checked;
            //ShowValue
            const MstStart = document.getElementById('MstStart').value;
            const MstEnd = document.getElementById('MstEnd').value;
            console.log(MstStart,MstEnd)
            let JsonFilter = {
                DateStart,
                DateEnd,
                MstItemStart : MstStart,
                MstItemEnd : MstEnd,
                isAllTime,
                isAllMst,
            }
            $.ajax({
                url: '{{ route('report.405.data') }}',
                type: "POST",
                data: {
                    _token: _token,
                    DateStart,
                    DateEnd,
                    MstItemStart,
                    MstItemEnd,
                    isAllTime,
                    isAllMst,
                },
                success: function(result) {
                    console.log(result);
                    renderPdf(result, JsonFilter);
                }
            });
        }
        function datareportexcel() {
            var dataSet = [];
            let _token = $('meta[name="csrf-token"]').attr('content');
            const DateStart = document.getElementById('DateStart').value;
            const DateEnd = document.getElementById('DateEnd').value;
            const MstItemStart = document.getElementById('SelectMasterItemsStart').value;
            const MstItemEnd = document.getElementById('SelectMasterItemsEnd').value;
            const isAllTime = document.getElementById('AllDate').checked;
            const isAllMst = document.getElementById('AllCst').checked;
            //ShowValue
            const MstStart = document.getElementById('MstStart').value;
            const MstEnd = document.getElementById('MstEnd').value;
            console.log(MstStart,MstEnd)

            //End Show Value
            let JsonFilter = {
                DateStart,
                DateEnd,
                MstItemStart : MstStart,
                MstItemEnd : MstEnd,
                isAllTime,
                isAllMst,
            }
            $.ajax({
                url: '{{ route('report.405.dataexcel') }}',
                type: "POST",
                data: {
                    _token: _token,
                    DateStart,
                    DateEnd,
                    MstItemStart,
                    MstItemEnd,
                    isAllTime,
                    isAllMst,
                },
                success: function(result) {
                    console.log(result);
                    var OUTFILE = 'tmp/ex1.xlsx';
                    var workbook = {
      SheetNames : ["Sheet1"],
      Sheets: {
        "Sheet1": {
          "B2":{ v:1000, s:{numFmt:'"$"#,##0.00_);[Red]\\("$"#,##0.00\\)'}},
          "!ref":"B2:C3"
        }
      }
    };

    // write the file and read it back...
    XLSX.writeFile(workbook, OUTFILE, {bookType: 'xlsx', bookSST: false});
                    var dataSet = [];
                    var tempQty=0;
                    for (let index = 0; index < result.length; index++) {  
                        var row=[result[index].xvpdtcode,
                                result[index].xvpdtname,
                                result[index].xvpszname,
                                result[index].xdstkdate,
                               result[index].xvstktype,
                                result[index].xvstkdocno,
                                result[index].xistkqty,
                                (index>0)
                                ?(result[index].xvpdtcode==result[index-1].xvpdtcode && result[index].xvpszname==result[index-1].xvpszname)
                                        ?tempQty=calculateStockByCode(result[index].xvstktype,tempQty,result[index].xistkqty)
                                        :tempQty=calculateStockByCode(result[index].xvstktype,0,result[index].xistkqty)
                                :tempQty=calculateStockByCode(result[index].xvstktype,tempQty,result[index].xistkqty) 
                            ];
                            dataSet.push(row);
                    }
                    console.log(dataSet);    
                    var i = 0;
                    $('table tbody').remove()
                    $('#example').DataTable({
                        "destroy": true,
                        "data": dataSet,
                        paging: false,
                        "columns": [

                            {
                                "title": "รหัสสินค้า",
                            },
                            {
                                "title": "ชื่อสินค้า",
                            },
                            {   "title": "ไซส์",
                            },
                         
                            {   "title": "วันที่",
                            },
                            {
                                "title":"ประเภท"
                            },
                            {   "title": "เอกสาร",
                            },
                            {   "title": "จำนวน",
                            },
                            {   "title": "จำนวนคงเหลือ",
                            },
                            


                        ]
                    });
                    if(isAllTime)
                    {
                        
                        start = "ทั้งหมด";
                         end= "ทั้งหมด";
                    }
                    else
                    {
                        start = convertDateToLocale(DateStart);
                        end= convertDateToLocale(DateEnd);
                    }
                    if(isAllMst)
                    {
                        
                        matstart = "ทั้งหมด";
                         matend= "ทั้งหมด";
                    }
                    else
                    {
                        matstart = MstStart;
                        matend= MstEnd;
                    }

                    var htmltb = document.getElementById('example').innerHTML;
                    console.log(htmltb)
                    console.log(document.getElementsByTagName('thead')[0].innerHTML)
                    console.log(document.getElementsByTagName('tbody')[0].innerHTML)
                    document.getElementById('example').innerHTML =
                    "<thead>"+
                    "<tr><th  colspan='8' class='text-center' >405 รายงานความเคลื่อนไหวของสินค้า</th></tr>"+
                    "<tr><th  colspan='8' class='text-center'> จากวันที่"+start+" ถึงวันที่ "+end+ "</th></tr> "+
                    "<tr><th  colspan='8' class='text-center'>จากสินค้า "+matstart+" ถึง "+matend+"</th></tr>"+
                    document.getElementsByTagName('thead')[0].innerHTML+
                    "</thead>"+
                    document.getElementsByTagName('tbody')[0].innerHTML
                    ;
                   excel();
                    $('table tbody').remove()
                    document.getElementById('a').innerHTML =" <table id='example' ></table>"
                  

                   
                   
                   
                }
               
            });
        }
        function convertDateToLocale(date) {
            return new Date(date).toLocaleDateString('th')
        }

    </script>
@endsection
<script src="{{ asset('js/pages/report/R405.js') }}"></script>
<script src="{{ asset('js/jquery-3.5.1.min.js') }}"></script>
<script src="{{ asset('js/gijgo.min.js') }}" defer type="text/javascript"></script>
<script src="{{ asset('js/select2.min.js') }}" defer></script>
<script src="{{ asset('js/sweetalert.min.js') }}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
