@extends('layouts.master')
@section('content')
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-6">
          <h5 style="font-weight: bold;">Material</h5>
        </div>
        <div class="col-6 text-right">
           <a href="{{route('frm_add_material')}}" class="btn btn-success"><i class="fas fa-plus-square"></i> เพิ่มข้อมูล</a>
        </div>
      </div>
      <hr>
      <div class="row mt-5">
        <div class="col-12 table-responsive ">
          <table id="tb_mat" class="table table-striped mt-5">
            <thead class="thead-light">
              <tr>
                <td class="text-center">ที่</td>
                <td>รหัส</td>
                <td>ประเภท</td>
                <td>กลุ่ม</td>
                <td>ชื่อ</td>
                <td>รายละเอียด</td>
                <td>หน่วยนับ</td>
                <td>Supplier</td>
                <td class="text-center">เพิ่ม หน่วยนับ</td>
                <td class="text-center">แก้ไข</td>
                <td class="text-center">ลบ</td>
              </tr>
            </thead>
            <tbody>
              @foreach ($mats as $key => $mat)
              <tr>
                <td class="text-center">{{$key += 1}}</td>
                <td>{{$mat->xvmatcode}}</td>
                <td>{{$mat->xvmtyname}}</td>
                <td>{{$mat->xvmgpname}}</td>
                <td>{{$mat->xvmatname}}</td>
                <td>{{$mat->xvmatdes}}</td>
                <td class="pb-0 pt-0">
                  @foreach ($mat_units as $mat_unit)
                    <div style="@if($mat_unit->xvmatcode != $mat->xvmatcode) display:none; @endif padding-left:0.3cm; background-color:#fafafa;border:0.5px solid #f2f2f2;" class="row">
                      <div class="col pt-2" style="">
                        <p>{{$mat_unit->ximunfactor}}</p>
                      </div>
                        <div class="col pt-2" style="">
                            <p>{{$mat_unit->xvuntname}}</p>
                        </div>
                      <div class="col pt-2">
                        {{-- <a data-toggle="modal" href="#modal-form-material-edit-mat" onclick="setDataEditMat('{{$mat->xvmatcode}}','{{$mat_unit->xvuntcode}}')"><i class="fas fa-pen" style="color: green;"></i></a> --}}
                        <a class="ml-3" onclick="del_mat_mat('{{$mat->xvmatcode}}','{{$mat_unit->xvuntcode}}')"><i class="fas fa-times-circle" style="color:red;"></i></a>
                      </div>
                    </div>
                  @endforeach
                </td>
                <td>{{$mat->XVSplName}}</td>
                <td style="text-align: center;"><a data-toggle="modal" href="#modal-form-material-mat" class="btn" style="background-color:cornflowerblue;color:white;" onclick="setData('{{$mat->xvmatcode}}','{{$mat->xvmatname}}');"><i class="fab fa-unity"></i></a></td>
                <td class="text-center"><a href="{{route('frm_edit_material',$mat->xvmatcode)}}" class="btn btn-info"><i class="fas fa-edit fa-1x"></i></a></td>
                <td class="text-center"><a  class="btn btn-danger" style="color: white;" onclick="del('{{$mat->xvmatcode}}')"><i class="fas fa-trash fa-1x"></i></a></td>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
   <input type="hidden" name="msg" value="{{session()->get('msg')}}">
  {{-- modal mat_mat --}}
  <div class="modal" id="modal-form-material-mat" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">ฟอร์มเพิ่มข้อมูล Material Mat</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form action="{{route('add_material_mat')}}" method="POST">
            @csrf
            <div class="form-row">
              <div class="col-12">
                <label for="">Material Mat</label>
                <select name="xvuntcode" id="" class="form-control">
                  <option value="">เลือกหน่วย</option>
                  @foreach ($units as $unit)
                      <option value="{{$unit->xvuntcode}}">{{$unit->xvuntname}}</option>
                  @endforeach
                </select>
              </div>
                <div class="col-12">
                    <label for="">จำนวนนับ</label>
                    <input type="number" value="1" min="0" class="form-control" name="ximunfactor">
                </div>
            </div>
            <div class="form-row mt-5">
              <div class="col-6 text-center">
                <button type="button" class="btn btn-danger" data-dismiss="modal">ยกเลิก</button>
              </div>
              <div class="col-6 text-center">
                <button type="submit" class="btn btn-primary">บันทึกข้อมูล</button>
              </div>
            </div>
            <input type="hidden" name="xvmatcode" value="">
          </form>
        </div>
      </div>
    </div>
  </div>
  {{-- modal mat_mat --}}
  {{-- <div class="modal" id="modal-form-material-edit-mat" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">แก้ไขหน่วย ของ Material</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form action="{{route('edit_material_mat')}}" method="POST">
            @csrf
            <div class="form-row">
              <div class="col-12">
                <label for="">Material Mat</label>
                <select name="xvuntcode" id="" class="form-control">
                  <option value="0">เลือกหน่วย</option>
                  @foreach ($units as $unit)
                      <option value="{{$unit->xvuntcode}}">{{$unit->xvuntname}}</option>
                  @endforeach
                </select>
              </div>
            </div>
            <div class="form-row mt-5">
              <div class="col-6 text-center">
                <button type="button" class="btn btn-danger" data-dismiss="modal">ยกเลิก</button>
              </div>
              <div class="col-6 text-center">
                <button type="submit" class="btn btn-primary">บันทึกข้อมูล</button>
              </div>
            </div>
            <input type="hidden" name="xvmatcode" value="">
          </form>
        </div>
      </div>
    </div>
  </div> --}}
@endsection
<style>
  #tb_mat thead{
    font-weight: bold;
  }
  #tb_mat tbody{
    font-size: 14px;
  }
  #tb_mat tbody tr:hover{
    background-color:azure;
  }
  #tb_mat tbody td{
    height: 35px;
    vertical-align: middle;
    cursor: pointer;
  }
  #tb_mat_filter{
    margin-bottom: 1cm;
    margin-top: 0.3cm;
  }
</style>
<script src="js/jquery-3.5.1.min.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
  $(document).ready(function(){
     if($('input[name="msg"]').val() == 'success'){
       swal("บันทึกข้อมูลเรียบร้อย", "คลิก ตกลง", "success");
     }
     if($('input[name="msg"]').val() == 'warning'){
       swal('มีรหัส Material นี้แล้ว',"กรุณาตั้งรหัส Material ใหม่","warning")
     }
      if($('input[name="msg"]').val() == 'error_duplicate'){
          swal('มีรหัส Unit นี้แล้ว',"กรุณาตั้งรหัส Unit ใหม่","warning")
      }
      if($('input[name="msg"]').val() == 'NoDataFound'){
          swal('กรุณาเลือกประเภท Unit ',"กรุณาเลือกประเภท Unit ของ Material","warning")
      }
      if($('input[name="msg"]').val() == 'NoDataFound_Factor'){
          swal('กรุณากรอกจำนวนสินค้าของประเภท Unit',"กรุณากรอกจำนวนสินค้าของประเภท Unit","warning")
      }

     $('#tb_mat').DataTable({
         "language": {
             "search": "ค้นหา"
         }
     });
  })
  function setData(xvmatcode,xvmatname){
    $('#modal-form-material-mat input[name="xvmatcode"]').val(xvmatcode)
    $('#modal-form-material-mat .modal-title').text('เพิ่ม หน่วยนับ Material รหัส '+xvmatcode);
  }

  function del(id){
    swal({
      title: "คุณต้องลบข้อมูลหรือไม่",
      // text: "Once deleted, you will not be able to recover this imaginary file!",
      icon: "warning",
      buttons: true,
      dangerMode: true,
    })
    .then((willDelete)=>{
      if(willDelete == true){
        location.href = 'del_material/'+id+'';
      }else{
        console.log('no')
      }
    })
  }
  function del_mat_mat(xvmatcode,xvuntcode){
    swal({
      title: "คุณต้องลบหน่วยนับ ของ Material รหัส "+ xvmatcode +" หรือไม่",
      // text: "Once deleted, you will not be able to recover this imaginary file!",
      icon: "warning",
      buttons: true,
      dangerMode: true,
    })
    .then((willDelete)=>{
      if(willDelete == true){
        location.href = 'del_material_mat/'+xvmatcode+'/'+xvuntcode+'';
      }else{
        console.log('no')
      }
    })
  }
</script>
