@extends('layouts.master')
@section('content')
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-6">
          <h4 style="font-weight: bold;">{{$spl->XVSplName}}</h4>
          <h6 style="font-weight: bold;">รหัส : {{$spl->XVSplCode}}</h6>
        </div>
        <div class="col-6 text-right">
          <a href="{{route('supplier')}}" class="btn btn-success"><i class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
        </div>
      </div>
      <hr>
      <div class="row">
        <div class="col-6" style="font-size: 14px;font-weight:medium">
          <div class="d-flex mt-3">
            <div>ที่อยู่</div>
            <div class="ml-2 mr-2">:</div>
            <div>{{$spl->XVSplAddress}}</div>
          </div>
          <div class="d-flex mt-2">
            <div>ผู้ติดต่อ</div>
            <div class="ml-2 mr-2">:</div>
            <div>{{$spl->xvsqlcontactname}}</div>
          </div>
          <div class="d-flex mt-2">
            <div>โทรศัพท์</div>
            <div class="ml-2 mr-2">:</div>
            <div>{{$spl->XVSplPhone}}</div>
          </div>
            <div class="d-flex mt-2">
                <div>Fax</div>
                <div class="ml-2 mr-2">:</div>
                <div>{{$spl->XVSplFax}}</div>
            </div>
          <div class="d-flex mt-2">
            <div>อีเมล</div>
            <div class="ml-2 mr-2">:</div>
            <div>{{$spl->XVSplEmail}}</div>
          </div>
        </div>
      </div>
      <hr>
      <div class="row mt-5">
        <div class="col">
          <div class="d-flex">
            <div>
              <h5 style="font-weight: bold;">สินค้าที่จำหน่าย</h5>
            </div>
          </div>
          <div class="d-flex">
            <div class="table-responsive">
              <table class="table table-striped mt-5" id="tb_mat">
                <thead class="thead-light">
                  <tr>
                    <td class="text-center" width="5%">ที่</td>
                    <td width="10%">รหัส</td>
                    <td width="10%">ประเภท</td>
                    <td>กลุ่ม</td>
                    <td>ชื่อ</td>
                    <td>รายละเอียด</td>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($mats as $key => $mat)
                  <tr>
                    <td class="text-center">{{$key += 1}}</td>
                    <td>{{$mat->xvmatcode}}</td>
                    <td>{{$mat->xvmtyname}}</td>
                    <td>{{$mat->xvmgpname}}</td>
                    <td>{{$mat->xvmatname}}</td>
                    <td>{{$mat->xvmatdes}}</td>
                  </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection
<style>
  #tb_mat thead{
    font-weight: bold;
  }
  #tb_mat tbody{
    font-size: 14px;
  }
  #tb_mat tbody tr:hover{
    background-color:azure;
  }
  #tb_mat tbody td{
    height: 35px;
    vertical-align: middle;
    cursor: pointer;
  }
  #tb_mat_filter{
    margin-bottom: 1cm;
    margin-top: 0.3cm;
  }
</style>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script>
  $(document).ready(function(){
    $('#tb_mat').DataTable();
  })
</script>
