<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\GennarateidController;
use App\Http\Requests\MassDestroyAccGroupRequest;
use App\Http\Requests\StoreAccGroupRequest;
use App\Http\Requests\UpdateaccgroupRequest;
use App\TMAccGroup;

use Illuminate\Support\Facades\Auth;

class AccGroupController extends Controller
{
    public function index()
    {

        abort_unless(\Gate::allows('accgroup_access'), 403);
        $resAll  = TMaccgroup::all();
        return view('admin.accgroup.index', compact('resAll'));
    }

    public function create()
    {

        abort_unless(\Gate::allows('accgroup_create'), 403);

        return view('admin.accgroup.create');
    }

    public function store(StoreAccGroupRequest  $request)
    {

        abort_unless(\Gate::allows('accgroup_create'), 403);

        $request->request->add(['XVWhoCreate' => Auth::user()->name]);
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $accgroup = TMaccgroup::create($request->all());

        return redirect()->route('admin.accgroup.index');
    }

    public function edit(TMaccgroup $accgroup)
    {

        abort_unless(\Gate::allows('accgroup_edit'), 403);
        return view('admin.accgroup.edit', compact('accgroup'));
    }

    public function update(UpdateaccgroupRequest $request, TMaccgroup $accgroup)
    {

        abort_unless(\Gate::allows('accgroup_edit'), 403);
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);

        $accgroup->update($request->all());

        return redirect()->route('admin.accgroup.index');
    }

    public function show(TMaccgroup $accgroup)
    {

        abort_unless(\Gate::allows('accgroup_show'), 403);

        return view('admin.accgroup.index', compact('accgroup'));
    }

    public function destroy(TMaccgroup $accgroup)
    {

        abort_unless(\Gate::allows('accgroup_delete'), 403);
        $accgroup->delete();

        return back();
    }

    public function massDestroy(MassDestroyaccgroupRequest $request)
    {

        abort_unless(\Gate::allows('accgroup_delete'), 403);

        //add request
        TMaccgroup::whereIn('XIaccgroupCode', request('ids'))->delete();

        return response(null, 204);
    }
}
