<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\TMtotalsew;
use Auth;
use PDF;
/**
 * Class DashboardController.
 */
class BleachingController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //  dd(Auth::user()->XIBranchCode);
        // $u1 = Auth::user()->XIBranchCode;
        // switch ($u1){
        //     case "31":
        //         dd("31");
        //         break;
        //     case "32":
        //         dd("32");
        //         break;
        //     default:
        //         dd("Other");
        // }

        return view('admin.bleaching.index');
    }


    public function create()
    {
        // dd('Qc New Create');
        // $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        return view('admin.bleaching.create');
    }

    public function edit($id)
    {
        // dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        return view('admin.bleaching.edit',['data' => $data]);
    }

    public function store(Request $request)
    {
        //dd($request);
        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');
        $u1 = Auth::user()->XIBranchCode;
        // dd($u1);
        switch ($u1){
            case "31":
                // dd("31");
                $u2="โรงฟอก (ร่วม)";
                $u1=31;
            break;
            case "32":
                // dd("32");
                $u2="โรงฟอก (เอริท)";
                $u1=32;
            break;
            default:
            // dd("Other");
                $u2="ไม่ระบุ";
                $u1=16;
        }
        // dd($u1);
        // dd($request);
        DB::beginTransaction();
        try {
                DB::table('torder_inout')->insert(
                    [
                        'XDIODate'          => $XDIODate,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XIIOSta'           => "3",
                        'XIIOinorout'       => "1",
                        'XVOinoutNote'      => $u2,
                        'XIIOinoutedit'     => $u1,
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }

            return redirect('admin/bleaching')->with('message','บันทึกสำเร็จ');


    }

    public function update(Request $request,$id){
        // dd($request);
        // $XIIOinoutedit = $request->XIIOinoutedit == 'true'? 0:1;
        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');

        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=',$id)
                ->update(
                    [
                        'XDIODate'          => $XDIODate,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XIIOinorout'       => "0",
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/bleaching')->with('message','บันทึกสำเร็จ');


    }


    public function getdata()
    {
        //dd("testvkG");
        // $sql="select * from torder_inout where (XIIOinorout='1') and (XIIOSta='5') order by XDIODate desc";

        $u1 = Auth::user()->XIBranchCode;
        switch ($u1){
            case "31":
                // dd("31");
                $sql="select * from torder_inout where (XIIOSta='3') and (XIIOinoutedit='31') order by XIIOID desc";
            break;
            case "32":
                // dd("32");
                $sql="select * from torder_inout where (XIIOSta='3') and (XIIOinoutedit='32') order by XIIOID desc";
            break;
            default:
                $sql="select * from torder_inout where XIIOSta='3' order by XIIOID desc";
            // dd("Other");
        }

        // $sql="select * from torder_inout where XIIOSta='3' order by XIIOID desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }


    public function report()
    {
        //dd("Report Fg");
        return view('admin.bleaching.report');
    }

    public function reportpdf(Request $request)
    {
        $u1 = Auth::user()->XIBranchCode;
        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');
        // dd($dateStart);

        switch ($u1){
            case "31":
                // dd("31");
                $sql="select * from torder_inout
                WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='3' and XIIOinoutedit='31'
                order by XDIODate";
            break;
            case "32":
                // dd("32");
                $sql="select * from torder_inout
                WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='3' and XIIOinoutedit='32'
                order by XDIODate";
            break;
            default:
            $sql="select * from torder_inout
            WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='3'
            order by XDIODate";
        // dd("Other");
        }


        $res_bc = \DB::select($sql);
        $pdf = PDF::loadView('admin.bleaching.reportpdf', ['res_bc'=>$res_bc]);

        return $pdf->stream();

    }

    public function dele($id)
    {
        // dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->delete();
        return view('admin.bleaching.index');
    }


}
