<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\GennarateidController;
use App\Http\Requests\MassDestroyBlenchRequest;
use App\Http\Requests\StoreBlenchRequest;
use App\Http\Requests\UpdateBlenchRequest;
use App\TMblench;

use Illuminate\Support\Facades\Auth;

class BlenchController extends Controller
{
    public function index()
    {

        abort_unless(\Gate::allows('blench_access'), 403);

        $blenchs = TMblench::all();

        return view('admin.blench.index', compact('blenchs'));
    }

    public function create()
    {
        abort_unless(\Gate::allows('blench_create'), 403);

        return view('admin.blench.create');
    }

    public function store(StoreBlenchRequest $request)
    {

        abort_unless(\Gate::allows('blench_create'), 403);

        $docid = GennarateidController::Gent5id("TMblench", "XIBlenchCode");

        //add request
        // $request->request->add(['XIBlenchCode' => $docid]);
        $request->request->add(['XVWhoCreate' => Auth::user()->name]);
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $blench = TMblench::create($request->all());

        return redirect()->route('admin.blench.index');
    }

    public function edit(TMblench $blench)
    {

        abort_unless(\Gate::allows('blench_edit'), 403);

        return view('admin.blench.edit', compact('blench'));
    }

    public function update(UpdateBlenchRequest $request, TMblench $blench)
    {

        abort_unless(\Gate::allows('blench_edit'), 403);

        //add request
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $blench->update($request->all());

        return redirect()->route('admin.blench.index');
    }

    public function show(TMblench $blench)
    {
        abort_unless(\Gate::allows('blench_show'), 403);

        return view('admin.blench.show', compact('blench'));
    }

    public function destroy(TMblench $blench)
    {
        abort_unless(\Gate::allows('blench_delete'), 403);
        $blench->delete();

        return back();
    }

    public function massDestroy(MassDestroyBlenchRequest $request)
    {
        abort_unless(\Gate::allows('blench_delete'), 403);

        //add request
        TMblench::whereIn('XIBlenchCode', request('ids'))->delete();

        return response(null, 204);
    }
}
