<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

/**
 * Class DashboardController.
 */
class CheckDeliveryController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.checkdelivery.index');
    }

    public function create()
    {
        return view('admin.checkdelivery.create');
    }

    public function edit()
    {
        return view('admin.checkdelivery.edit');
    }

    public function update(Request $request, $XVCarCode)
    {
        $status = 1;
        \DB::table('torder_bc')
            ->where('XVCarCode', $XVCarCode)
            ->whereRaw("CAST(XDDateInSend as date)  = '" . $request->XDDateInSend . "'")
            ->update(
                [
                    'XCStatusSend' => '1',
                    'XVOrderBLocation' => '11',
                    'XVWhoEdit' => \Auth::user()->name,
                    'XTWhenEdit' => date("Y-m-d H:i:s"),
                ]
            );



        return view('admin.checkdelivery.index');
    }

    public function getData(Request $request)
    {

        $sql = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_bc.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
            ->selectRaw("CAST(XDDateInSend as date) as XDDateInSend,XVCarCode,
                        CASE When XCStatusSend = 1 THEN 'จัดส่งเรียบร้อย'
                        ELSE 'อยู่ระหว่างการจัดส่ง'
                        END as XCStatusSend
                        ,COUNT(*) XICountAll ")
            ->where('XVOrderBLocation', $request->location)
            ->groupBy(\DB::raw('XVCarCode,CAST(XDDateInSend as date)'));

        // dd($sql);
        $totalData = $sql->get()->count();


        $totalFiltered = $totalData;

        $limit = $request->input('length');
        $start = $request->input('start');


        if (empty($request->input('search.value'))) {
            $datas = $sql->offset($start)
                ->limit($limit)
                ->orderByDesc(\DB::raw('CAST(XDDateInSend as date)'))
                ->get();
        } else {
            $search = $request->input('search.value');

            $datas =  $sql->whereRaw('(XVCarCode LIKE "%' . $search . '%"
                                        OR XVBoxCode LIKE "%' . $search . '%"
                                        OR CAST(XDDateInSend as date) LIKE "%' . $search . '%"
                                        )
                                    ')
                ->offset($start)
                ->limit($limit)
                ->orderByDesc(\DB::raw('CAST(XDDateInSend as date)'))
                ->get();

            $totalFiltered = $sql->whereRaw('(XVCarCode LIKE "%' . $search . '%"
                                        OR XVBoxCode LIKE "%' . $search . '%"
                                        OR CAST(XDDateInSend as date) LIKE "%' . $search . '%"
                                        )
                                    ')
                ->count();
        }


        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $datas
        );

        // dd($json_data);


        echo json_encode($json_data);
    }

    public function getDataDetail($carCode, $DateInSend)
    {


        $res_bc = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_bc.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
            ->selectRaw("torder_hd.XVOrderDocNo,XVOrderBSize,XVBoxCode, XVOrderMItemNo,XVOrderBCode")
            ->where('XVCarCode', $carCode)
            ->whereRaw("CAST(XDDateInSend as date) = '" . $DateInSend . "'")
            ->orderBy('XVBoxCode', 'asc')
            ->orderBy('XVOrderBCode', 'asc')
            ->get()
            ->toArray();

        $datas = [
            'XVCarCode' => $carCode,
            'XDDateInSend' => $DateInSend,
            'res_bc' => $res_bc
        ];

        return view('admin.checkdelivery.create', compact('datas'));
    }


    ## Report
    public function getDataReport(Request $request)
    {

        $res = DB::table('torder_bc')
            ->join('torder_hd', 'torder_bc.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
            ->selectRaw("CAST(XDDateInSend as date) as XDDateInSend,XVCarCode,
                        CASE When XCStatusSend = 1 THEN 'จัดส่งเรียบร้อย'
                        ELSE 'อยู่ระหว่างการจัดส่ง'
                        END as XCStatusSend
                        ,COUNT(*) XICountAll ")
            ->where('XVOrderBLocation', '11')
            ->groupBy(DB::raw('XVCarCode,CAST(XDDateInSend as date)'))
            ->get();

        // dd($res);


        return view('admin.checkdelivery.report', ['datas' => $res]);
    }

    public function getDataReportDetail($carCode, $DateInSend)
    {


        $res_bc = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_bc.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
            ->selectRaw("torder_hd.XVOrderDocNo,XVOrderBSize,XVBoxCode, XVOrderMItemNo,XVOrderBCode")
            ->where('XVCarCode', $carCode)
            ->whereRaw("CAST(XDDateInSend as date) = '" . $DateInSend . "'")
            ->orderBy('XVBoxCode', 'asc')
            ->orderBy('XVOrderBCode', 'asc')
            ->get()
            ->toArray();

        $datas = [
            'XVCarCode' => $carCode,
            'XDDateInSend' => $DateInSend,
            'res_bc' => $res_bc
        ];

        return view('admin.checkdelivery.reportDetail', compact('datas'));
    }
}
