<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\View\View;

/**
 * Class DashboardController.
 */
class CheckorderController extends Controller
{
    /**
     * @return View
     */
    public function index()
    {
        return view('admin.checkorder.index');
    }

    public function create()
    {
        return view('admin.checkorder.create');
    }

    public function edit($docno, $sizecode)
    {

        $res = DB::table('torder_hd as a')
            ->selectRaw("XDOrderDateApprove, a.XVOrderDocNo,XVOrderMItemNo,XVOrderDSize,XVOrderBCode,
                                    CASE
                                        WHEN XVOrderBLocation ='1' THEN 'Order Approve'
                                        WHEN XVOrderBLocation ='2' THEN 'โรงเย็บ'
                                        WHEN XVOrderBLocation ='3' THEN 'โรงฟอก'
                                        WHEN XVOrderBLocation ='4' THEN 'ตัดด้ายตอกกระดุม'
                                        WHEN XVOrderBLocation ='5' THEN 'FG'
                                        WHEN XVOrderBLocation ='6' THEN 'QC (OH)'
                                        WHEN XVOrderBLocation ='13' THEN 'Packing (OH)'
                                        WHEN XVOrderBLocation ='7' THEN 'ซ่อม'
                                        WHEN XVOrderBLocation ='8' THEN 'Eject Stock'
                                        WHEN XVOrderBLocation ='9' THEN 'ลงกล่อง'
                                        WHEN XVOrderBLocation ='10' THEN 'จัดส่ง'
                                        WHEN XVOrderBLocation ='11' THEN 'ส่งแล้ว'
                                        WHEN XVOrderBLocation ='12' THEN 'รับเข้า RTV'
                                        ELSE '-'
                                    END as XVLocationName")
            ->join('torder_dt as b', 'a.XVOrderDocNo', 'b.XVOrderDocNo')
            ->Join('torder_bc AS c', function ($join) {
                $join->on('b.XVOrderDocNo', '=', 'c.XVOrderDocNo')
                    ->on('b.XVOrderDSize', '=', 'c.XVOrderBSize');
            })
            ->where('a.XVOrderDocNo', $docno)
            ->where('b.XVOrderDSize', $sizecode)
            ->get()
            ->toArray();

        // dd($res);

        return view('admin.checkorder.edit', ['datas' => $res]);
    }

    public function getData(Request $request)
    {


        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = DB::table('torder_hd as a')
            ->selectRaw(" a.XVOrderDocNo,a.XVOrderDetail,XVOrderDSize,XIOrderDTotalNum,XVOrderIn,
                                    sum(CASE
                                        WHEN XVOrderBLocation ='3' THEN 1
                                        ELSE 0
                                    END) as BlenchQty,
                                    sum(CASE
                                        WHEN XVOrderBLocation ='5' THEN 1
                                        ELSE 0
                                    END) as FGQty
                                    ,
                                    sum(CASE
                                        WHEN XVOrderBLocation ='8' THEN 1
                                        ELSE 0
                                    END) as RepairQty
                                    ,
                                    sum(CASE
                                        WHEN XVOrderBLocation ='13' OR XVOrderBLocation ='6' THEN 1
                                        ELSE 0
                                    END)as OHQty
                                    ,
                                    sum(CASE
                                        WHEN XVOrderBLocation ='9' THEN 1
                                        ELSE 0
                                    END) as BoxQty
                                    ,
                                    sum(CASE
                                        WHEN XVOrderBLocation ='3' OR XVOrderBLocation ='5' OR XVOrderBLocation ='8' OR XVOrderBLocation ='13' OR XVOrderBLocation ='6' OR XVOrderBLocation ='9' THEN 1
                                        ELSE 0
                                    END) as TotalQty")
            ->join('torder_dt as b', 'a.XVOrderDocNo', 'b.XVOrderDocNo')
            ->Join('torder_bc AS c', function ($join) {
                $join->on('b.XVOrderDocNo', '=', 'c.XVOrderDocNo')
                    ->on('b.XVOrderDSize', '=', 'c.XVOrderBSize');
            })
            ->groupBy('a.XVOrderDocNo', 'XVOrderDSize');

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        $data = $sql->limit($start, $length)->get();
        // dd($data);

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function product()
    {
        return view('admin.checkproduct.index');
    }

    public function getDataProduct(Request $request)
    {

        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $date = Carbon::now();
        if (strlen($date->month) == 1) {
            $month = "0" . $date->month;
        } else {
            $month = $date->month;
        }
        $sql = DB::select("SELECT torder_box.XVOrderIn,XVItemNo,XVSize,XDDateInDelivery,SUM(XIOrderQty) as XIOrderQty,QtyOnHand
                            FROM torder_box
                            LEFT JOIN(
                                 SELECT XVOrderIn,XVOrderMItemNo,XVOrderBSize,count(b.XVOrderDocNo) AS QtyOnHand
                                 FROM torder_hd a
                                 INNER JOIN torder_bc b ON a.XVOrderDocNo = b.XVOrderDocNo
                                 WHERE 1=1
                                 AND  b.XVOrderBLocation IN (5,6,13)
                                 GROUP BY XVOrderIn,XVOrderMItemNo,XVOrderBSize
                                ) onHand ON torder_box.XVOrderIn = onHand.XVOrderIn
                                AND torder_box.XVItemNo = onHand.XVOrderMItemNo
                                AND torder_box.XVSize = onHand.XVOrderBSize
                            WHERE EXTRACT(YEAR_MONTH FROM XDDateInDelivery) ='$date->year$month'
                            GROUP BY torder_box.XVOrderIn,XVItemNo,XVSize,XDDateInDelivery
                            ");
    //     //ห้ามลบคอมเม้น
    //    $arr = [6,13];
    //    $subq = DB::table('torder_hd')
    //        ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
    //        ->whereRaw('1=1')
    //        ->whereRaw("torder_bc.XVOrderBLocation in (6,13) " )
    //        ->groupBy('torder_hd.XVOrderIn', 'torder_hd.XVOrderMItemNo', 'torder_bc.XVOrderBSize')
    //        ->select('torder_hd.XVOrderIn', 'torder_hd.XVOrderMItemNo', 'torder_bc.XVOrderBSize', DB::raw('count(torder_bc.XVOrderDocNo) AS QtyOnHand'))
    //        ->toSql();

    //    $sql2 = DB::table('torder_box')
    //        ->leftjoin(DB::raw('('.$subq.') as onHand'),function ($join){
    //            $join->on('torder_box.XVOrderIn', '=', 'onHand.XVOrderIn');
    //        })
    //                ->whereRaw('torder_box.XVItemNo = onHand.XVOrderMItemNo')
    //                ->whereRaw('torder_box.XVSize = onHand.XVOrderBSize')
    //                ->whereRaw("EXTRACT(YEAR_MONTH FROM XDDateInDelivery) = '$date->year$month'")
    //                ->groupby('torder_box.XVOrderIn','XVItemNo','XVSize','XDDateInDelivery')
    //                ->select('torder_box.XVOrderIn','XVItemNo','XVSize','XDDateInDelivery',DB::raw('SUM(XIOrderQty) as XIOrderQty'),'QtyOnHand')
    //                ->get();

//        $sql2DB=DB::table('torder_box')
//            ->leftjoin('torder_hd', function ($join) {
//                $join->on('torder_box.XVOrderIn', '=', 'torder_hd.XVOrderIn')
//                    ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
//                    ->where('1', '=', '1')
//                    ->whereIn('torder_bc.XVOrderBLocation', [6, 13])
//                    ->groupBy('XVOrderIn', 'XVOrderMItemNo', 'XVOrderBSize')
//                    ->select('XVOrderIn', 'XVOrderMItemNo', 'XVOrderBSize', DB::raw('count(b.XVOrderDocNo) AS QtyOnHand'));
//            })
//            ->whereRaw('onHand ON torder_box.XVOrderIn = onHand.XVOrderIn')
//            ->whereRaw('torder_box.XVItemNo = onHand.XVOrderMItemNo')
//            ->whereRaw('torder_box.XVSize = onHand.XVOrderBSize')
//            ->whereRaw("EXTRACT(YEAR_MONTH FROM XDDateInDelivery) = '$date->year$month'")
//            ->groupby('torder_box.XVOrderIn','XVItemNo','XVSize','XDDateInDelivery')
//            ->select('torder_box.XVOrderIn','XVItemNo','XVSize','XDDateInDelivery',DB::raw('SUM(XIOrderQty) as XIOrderQty'),'QtyOnHand')->toSql();
//
        $sql = collect($sql);
//$date->year.$month
        $AllData = $sql->count();
        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
//        $data = $sql->slice($start, $length);
    //    dd($sql,$subq,$sql2);

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $sql,
        );
        //dd($request,$AllData);

        print  json_encode($data);
    }
}
