<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\GennarateidController;
use App\Http\Requests\MassDestroyCustomerRequest;
use App\Http\Requests\StoreCustomerRequest;
use App\Http\Requests\UpdateCustomerRequest;
use App\tmcustomer;

use Illuminate\Support\Facades\Auth;

class CustomerController extends Controller
{
    public function index()
    {

        abort_unless(\Gate::allows('customer_access'), 403);

        $customer = tmcustomer::all();

        return view('admin.customer.index', compact('customer'));
    }

    public function create()
    {
        abort_unless(\Gate::allows('customer_create'), 403);

        return view('admin.customer.create');
    }

    public function store(StoreCustomerRequest $request)
    {

        abort_unless(\Gate::allows('customer_create'), 403);

        $docid = GennarateidController::Gent5id("TMcustomer", "XIGuestCode");

        //add request
        $request->request->add(['XIGuestCode' => $docid]);
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $request->request->add(['XVWhoCreate' => Auth::user()->name]);
        $Customer = TMcustomer::create($request->all());

        return redirect()->route('admin.customer.index');
    }

    public function edit(TMcustomer $Customer)
    {

        abort_unless(\Gate::allows('customer_edit'), 403);

        return view('admin.customer.edit', compact('Customer'));
    }

    public function update(UpdateCustomerRequest $request, TMcustomer $Customer)
    {

        abort_unless(\Gate::allows('customer_edit'), 403);

        //add request
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $Customer->update($request->all());

        return redirect()->route('admin.customer.index');
    }

    public function show(TMcustomer $Customer)
    {
        abort_unless(\Gate::allows('customer_show'), 403);

        return view('admin.Customer.show', compact('Customer'));
    }

    public function destroy(TMcustomer $Customer)
    {
        abort_unless(\Gate::allows('customer_delete'), 403);

        $Customer->update(['XVWhoEdit' => Auth::user()->name]);
        $Customer->delete();

        return back();
    }

    public function massDestroy(MassDestroyCustomerRequest $request)
    {
        abort_unless(\Gate::allows('customer_delete'), 403);

        //add request
        TMcustomer::whereIn('XIGuestCode', request('ids'))->update(['XVWhoEdit' => Auth::user()->name]);
        TMcustomer::whereIn('XIGuestCode', request('ids'))->delete();
        return response(null, 204);
    }
}
