<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\TMtotalsew;
use App\tmgenerate;
use App\tmcustomer;
use App\Tdocprexp;
use App\Torder_hd;
use App\Torder_dt;
use App\Torder_bc;
use App\TMblench;
use App\tmforuse;
use App\TMshape;
use App\TMsew;
use App\tmordertable; //ตาลเพิ่ม
use Auth;
use PDF;
/**
 * Class DashboardController.
 */
class CutclothController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        // dd('cutcloth');
        return view('admin.cutcloth.index');
    }

    public function inputcut()
    {
        // dd("inQQQ");
        return view('admin.cutcloth.index2');
    }


    public function create($id,$item1,$si)
    {
        // dd($id,$item1,$si);
        abort_unless(\Gate::allows('order_create'), 403);
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $ordertable   = tmordertable::all();   //ตาลเพิ่ม
        $sizes = \DB::table('tmsize')->get();
        $season = \DB::table('tmseason')->get();
        $ordertype = \DB::table('tmordertype')->get();

        // $data = DB::table('torder_hd')->where('XVOrderDocNo','=',$id)->first();
        $sql="SELECT
                a.XVOrderDocNo,
                a.XIStVkID,
                a.XVOrderIn,
                a.XVStVkSKUin,
                a.XVStVkColor,
                a.XISeasonCode,
                a.XVStVkYear,
                a.XIForCode,
                a.XIGenerateCode,
                a.XIShapeCode,
                a.XIGuestCode,
                a.XFStVkCost,
                a.XFStVkPrice,
                a.XFStVkDisc,
                a.XVOrderMItemNo,
                a.XVOrderDocNo2,
                a.XIOrderTCode,
                a.XDOrderDocMDate,
                a.XDOrderOut,
                a.XIUser_id,
                a.XVOrderMSeasion,
                a.XVOrderDetail,
                a.XISewCode,
                a.XITotalSewCode,
                a.XIAddBlenchCode,
                a.XDOrderBPrince,
                a.XIOrderTableCode,
                a.XCStatus,
                b.XVOrderDocNo,
                b.XVOrderDSize,
                b.XIOrderDTotalNum
                FROM
                torder_hd AS a
                INNER JOIN torder_dt AS b ON a.XVOrderDocNo = b.XVOrderDocNo
                WHERE
                (a.XVOrderDocNo = '$id')and(a.XVOrderIn = '$item1') and (b.XVOrderDSize = '$si')";
        // dd($sql);

        $data = \DB::select($sql);
        // dd($data);

        $order = [
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes,
            'season'       => $season,
            'ordertype'    => $ordertype,
            'ordertable'   => $ordertable    //ตาลเพิ่ม
        ];

        // dd($data);
        return view('admin.cutcloth.create',
            ['data' => $data],
            ['order'=>$order]);
    }

    public function findsku(Request $request)
    {
        $sql="select * from torder_stockvk where XVStVkSKUin='$request->id'";
        $result = \DB::select($sql);
//        dd($result);
        return response()->json($result);
    }

    public function showd($a,$b,$c)
    {
        // dd($a,$b,$c);
        $sql="select * from torder_inout where ((XVOrderDocNo2='$a') and (XIOrderTableCode='$b') and (XVOrderIn='$c') and (XIIOSta='33'))";
        $data = \DB::select($sql);
        $rec = count($data);
        // dd($count);
        return view('admin.cutcloth.showdetail',
            ['data' => $data],
            ['rec' => $rec]
        );
    }


    public function edit($id)
    {
        // dd($id);
        // $sql="select * from torder_inout where XIIOID='$id'";
        // $data = \DB::select($sql);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        // dd($data);
        return view('admin.cutcloth.edit',
            ['data' => $data]
        );
    }

    public function store(Request $request)
    {
        // dd($request);
        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');

        DB::beginTransaction();
        try {
                DB::table('torder_inout')->insert(
                    [
                        'XDIODate'          => $XDIODate,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XIOrderTableCode'  => $request->XIOrderTableCode,
                        'XVOinoutNote'      => $request->XVOinoutNote,
                        'XVOrderDocNo'      => $request->XVOrderDocNo,
                        'XVOrderDocNo2'     => $request->XVOrderDocNo2,
                        'XIIOSta'           => "33",
                        'XIIOinorout'       => "1",
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }

            return redirect('admin/cutcloth')->with('message','บันทึกสำเร็จ');


    }

    public function update(Request $request,$id){
        // dd($request);
        // $XIIOinoutedit = $request->XIIOinoutedit == 'true'? 0:1;
        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');

        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=',$id)
                ->update(
                    [
                        'XDIODate'          => $XDIODate,
                        'XIOrderTableCode'  => $request->XIOrderTableCode,
                        'XVOinoutNote'      => $request->XVOinoutNote,
                        'XIIONum'           => $request->XIIONum,
                        'XIIOinorout'       => "1",
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/cutcloth')->with('message','บันทึกสำเร็จ');


    }


    public function getdata()
    {
        //dd("testvkG");
        // $sql="select * from torder_inout where XIIOSta='33' order by XIIOID desc";
        $sql="SELECT
        torder_inout.XIIOID,
        torder_inout.XVOrderDocNo2,
        torder_inout.XVOrderIn,
        torder_inout.XIOrderTableCode as TableCut,
        torder_inout.XVOinoutNote,
        Sum(CASE WHEN torder_inout.XVStVkSize='27' THEN torder_inout.XIIONum ELSE 0 END) AS 's27',
        Sum(CASE WHEN torder_inout.XVStVkSize='28' THEN torder_inout.XIIONum ELSE 0 END) AS 's28',
        Sum(CASE WHEN torder_inout.XVStVkSize='29' THEN torder_inout.XIIONum ELSE 0 END) AS 's29',
        Sum(CASE WHEN torder_inout.XVStVkSize='30' THEN torder_inout.XIIONum ELSE 0 END) AS 's30',
        Sum(CASE WHEN torder_inout.XVStVkSize='32' THEN torder_inout.XIIONum ELSE 0 END) AS 's32',
        Sum(CASE WHEN torder_inout.XVStVkSize='34' THEN torder_inout.XIIONum ELSE 0 END) AS 's34',
        Sum(CASE WHEN torder_inout.XVStVkSize='36' THEN torder_inout.XIIONum ELSE 0 END) AS 's36',
        Sum(CASE WHEN torder_inout.XVStVkSize='38' THEN torder_inout.XIIONum ELSE 0 END) AS 's38',
        Sum(CASE WHEN torder_inout.XVStVkSize='S' THEN torder_inout.XIIONum ELSE 0 END) AS 'ss',
        Sum(CASE WHEN torder_inout.XVStVkSize='M' THEN torder_inout.XIIONum ELSE 0 END) AS 'sm',
        Sum(CASE WHEN torder_inout.XVStVkSize='L' THEN torder_inout.XIIONum ELSE 0 END) AS 'sl',
        Sum(CASE WHEN torder_inout.XVStVkSize='XL' THEN torder_inout.XIIONum ELSE 0 END) AS 'sxl',
        Sum(CASE WHEN torder_inout.XVStVkSize='27' || torder_inout.XVStVkSize='28' || torder_inout.XVStVkSize='29' || torder_inout.XVStVkSize='30' || torder_inout.XVStVkSize='32' || torder_inout.XVStVkSize='34' || torder_inout.XVStVkSize='36' || torder_inout.XVStVkSize='38' || torder_inout.XVStVkSize='S' || torder_inout.XVStVkSize='M' || torder_inout.XVStVkSize='L' || torder_inout.XVStVkSize='XL' THEN torder_inout.XIIONum ELSE 0 END) AS 'stotal'
        FROM
        torder_inout
        WHERE
        torder_inout.XIIOSta='33'
        GROUP BY
        torder_inout.XVOrderDocNo2,torder_inout.XVOrderIn,torder_inout.XIOrderTableCode
        ";


        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

    public function getdata2()
    {
        $sql="SELECT
        a.XVOrderDocNo,
        a.XVOrderDocNo2,
        a.XDOrderDocMDate,
        a.XVOrderMItemNo,
        a.XVOrderIn,
        a.XDOrderOut,
        b.XVOrderDSize,
        b.XIOrderDTotalNum
        FROM
        torder_hd AS a
        LEFT JOIN torder_dt AS b ON a.XVOrderDocNo = b.XVOrderDocNo
        ORDER BY
        a.XVOrderDocNo DESC";

        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

    public function report()
    {
        //dd("Report Fg");
        return view('admin.cutcloth.report');
    }

    public function reportpdf(Request $request)
    {
        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');
        // dd($dateStart);
        $sql="select * from torder_inout
                WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='33'
                order by XDIODate";

                $res_bc = \DB::select($sql);

                $pdf = PDF::loadView('admin.cutcloth.reportpdf', ['res_bc'=>$res_bc]);

                return $pdf->stream();

    }

    public function dele($id)
    {
        // dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->delete();
        return view('admin.cutcloth.index');
    }


}
