<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

/**
 * Class DashboardController.
 */
class DashboardController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $XDDateInBlench = DB::select('SELECT
                                            Sum(torder_inout.XIIONum) as num
                                            FROM
                                            torder_inout
                                            WHERE
                                            torder_inout.XIIOSta = "88" AND YEAR(XDIODate)=YEAR(now()) AND MONTH(XDIODate)=MONTH(now())');
        $XDDateInThread = DB::select('SELECT
                                            Count(torder_bc.XVOrderBCode) as num
                                            FROM
                                            torder_bc
                                            WHERE
                                            torder_bc.XVOrderBLocation = 4');
        $XDDateInStockFG = DB::select('SELECT
                                            Sum(torder_inout.XIIONum) as num
                                            FROM
                                            torder_inout
                                            WHERE
                                            torder_inout.XIIOSta = "5" AND YEAR(XDIODate)=YEAR(now()) AND MONTH(XDIODate)=MONTH(now())');
        $XDDateInQC = DB::select('SELECT
                                            Sum(torder_inout.XIIONum) as num
                                            FROM
                                            torder_inout
                                            WHERE
                                            torder_inout.XIIOSta = "6" AND YEAR(XDIODate)=YEAR(now()) AND MONTH(XDIODate)=MONTH(now())');
        $XDDateInPack = DB::select('SELECT
                                            Sum(torder_inout.XIIONum) as num
                                            FROM
                                            torder_inout
                                            WHERE
                                            torder_inout.XIIOSta = "15" AND YEAR(XDIODate)=YEAR(now()) AND MONTH(XDIODate)=MONTH(now())');
        $XDDateInBox = DB::select('SELECT
                                            Sum(torder_inout.XIIONum) as num
                                            FROM
                                            torder_inout
                                            WHERE
                                            torder_inout.XIIOSta = "9" AND YEAR(XDIODate)=YEAR(now()) AND MONTH(XDIODate)=MONTH(now())');
        $XDDatePalit = DB::select('SELECT
                                            Sum(torder_inout.XIIONum) as num
                                            FROM
                                            torder_inout
                                            WHERE
                                            torder_inout.XIIOSta = "88" AND XDIODate=date(now())');
        $XDfg = DB::select('SELECT
                                            Sum(torder_inout.XIIONum) as num
                                            FROM
                                            torder_inout
                                            WHERE
                                            torder_inout.XIIOSta = "5" AND XDIODate=date(now())');
        $XDqc = DB::select('SELECT
                                            Sum(torder_inout.XIIONum) as num
                                            FROM
                                            torder_inout
                                            WHERE
                                            torder_inout.XIIOSta = "6" AND XDIODate=date(now())');
        $XDpk = DB::select('SELECT
                                            Sum(torder_inout.XIIONum) as num
                                            FROM
                                            torder_inout
                                            WHERE
                                            torder_inout.XIIOSta = "15" AND XDIODate=date(now())');
        $XDbox = DB::select('SELECT
                                            Sum(torder_inout.XIIONum) as num
                                            FROM
                                            torder_inout
                                            WHERE
                                            torder_inout.XIIOSta = "9" AND XDIODate=date(now())');

//        $sql = DB::select('Select t.XIOrderTCode, count(h.XIOrderTCode) as amount , t.XVOrderTName
//                            from tmordertype t
//                            left JOIN torder_hd h
//                            on t.XIOrderTCode = h.XIOrderTCode
//                            GROUP BY t.XIOrderTCode');

//        $graphData = DB::select('select CAST(XDDateInStockFG AS date) as date,count(XVOrderBCode) as num
//                                from torder_bc
//                                where XVOrderBLocation = 5
//                                GROUP BY CAST(XDDateInStockFG AS date)
//                                ORDER BY CAST(XDDateInStockFG AS date) DESC
//                                LIMIT 10;');

        $BGgraph = DB::table('torder_inout')
            ->whereRaw("XIIOSta='88' AND YEAR(XDIODate) = YEAR(now())")
            ->groupBy(DB::raw('MONTH(XDIODate)'))
            ->orderBy(DB::raw('MONTH(XDIODate)'),'asc')
            ->select(DB::raw('MONTH(XDIODate) as date'),DB::raw('sum(XIIONum) as num'))
            ->get();

        $FGgraph = DB::table('torder_inout')
            ->whereRaw("XIIOSta='5' AND YEAR(XDIODate) = YEAR(now())")
            ->groupBy(DB::raw('MONTH(XDIODate)'))
            ->orderBy(DB::raw('MONTH(XDIODate)'),'asc')
            ->select(DB::raw('MONTH(XDIODate) as date'),DB::raw('sum(XIIONum) as num'))
            ->get();

            $Packkigngraph = DB::table('torder_bc')
            ->where('XVOrderBLocation','=','13')
            ->groupBy(DB::raw('CAST(XDDateInPack AS date)'))
            ->orderBy(DB::raw('CAST(XDDateInPack AS date)'),'desc')
            ->limit('10')
            ->select(DB::raw('CAST(XDDateInPack AS date) as date'),DB::raw('count(XVOrderBCode) as num'))
            ->get();
        $allBox = DB::select('Select SUM(XIOrderQty) As num from torder_box');
        return view('admin.dashboard.index', [
//            'groupType' => $sql,
            'XDDateInBlench'=>$XDDateInBlench,
            'XDDateInThread'=>$XDDateInThread,
            'XDDateInStockFG'=>$XDDateInStockFG,
            'XDDateInQC'=>$XDDateInQC,
            'XDDateInPack'=>$XDDateInPack,
            'XDDateInBox'=>$XDDateInBox,
            'XDDatePalit'=>$XDDatePalit,
            'XDfg' => $XDfg,
            'XDqc' => $XDqc,
            'XDpk' => $XDpk,
            'XDbox' => $XDbox,
            'allBox'=>$allBox,
            'dataBG'=>$BGgraph,
            'dataFG'=>$FGgraph
        ]);
    }
}
