<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\GennarateidController;
use App\Http\Requests\MassDestroyFormRequest;
use App\Http\Requests\StoreFormRequest;
use App\Http\Requests\UpdateFormRequest;
use App\tmgenerate;

use Illuminate\Support\Facades\Auth;

class FormController extends Controller
{
    public function index()
    {

        abort_unless(\Gate::allows('form_access'), 403);

        $forms = tmgenerate::all();
        //dd($forms);

        return view('admin.form.index', compact('forms'));
    }

    public function create()
    {
        abort_unless(\Gate::allows('form_create'), 403);

        return view('admin.form.create');
    }

    public function store(StoreFormRequest $request)
    {

        abort_unless(\Gate::allows('form_create'), 403);

        // $docid = GennarateidController::Gent5id("tmgenerate", "XIGenerateCode");

        //add request
        // $request->request->add(['XIGenerateCode' => $docid]);
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $request->request->add(['XVWhoCreate' => Auth::user()->name]);
        $form = tmgenerate::create($request->all());

        return redirect()->route('admin.form.index');
    }

    public function edit(tmgenerate $form)
    {

        abort_unless(\Gate::allows('form_edit'), 403);

        return view('admin.form.edit', compact('form'));
    }

    public function update(UpdateFormRequest $request, tmgenerate $form)
    {

        abort_unless(\Gate::allows('form_edit'), 403);

        //add request
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $form->update($request->all());

        return redirect()->route('admin.form.index');
    }

    public function show(tmgenerate $form)
    {
        abort_unless(\Gate::allows('form_show'), 403);

        return view('admin.form.show', compact('form'));
    }

    public function destroy(tmgenerate $form)
    {
        abort_unless(\Gate::allows('form_delete'), 403);

        $form->update(['XVWhoEdit' => Auth::user()->name]);
        $form->delete();

        return back();
    }

    public function massDestroy(MassDestroyFormRequest $request)
    {
        abort_unless(\Gate::allows('form_delete'), 403);

        //add request
        tmgenerate::whereIn('XIGenerateCode', request('ids'))->update(['XVWhoEdit' => Auth::user()->name]);
        tmgenerate::whereIn('XIGenerateCode', request('ids'))->delete();

        return response(null, 204);
    }
}
