<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\DocpxController;
use Carbon\Carbon;
// use Auth;
use PDF;
use Illuminate\Support\Facades\Auth;

use App\TMtotalsew;
use App\tmgenerate;
use App\tmcustomer;
use App\Tdocprexp;
use App\Torder_hd;
use App\Torder_dt;
use App\Torder_bc;
use App\TMblench;
use App\tmforuse;
use App\TMshape;
use App\TMsew;
use App\tmordertable; //ตาลเพิ่ม

/**
 * Class DashboardController.
 */
class OrderController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //dd('datein');
        return view('admin.order.index');


    }

    public function create2($id)
    {
        // dd("Test");

        abort_unless(\Gate::allows('order_create'), 403);
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $ordertable   = tmordertable::all();   //ตาลเพิ่ม
        $sizes = \DB::table('tmsize')->get();
        $season = \DB::table('tmseason')->get();
        $ordertype = \DB::table('tmordertype')->get();

        $data = DB::table('torder_stockvk')->where('XIStVkID','=',$id)->first();
        // dd($data);
        $order = [
            'data'     => $data,
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes,
            'season'       => $season,
            'ordertype'    => $ordertype,
            'ordertable'   => $ordertable    //ตาลเพิ่ม
        ];

        //dd($data);
        return view('admin.order.create',
            ['data' => $data],
            ['order'=>$order]);

    }


    public function create()
    {
        // dd('Stock2 Create');
        return view('admin.order.index2');

    }

    public function edit($id)
    {
        // dd($id);
        abort_unless(\Gate::allows('order_create'), 403);
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $ordertable   = tmordertable::all();   //ตาลเพิ่ม
        $sizes = \DB::table('tmsize')->get();
        $season = \DB::table('tmseason')->get();
        $ordertype = \DB::table('tmordertype')->get();

        $data = DB::table('torder_hd')->where('XVOrderDocNo','=',$id)->first();
        // dd($data);
        $order = [
            'data'     => $data,
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes,
            'season'       => $season,
            'ordertype'    => $ordertype,
            'ordertable'   => $ordertable    //ตาลเพิ่ม
        ];

        //dd($data);
        return view('admin.order.edit',
            ['data' => $data],
            ['order'=>$order]);

    }

    public function update(Request $request){

        // dd($request);
        DB::beginTransaction();
        try {
                DB::table('torder_hd') ->where('XVOrderDocNo','=',$request->XVOrderDocNo)
                ->update(
                    [
                        'XISeasonCode'       => $request->XISeasonCode,
                        'XVStVkYear'         => $request->XVStVkYear,
                        'XVStVkSKUin'        => $request->XVStVkSKUin,
                        'XVStVkColor'        => $request->XVStVkColor,
                        'XIForCode'          => $request->XIForCode,
                        'XIGenerateCode'     => $request->XIGenerateCode,
                        'XIShapeCode'        => $request->XIShapeCode,
                        'XIGuestCode'        => $request->XIGuestCode,
                        'XIIONum'            => $request->XIIONum,
                        'XFStVkCost'         => $request->XFStVkCost,
                        'XFStVkPrice'        => $request->XFStVkPrice,
                        'XFStVkDisc'         => $request->XFStVkDisc,
                        'XVOrderMItemNo'     => $request->XVOrderMItemNo,
                        'XVOrderDocNo2'      => $request->XVOrderDocNo2,
                        'XDOrderDocMDate'    => Carbon::createFromFormat('d/m/Y', $request->XDOrderDocMDate)->format('Y-m-d'),
                        'XDOrderDateApprove' => Carbon::createFromFormat('d/m/Y', $request->XDOrderDocMDate)->format('Y-m-d'),
                        'XDOrderOut'         => Carbon::createFromFormat('d/m/Y', $request->XDOrderOut)->format('Y-m-d'),
                        'XVWhoEdit'          => Auth::user()->name,
                        'XTWhenEdit'         => DB::Raw('now()'),

                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }

            DB::beginTransaction();
            try {
                    DB::table('torder_dt') ->where('XVOrderDocNo','=',$request->XVOrderDocNo)
                    ->update(
                        [
                            'XIOrderDNum'       => $request->XIIONum,
                            'XIOrderDTotalNum'  => $request->XIIONum,
                            'XVWhoCreate'        => Auth::user()->name,
                            'XTWhenCreate'       => DB::Raw('now()'),
                        ]
                    );
                DB::commit();
                } catch (\Exception $e) {
                    DB::rollBack();
                    abort(500, 'Internal error');
                }

                // DB::beginTransaction();
                // try {
                //         DB::table('torder_inout') ->where('XVOrderDocNo','=',$request->XVOrderDocNo,'and','XIIOSta','=','88')
                //         ->update(
                //             [
                //                 'XIIONum'       => $request->XIIONum,
                //                 'XVOrderDocNo2'      => $request->XVOrderDocNo2,
                //                 'XVWhoCreate'        => Auth::user()->name,
                //                 'XTWhenCreate'       => DB::Raw('now()'),
                //             ]
                //         );
                //     DB::commit();
                //     } catch (\Exception $e) {
                //         DB::rollBack();
                //         abort(500, 'Internal error');
                //     }


            // return redirect('admin/stockvk')->with('message','บันทึกสำเร็จ');
            return redirect()->route('admin.order.index')->with('message','บันทึกสำเร็จ');


    }

    public function store(Request $request)
    {
        $Docid  = DocpxController::genid("torder_hd", 'XVOrderDocNo');
        // foreach ($request->XIOrderDNum as $Ordernum) {
        //     //$Ordernum5[] = ceil((($Ordernum * 5) / 100));
        //     //$Ordernum5Total[] = ceil((($Ordernum * 5) / 100)) + $Ordernum;
        //     // ตาลแก้
        //     $Ordernum5[] = 0;
        //     $Ordernum5Total[] = $Ordernum;
        // }

        // dd($request->all(),$Docid,count($request->XVOrderDSize));

        // dd($Docid);
        // Carbon::createFromFormat('d/m/Y', $request->XDOrderDocMDate)->format('Y-m-d')

        DB::beginTransaction();
        try {
                DB::table('torder_hd')->insert(
                    [
                        'XVOrderDocNo'       => $Docid,
                        'XIStVkID'           => $request->XIStVkID,
                        'XVOrderIn'          => $request->XVOrderIn,
                        'XIForCode'          => $request->XIForCode,
                        'XIGenerateCode'     => $request->XIGenerateCode,
                        'XIShapeCode'        => $request->XIShapeCode,
                        'XVStVkColor'        => $request->XVStVkColor,
                        'XFStVkCost'         => $request->XFStVkCost,
                        'XFStVkPrice'        => $request->XFStVkPrice,
                        'XFStVkDisc'         => $request->XFStVkDisc,
                        'XVOrderDocNo2'      => $request->XVOrderDocNo2,
                        'XIOrderTCode'       => $request->XIOrderTCode,
                        'XISeasonCode'       => $request->XISeasonCode,
                        'XVStVkYear'         => $request->XVStVkYear,
                        'XDOrderDocMDate'    => Carbon::createFromFormat('d/m/Y', $request->XDOrderDocMDate)->format('Y-m-d'),
                        'XDOrderDateApprove' => Carbon::createFromFormat('d/m/Y', $request->XDOrderDocMDate)->format('Y-m-d'),
                        'XDOrderOut'         => Carbon::createFromFormat('d/m/Y', $request->XDOrderOut)->format('Y-m-d'),
                        'XVOrderMItemNo'     => $request->XVOrderMItemNo,
                        'XIGuestCode'        => $request->XIGuestCode,
                        'XVWhoCreate'        => Auth::user()->name,
                        'XVWhoEdit'          => Auth::user()->name,
                        'XTWhenCreate'       => DB::Raw('now()'),
                        'XTWhenEdit'         => DB::Raw('now()'),
                        'XCStatus'           => "1",
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                // dd($e->getMessage(),'a');
                abort(500, 'Internal error');
            }

            for ($i = 0; $i < count($request->XVOrderDSize); $i++) {
                $OrderDT_insert = [
                    'XVOrderDocNo'      => $Docid,
                    'XVOrderDSize'      => $request->XVOrderDSize[$i],
                    'XIOrderDNum'       => $request->XIOrderDNum[$i],
                    'XIOrderDTotalNum'  =>  $request->XIOrderDNum[$i],
                    'XVWhoCreate'        => Auth::user()->name,
                ];
                $Order_dt = Torder_dt::create($OrderDT_insert);
            }


            // DB::beginTransaction();
            // try {
            //         DB::table('torder_dt')->insert(
            //             [
            //                 'XVOrderDocNo'       => $Docid,
            //                 'XVOrderDSize'      => $request->XVStVkSize,
            //                 'XIOrderDNum'       => $request->XIIONum,
            //                 'XIOrderDTotalNum'  => $request->XIIONum,
            //                 'XVWhoCreate'        => Auth::user()->name,
            //                 'XTWhenCreate'       => DB::Raw('now()'),
            //                 ]
            //         );
            //     DB::commit();
            //     } catch (\Exception $e) {
            //         DB::rollBack();
            //         // dd($e->getMessage(),'b');
            //         abort(500, 'Internal error');
            //     }
            for ($i = 0; $i < count($request->XVOrderDSize); $i++) {
                DB::beginTransaction();
                try {
                        DB::table('torder_inout')->insert(
                            [
                                'XVOrderDocNo'       => $Docid,
                                'XVOrderDocNo2'      => $request->XVOrderDocNo2,
                                'XDIODate'          => Carbon::createFromFormat('d/m/Y', $request->XDOrderDocMDate)->format('Y-m-d'),
                                'XVOrderIn'         => $request->XVOrderIn,
                                'XVStVkSize'        => $request->XVOrderDSize[$i],
                                // 'XVIOSKUin'         => $request->XVOrderIn + $request->XVOrderDSize[$i],
                                'XIIONum'           => $request->XIOrderDNum[$i],
                                'XIIOSta'           => "88",
                                'XTWhenCreate'      => DB::Raw('now()'),
                                'XTWhenEdit'        => DB::Raw('now()'),
                                'XVWhoCreate'       => Auth::user()->name,
                                'XVWhoEdit'         => Auth::user()->name,
                            ]
                        );
                    DB::commit();
                    } catch (\Exception $e) {
                        DB::rollBack();
                        // dd($e->getMessage(),'b');
                        abort(500, 'Internal error');
                    }
            }


            return redirect()->route('admin.order.index')->with('message','บันทึกสำเร็จ');

        //    return redirect('admin/order/index')->with('message','บันทึกสำเร็จ');
    }

    public function getdata()
    {
        //dd("testvk");
        // $sql="select * from torder_hd order by XVOrderDocNo desc";
        $sql="SELECT
        a.XVOrderDocNo,
        a.XVOrderDocNo2,
        a.XDOrderDocMDate,
        a.XVOrderMItemNo,
        a.XVOrderIn,
        a.XDOrderOut,
        b.XVOrderDSize,
        b.XIOrderDTotalNum
        FROM
        torder_hd AS a
        LEFT JOIN torder_dt AS b ON a.XVOrderDocNo = b.XVOrderDocNo
        ORDER BY
        a.XVOrderDocNo DESC";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }



    public function dele($id)
    {
        //($id);
        $data = DB::table('torder_hd')->where('XVOrderDocNo','=',$id)->delete();
        $data = DB::table('torder_dt')->where('XVOrderDocNo','=',$id)->delete();
        $data = DB::table('torder_inout')->where('XVOrderDocNo','=',$id,'and','XIIOSta','=','88')->delete();
        return view('admin.order.index');
    }

    // public function report2()
    // {
    //     dd("Report box");
    //     return view('admin.order.report');
    // }


    // public function reportpdf(Request $request)
    // {
    //     // dd($request);
    //     $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
    //     $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');
    //     // dd($dateStart);
    //     $sql="select * from torder_hd
    //             WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "'
    //             order by XVOrderMItemNo";

    //             $res_bc = \DB::select($sql);
    //     // dd($res_bc);

    //     $pdf = PDF::loadView('admin.order.reportpdf', ['res_bc'=>$res_bc]);

    //     return $pdf->stream();

    // }




}
