<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreOrderRequest;
use App\Http\Requests\UpdateOrderRequest;
use App\Http\Controllers\DocpxController;
use App\Http\Requests\MassDestroyOrderRequest;
use Illuminate\Http\Request;

use Session;
use App\Torder_ac;
use App\TMtotalsew;
use App\tmgenerate;
use App\tmcustomer;
use App\Tdocprexp;
use App\Torder_hd;
use App\Torder_dt;
use App\Torder_bc;
use App\TMblench;
use App\tmforuse;
use App\TMshape;
use App\TMsew;
use App\TMbranch;
use App\TAccEssories;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

/**
 * Class DashboardController.
 */
class PayEquipMentmController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.payequipmentm.index');
    }

    public function create()
    {
        return view('admin.payequipmentm.create');
    }

    public function edit()
    {
        return view('admin.payequipmentm.edit');


    private $keydoc = "10000";

    public function index()
    {
        abort_unless(\Gate::allows('order_access'), 403);
        $payequipmentm = Torder_hd::getoder_hd();

        return view('admin.payequipmentm.index', compact('payequipmentm'));
    } //เช็คสิทธิ

    public function create()
    {
        abort_unless(\Gate::allows('order_create'), 403);
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $sizes = \DB::table('tmsize')->get();


        $payequipmentm = [
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'         => $sizes
        ];

        return view('admin.payequipmentm.create', compact('payequipmentm'));
    }

    public function store(StoreOrderRequest $request)
    {

        abort_unless(\Gate::allows('order_create'), 403);

        // Crate Herder Order
        $Docid  = DocpxController::genid("10000");

        foreach ($request->XIOrderDNum as $Ordernum) {
            $Ordernum5[] = ceil((($Ordernum * 5) / 100));
            $Ordernum5Total[] = ceil((($Ordernum * 5) / 100)) + $Ordernum;
        }

        $OrderHD_insert = [
            'XVOrderDocNo'      => $Docid,
            'XVOrderMItemNo'    => $request->XVOrderMItemNo,
            'XIGuestCode'       => $request->XIGuestCode,
            'XIGenerateCode'    => $request->XIGenerateCode,
            'XISewCode'         => $request->XISewCode,
            'XIAddBlenchCode'   => $request->XIBlenchCode,
            'XIBranchCode'     => $request->XIBranchCode,
            'XDOrderDocMDate'   => Carbon::createFromFormat('d/m/Y', $request->XDOrderDocMDate)->format('Y-m-d'),
            'XVOrderMSeasion'   => $request->XVOrderMSeasion,
            'XIForCode'         => $request->XIForCode,
            'XIShapeCode'       => $request->XIShapeCode,
            'XITotalSewCode'    => $request->XITotalSewCode,
            'XVWhoCreate'       => Auth::user()->name,
            'XVWhoEdit'       => Auth::user()->name,
            'XCStatus'       => "1",
        ];

        $Order_hd = Torder_hd::create($OrderHD_insert);
        DocpxController::commit("10000", $Docid);

        // Crate Detail Order
        for ($i = 0; $i < count($request->XVOrderDSize); $i++) {
            $OrderDT_insert = [
                'XVOrderDocNo'      => $Docid,
                'XVOrderDSize'      => $request->XVOrderDSize[$i],
                'XIOrderDNum'       => $request->XIOrderDNum[$i],
                'XIOrderDNum5P'     => $Ordernum5[$i],
                'XIOrderDTotalNum'  => $Ordernum5Total[$i],
                'XVWhoCreate'       => $request->XVWhoCreate
            ];

            $Order_dt = Torder_dt::create($OrderDT_insert);
        }
        return redirect()->route('admin.payequipmentm.index');
    }

    public function show($id)
    {

        abort_unless(\Gate::allows('order_show'), 403);
    }

    public function edit($id)
    {

        abort_unless(\Gate::allows('order_edit'), 403);

        // $Prefix       = Tdocprexp::getpx($this->keydoc)[0]->Prefix;
        $sizes = \DB::table('tmsize')->get();
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $order_hd     = Torder_hd::getoder_hd()->where('XVOrderDocNo', '=', $id)->first();
        // $order_hd->XDOrderDocMDate = Carbon::createFromFormat('Y-m-d', $order_hd->XDOrderDocMDate)->format('d/m/Y');
        $order_dt     = Torder_dt::where('XVOrderDocNo', '=', $id)
            ->get();
        // dd($order_hd);

        $order = [
            'order_hd'     => $order_hd,
            'order_dt'    => $order_dt,
            'XVOrderDocNo' => $Docid,
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes
        ];

        return view('admin.payequipmentm.edit', compact('payequipmentm'));
    }


    public function update(Request $request, $Docid)

    {
        // $status['XCAccStatus'] = $request->XCAccStatus;
        $id['XVOrderDocNo'] = $Docid;
        $status['XCAccStatus'] = 2;

        // dd($id);
        if(Torder_ac::where('XVOrderDocNo',$id)->update($status)){
            Session::flash('message','success');
            Session::flash('alert-class','success');

        }else{
            Session::flash('message','error');
            Session::flash('alert-class','danger');
        }

        return redirect('admin/payequipmentm');
}

    public function destroy($id)
    {
        // dd(231);
        abort_unless(\Gate::allows('order_delete'), 403);

        Torder_hd::deleteorder_id($id);

        return back();
    }

    public function massDestroy(MassDestroyOrderRequest $request)
    {


        abort_unless(\Gate::allows('order_delete'), 403);



        Torder_hd::whereIn('XVOrderDocNo', request('ids'))->delete();

        return response(null, 204);
    }

    public function getApprove($DocNo,$bc)
    {
        abort_unless(\Gate::allows('order_approve'), 403);

        // $Prefix       = Tdocprexp::getpx($this->keydoc)[0]->Prefix;
        $sizes = \DB::table('tmsize')->get();
        $tacc = \DB::table('taccessories')->get();

        $branchacc = \DB::table('tmbranch')
        ->join('torder_ac', 'torder_ac.XIBranchCode', 'tmbranch.XIBranchCode')
        ->join('taccessories','taccessories.XVAccesCode','torder_ac.XVAccesCode')
        ->select('torder_ac.XCAccStatus','tmbranch.XVBranchName','tmbranch.XIBranchCode','torder_ac.XVAccesCode','taccessories.XVAccesName','taccessories.XVAccesDesc','taccessories.XIAccesNum','taccessories.XDPriceUnit')
        ->get();

       if($bc!=0){
            $branchaccTable = \DB::table('tmbranch')
            ->join('torder_ac', 'torder_ac.XIBranchCode', 'tmbranch.XIBranchCode')
            ->join('taccessories','taccessories.XVAccesCode','torder_ac.XVAccesCode')
            ->where('torder_ac.XIBranchCode', '=', $bc)
            ->select('tmbranch.XVBranchName','tmbranch.XIBranchCode','torder_ac.XVAccesCode','taccessories.XVAccesName','taccessories.XVAccesDesc','taccessories.XIAccesNum','taccessories.XDPriceUnit')
            ->get();
       }
       else
       {
            $branchaccTable = \DB::table('tmbranch')
            ->join('torder_ac', 'torder_ac.XIBranchCode', 'tmbranch.XIBranchCode')
            ->join('taccessories','taccessories.XVAccesCode','torder_ac.XVAccesCode')
            ->select('tmbranch.XVBranchName','tmbranch.XIBranchCode','torder_ac.XVAccesCode','taccessories.XVAccesName','taccessories.XVAccesDesc','taccessories.XIAccesNum','taccessories.XDPriceUnit')
            ->get();
       }



        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $branch      =  TMbranch::all();
        $accessories = TAccEssories::all();
        $order_hd     = Torder_hd::getoder_hd()->where('XVOrderDocNo', '=', $DocNo)->first();
        $order_hd->XDOrderDocMDate = Carbon::createFromFormat('Y-m-d', $order_hd->XDOrderDocMDate)->format('d/m/Y');
        $order_dt     = Torder_dt::where('XVOrderDocNo', '=', $DocNo)->get();

        // dd($branchacc );
        $payequipmentm = [
            'accessories' =>$accessories,
            'branch'       =>$branch,
            'order_hd'     => $order_hd,
            'order_dt'    => $order_dt,
            'XVOrderDocNo' => $DocNo,
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes,
            'tacc'         =>$tacc,
            'branchacc' => $branchacc,
            'branchaccTable' => $branchaccTable,
            'bc' => $bc


        ];
        //  dd($payequipmentm['branchacc']);

        return view('admin.payequipmentm.approve', compact('payequipmentm'));
    }

    public function order($bc){

        // $order = $request->input('order');
        $orders = $bc;
        $branchacc = \DB::table('tmbranch')
        ->join('torder_ac', 'torder_ac.XIBranchCode', 'tmbranch.XIBranchCode')
        ->join('taccessories','taccessories.XVAccesCode','torder_ac.XVAccesCode')
        ->where('torder_ac.XIBranchCode', '=', $orders)
        ->select('tmbranch.XVBranchName','tmbranch.XIBranchCode','torder_ac.XVAccesCode','taccessories.XVAccesName','taccessories.XVAccesDesc','taccessories.XIAccesNum','taccessories.XDPriceUnit')
        ->get()
        ->toArray();

        $res = [
            'branchacc' => $branchacc,
            // 'tmbranch.XVBranchName' => $branchacc->XVBranchName

        ];

        // $tmbranch =  $branchacc['tmbranch.XIBranchCode']->XIBranchCode;
        //dd($res['branchacc']);

        // public function deleteCharacter ($char_delete_id)
        // {
        //     if ($orders == $delCharacterUserID) {
        //         $deleteSuccess = 1;

        //     } else {
        //         $deleteSuccess = 0;
        //     }
        //     return redirect('/characters')->with('deleteSuccess', $deleteSuccess);
        // }

        // dd($orders);

        return $branchacc;

    }



}
