<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use App\TMtotalsew;
use App\tmgenerate;
use App\tmcustomer;
use App\Tdocprexp;
use App\Torder_hd;
use App\Torder_dt;
use App\Torder_img;
use App\TMblench;
use App\tmforuse;
use App\TMshape;
use App\TMsew;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

/**
 * Class DashboardController.
 */
class PicturedeFectiveController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {

        abort_unless(\Gate::allows('qc_access'), 403);
        $order = Torder_hd::getoder_hd();

        return view('admin.picturedefective.index', compact('order'));
    }

    public function create()
    {
        return view('admin.picturedefective.create');
    }

    public function edit($DocNo)
    {
        abort_unless(\Gate::allows('order_approve'), 403);

        // $Prefix       = Tdocprexp::getpx($this->keydoc)[0]->Prefix;
        $sizes = \DB::table('tmsize')->get();
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $order_hd     = Torder_hd::getoder_hd()->where('XVOrderDocNo', '=', $DocNo)->first();
        $order_hd->XDOrderDocMDate = Carbon::createFromFormat('Y-m-d', $order_hd->XDOrderDocMDate)->format('d/m/Y');
        $order_dt     = Torder_dt::where('XVOrderDocNo', '=', $DocNo)->get();
        $order_img     = Torder_img::where('XVOrderDocNo', '=', $DocNo)->get();

        $order = [
            'order_hd'     => $order_hd,
            'order_dt'    => $order_dt,
            'XVOrderDocNo' => $DocNo,
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes,
            'order_img' =>$order_img,
        ];

        return view('admin.picturedefective.edit', compact('order'));
    }

    public function update(request $request, $DocNo)
    {
        // dd('55');
        abort_unless(\Gate::allows('qc_access'), 403);

        request()->validate([
            'image' => 'required',
            'image.*' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048'
        ]);


        if ($image = $request->file('image')) {
            $row = Torder_img::where('XVOrderDocNo', '=', $DocNo)->max('XISeqNo');

            foreach ($image as $files) {
                $name_old = $files->getClientOriginalName();

                $destinationPath = 'image_order/'; // upload path
                $profileImage = date('YmdHis') . round(microtime(true) * 1000) . "." . $files->getClientOriginalExtension();
                $files->move($destinationPath, $profileImage);

                $insert[$row]['XVOrderDocNo'] = $DocNo;
                $insert[$row]['XISeqNo'] = $row + 1;
                $insert[$row]['XVImgNameOld'] = $name_old;
                $insert[$row]['XVImgName'] = $profileImage;
                $insert[$row]['XVWhoCreate'] = Auth::user()->name;
                $insert[$row]['XTWhenCreate'] = date('Y-m-d H:i:s');

                $row++;
            }
        }

        // Torder_img::where('XVOrderDocNo', $DocNo)->delete();
        $check = Torder_img::insert($insert);


        // $Prefix       = Tdocprexp::getpx($this->keydoc)[0]->Prefix;
        $sizes = \DB::table('tmsize')->get();
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $order_hd     = Torder_hd::getoder_hd()->where('XVOrderDocNo', '=', $DocNo)->first();
        $order_hd->XDOrderDocMDate = Carbon::createFromFormat('Y-m-d', $order_hd->XDOrderDocMDate)->format('d/m/Y');
        $order_dt     = Torder_dt::where('XVOrderDocNo', '=', $DocNo)->get();
        $order_img     = Torder_img::where('XVOrderDocNo', '=', $DocNo)->get();


        $order = [
            'order_hd'     => $order_hd,
            'order_dt'    => $order_dt,
            'XVOrderDocNo' => $DocNo,
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes,
            'order_img'    => $order_img,
        ];

        return view('admin.picturedefective.edit', compact('order'));
    }

    public function delete_file($SeqNo, $DocNo)
    {

        // dd('55');
        abort_unless(\Gate::allows('qc_access'), 403);

        Torder_img::where('XVOrderDocNo', $DocNo)
            ->where('XISeqNo', $SeqNo)->delete();

        $sizes = \DB::table('tmsize')->get();
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $order_hd     = Torder_hd::getoder_hd()->where('XVOrderDocNo', '=', $DocNo)->first();
        $order_hd->XDOrderDocMDate = Carbon::createFromFormat('Y-m-d', $order_hd->XDOrderDocMDate)->format('d/m/Y');
        $order_dt     = Torder_dt::where('XVOrderDocNo', '=', $DocNo)->get();
        $order_img     = Torder_img::where('XVOrderDocNo', '=', $DocNo)->get();


        $order = [
            'order_hd'     => $order_hd,
            'order_dt'    => $order_dt,
            'XVOrderDocNo' => $DocNo,
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes,
            'order_img'    => $order_img,
        ];

        return view('admin.picturedefective.edit', compact('order'));
    }
}
