<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\TMtotalsew;
use Auth;
use PDF;
/**
 * Class DashboardController.
 */
class PlanBookController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //dd('datein');
        return view('admin.planbook.index');


    }

    public function create()
    {
        //dd('FG New Create');
        return view('admin.planbook.create');
    }

    public function edit($id)
    {
        //dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        // dd($data);
        return view('admin.planbook.edit',['data' => $data]);
    }

    public function store(Request $request)
    {
        //dd($request);

        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');
        // $XIIOinoutedit = $request->XIIOinoutedit == 'true'? 0:1;
        // //dd($XIIOinoutedit);

        DB::beginTransaction();
        try {
                DB::table('torder_inout')->insert(
                    [
                        'XDIODate'          => $XDIODate,
                        'XIStVkID'          => $request->XIStVkID,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XVOrderMItemNo'    => $request->XVOrderMItemNo,
                        'XIIOSta'           => "16",
                        'XIIOinorout'       => "1",
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/planbook')->with('message','บันทึกสำเร็จ');

    }

    public function update(Request $request,$id){
        //dd($request);
        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');

        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=',$id)
                ->update(
                    [
                        'XDIODate'          => $XDIODate,
                        'XIStVkID'          => $request->XIStVkID,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XVOrderMItemNo'    => $request->XVOrderMItemNo,
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/planbook')->with('message','บันทึกสำเร็จ');


    }


    public function getdata()
    {
        //dd("testvkG");
        // $sql="select * from torder_inout where (XIIOinorout='1') and (XIIOSta='5') order by XDIODate desc";
        $sql="select * from torder_inout where XIIOSta='16' order by XIIOID desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );
        print json_encode($data);
    }

    public function balance()
    {
        //dd("bal");
        return view('admin.planbook.balance');
    }

    public function balance2()
    {
        //dd("bal");
        return view('admin.planbook.balance2');
    }

    public function getdata3()
    {
        $sql="SELECT
        torder_inout.XVOrderIn AS itemn,
        torder_inout.XVStVkSize AS size,
        torder_inout.XVIOSKUin AS sku,
        Sum(if(XIIOSta='88',XIIONum,0)) AS pl,
        Sum(if(XIIOSta='5',XIIONum,0)) AS fg,
        Sum(if(XIIOSta='6',XIIONum,0)) AS qc,
        Sum(if(XIIOSta='99',XIIONum,0)) AS oh,
        Sum(if(XIIOSta='15',XIIONum,0)) AS pk,
        (Sum(if(XIIOSta='99',XIIONum,0))+ Sum(if(XIIOSta='15',XIIONum,0))) as sum1,
        Sum(if(XIIOSta='9',XIIONum,0)) AS cut,
        Sum(if(XIIOSta='15',XIIONum,0))- Sum(if(XIIOSta='9',XIIONum,0))- Sum(if(XIIOSta='16',XIIONum,0)) as sum2,
        Sum(if(XIIOSta='16',XIIONum,0)) AS book,
        (((Sum(if(XIIOSta='99',XIIONum,0))+ Sum(if(XIIOSta='15',XIIONum,0)))- Sum(if(XIIOSta='9',XIIONum,0)))-Sum(if(XIIOSta='16',XIIONum,0))) as total
        FROM
        torder_inout
        GROUP BY
        torder_inout.XVIOSKUin
        ";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );
        print json_encode($data);
    }



    public function getdata2()
    {
        // Sum(if(XIIOSta='15',XIIONum,0))- Sum(if(XIIOSta='9',XIIONum,0))- Sum(if(XIIOSta='16',XIIONum,0)) as sum2,
        $sql="SELECT
        torder_inout.XVOrderIn AS itemn,
        torder_inout.XVStVkSize AS size,
        torder_inout.XVIOSKUin AS sku,
        Sum(if(XIIOSta='88',XIIONum,0)) AS pl,
        Sum(if(XIIOSta='33',XIIONum,0)) AS cut1,
        Sum(if(XIIOSta='5',XIIONum,0)) AS fg,
        Sum(if(XIIOSta='6',XIIONum,0)) AS qc,
        Sum(if(XIIOSta='99',XIIONum,0)) AS oh,
        Sum(if(XIIOSta='15',XIIONum,0)) AS pk,
        Sum(if(XIIOSta='8',XIIONum,0)) AS ej,
        Sum(if(XIIOSta='12',XIIONum,0)) AS re1,
        (Sum(if(XIIOSta='99',XIIONum,0))+ Sum(if(XIIOSta='15',XIIONum,0))) as sum1,
        Sum(if(XIIOSta='9',XIIONum,0)) AS box1,
        Sum(if(XIIOSta='15',XIIONum,0))- Sum(if(XIIOSta='9',XIIONum,0)) as sum2,
        Sum(if(XIIOSta='16',XIIONum,0)) AS book,
        (((Sum(if(XIIOSta='99',XIIONum,0))+ Sum(if(XIIOSta='15',XIIONum,0)))- Sum(if(XIIOSta='9',XIIONum,0)))-Sum(if(XIIOSta='16',XIIONum,0))) as total
        FROM
        torder_inout
        GROUP BY
        torder_inout.XVOrderIn,torder_inout.XVStVkSize
        order by XVOrderDocNo desc
        ";

        // $sql="SELECT
        //     a.XVOrderDocNo as OrderDocNo,
        //     a.XVOrderIn as OrderIn,
        //     a.XVStVkSize as VkSize,
        //     a.XVStVkSKUin as VkSKUin,
        //     a.XIIONum as IONum,
        //     b.XIOrderTableCode as TableCut,
        //     Sum(if(b.XIIOSta='33',b.XIIONum,0)) AS cut1,
        //     Sum(if(b.XIIOSta='2',b.XIIONum,0)) AS sew1,
        //     Sum(if(b.XIIOSta='3',b.XIIONum,0)) AS blench1,
        //     Sum(if(b.XIIOSta='4',b.XIIONum,0)) AS kradum1,
        //     Sum(if(b.XIIOSta='5',b.XIIONum,0)) AS fg,
        //     Sum(if(b.XIIOSta='6',b.XIIONum,0)) AS qc,
        //     Sum(if(b.XIIOSta='12',b.XIIONum,0)) AS re1,
        //     Sum(if(b.XIIOSta='8',b.XIIONum,0)) AS ej,
        //     Sum(if(b.XIIOSta='15',b.XIIONum,0)) AS pk
        //     FROM
        //     torder_hd AS a
        //     INNER JOIN torder_inout AS b ON a.XVOrderDocNo = b.XVOrderDocNo
        //     GROUP BY
        //     a.XVOrderDocNo,
        //     b.XIOrderTableCode
        // ";

        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );
        print json_encode($data);
    }

    public function showd($item1,$si)
    {
        // dd($item1,$si);
        return view('admin.planbook.detial1',[
            'item1' => $item1,
            'si' => $si
            ]);
    }

    public function detial1($item1,$si)
    {
        $sql="select * from torder_inout where ((XVOrderIn='$item1') and (XVStVkSize='$si')) order by XIIOID desc";
        // $sql="select * from torder_inout where (XVOrderIn='$item1')";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );
        // dd($data);
        print json_encode($data);
    }



    public function findsku(Request $request)
    {
        $sql="select * from torder_stockvk where XVStVkSKUin='$request->id'";
        $result = \DB::select($sql);
//        dd($result);
        return response()->json($result);
    }

    public function report()
    {
        // dd("Report Book");
        return view('admin.planbook.report');
    }

    public function reportpdf(Request $request)
    {
        // dd($request);
        $id =  Carbon::createFromFormat('d/m/Y', $request->XDIODate)->format('Y-m-d');
        // $XDIODate =  Carbon::createFromFormat('d/m/Y', $request->XDIODate)->format('Y-m-d');
        // dd($id);

        $sql="select * from torder_inout where (XIIOSta='16') and (cast(XTWhenCreate as date)='".$id."') order by XVIOSKUin";
        $res_bc = \DB::select($sql);
        // //dd($res_bc);

        $pdf = PDF::loadView('admin.planbook.reportpdf', ['res_bc'=>$res_bc,'date'=>$id]);

        return $pdf->stream();

    }

    public function dedit($id)
    {
        // dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        //dd($data);
        return view('admin.planbook.dedit',['data' => $data]);

    }

    public function udetial(Request $request,$id){
        // dd($request);
        // dd($id);
        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=', $id)
                ->update(
                    [
                        'XIIONum'           => $request->XIIONum,
                        // 'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/planbook/balance')->with('message','บันทึกสำเร็จ');
    }

    public function dele($id)
    {
        // dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->delete();
        return view('admin.planbook.index');
    }


    public function dele2($id)
    {
        // dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->delete();
        return view('admin.planbook.balance');
    }

}
