<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\TMtotalsew;
use Auth;
use PDF;
/**
 * Class DashboardController.
 */
class QcInController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //dd('datein');
        return view('admin.qcin.index');
    }

    public function inputqc()
    {
        // dd("inQQQ");
        return view('admin.qcin.index2');
    }


    public function create($id)
    {
        // dd('Qc New Create');
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        return view('admin.qcin.create',['data' => $data]);
    }

    public function edit($id)
    {
        // dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        return view('admin.qcin.edit',['data' => $data]);
    }

    public function store(Request $request,$id)
    {
        //dd($request);
        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');

        DB::beginTransaction();
        try {
                DB::table('torder_inout')->insert(
                    [
                        'XDIODate'          => $XDIODate,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XIIOSta'           => "6",
                        'XIIOinorout'       => "1",
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }

        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=',$id)
                ->update(
                    [
                        'XIIOinorout'       => "0",
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/qcin')->with('message','บันทึกสำเร็จ');


    }

    public function update(Request $request,$id){
        // dd($request);
        // $XIIOinoutedit = $request->XIIOinoutedit == 'true'? 0:1;
        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');

        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=',$id)
                ->update(
                    [
                        'XDIODate'          => $XDIODate,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XIIOinorout'       => "0",
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/qcin')->with('message','บันทึกสำเร็จ');


    }


    public function getdata()
    {
        //dd("testvkG");
        // $sql="select * from torder_inout where (XIIOinorout='1') and (XIIOSta='5') order by XDIODate desc";
        $sql="select * from torder_inout where XIIOSta='6' order by XIIOID desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

    public function getdata2()
    {
        //dd("testvkG");
        // $sql="select * from torder_inout where (XIIOinorout='1') and (XIIOSta='5') order by XDIODate desc";
        $sql="select * from torder_inout where ((XIIOSta='5')and(XIIOinorout='1')) order by XIIOID desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

    public function report()
    {
        //dd("Report Fg");
        return view('admin.qcin.report');
    }

    public function reportpdf(Request $request)
    {
        $id =  Carbon::createFromFormat('d/m/Y', $request->XDIODate)->format('Y-m-d');

        $sql="select * from torder_inout where (XIIOSta='6') and (cast(XDIODate as date)='".$id."') order by XVIOSKUin";
        $res_bc = \DB::select($sql);
        $pdf = PDF::loadView('admin.qcin.reportpdf', ['res_bc'=>$res_bc,'date'=>$id]);

        return $pdf->stream();

    }

    public function dele($id)
    {
        //dd($id);
        // $data = DB::table('torder_inout')->where('XIIOID','=',$id)->delete();
        // return view('admin.scanfg.index');
    }


}
