<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\TMtotalsew;
use Auth;
use PDF;
/**
 * Class DashboardController.
 */
class QcReController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        // dd('qcre');
        return view('admin.qcre.index');


    }

    public function create()
    {
        //dd('FG New Create');
        return view('admin.qcre.create');
    }

    public function edit($id)
    {
        //dd($id);
        //return view('admin.ppedate.showedit');
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        //dd($data);
        return view('admin.qcre.edit',['data' => $data]);
    }

    public function store(Request $request)
    {
        // dd($request);
        // dd('Save');
        $XDIODate=Carbon::createFromFormat('d/m/Y', $request->XDIODate)->format('Y-m-d');
        //$XIIOinoutedit = $request->XIIOinoutedit == 'true'? 0:1;
        //dd($XIIOinoutedit);

        DB::beginTransaction();
        try {
                DB::table('torder_inout')->insert(
                    [
                        'XIIONum'           => $request->XIIONum,
                        'XDIODate'          => $XDIODate,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XIIOSta'           => "12",
                        'XIIOinorout'       => "1",
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/qcre')->with('message','บันทึกสำเร็จ');

        //return view('admin.scanpackking.create');
    }

    public function update(Request $request,$id){
        // dd($request);
        // dd('Save2');
        $XDIODate=Carbon::createFromFormat('d/m/Y', $request->XDIODate)->format('Y-m-d');
        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=',$id)
                ->update(
                    [
                        'XIIONum'           => $request->XIIONum,
                        'XDIODate'          => $XDIODate,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/qcre')->with('message','บันทึกสำเร็จ');


    }


    public function getdata()
    {
        $sql="select * from torder_inout where XIIOSta='12' order by XIIOID desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

    public function findsku(Request $request)
    {
        $sql="select * from torder_stockvk where XVStVkSKUin='$request->id'";
        $result = \DB::select($sql);
//        dd($result);
        return response()->json($result);
    }

    public function report()
    {
        //dd("Report Fg");
        return view('admin.qcre.report');
    }

    public function reportpdf(Request $request)
    {
        // dd($request);
        // $id =  Carbon::createFromFormat('d/m/Y', $request->XDIODate)->format('Y-m-d');
        //dd($id);
        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');
        // dd($dateStart);
        $sql="select * from torder_inout
                WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='12'
                order by XDIODate";

        $res_bc = \DB::select($sql);
        // dd($res_bc);

        $pdf = PDF::loadView('admin.qcre.reportpdf', ['res_bc'=>$res_bc]);

        return $pdf->stream();

    }

    public function dele($id)
    {
        //dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->delete();
        return view('admin.qcre.index');
    }


}
