<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyRoleRequest;
use App\Http\Requests\StoreRoleRequest;
use App\Http\Requests\UpdateRoleRequest;
use Illuminate\Http\Request;
use App\Permission;
use App\Role;

class RmenuController extends Controller
{
    public function index()
    {

        abort_unless(\Gate::allows('role_access'), 403);

        // $roles = Role::all();
        $roles =\DB::table('roles') ->get();
        $role_user = \DB::table('role_user')
                        ->SELECT(
                            'user_id',
                            'role_id',
                            'name'
                        )
                        ->LEFTJOIN('users','role_user.user_id','=','users.id')
                        ->get();
        // dd($roles);
        return view('admin.usermenu.index',compact('roles'),compact('role_user'));
    }

    public function create()
    {


    }

    public function store(StoreRoleRequest $request)
    {


    }

    public function edit(string $rol_id)
    {
        abort_unless(\Gate::allows('role_edit'), 403);

        $role_user = \DB::table('role_user')
                        ->SELECT(
                            'user_id',
                            'role_id',
                            'roles.title',
                            'users.name'
                        )
                        ->LEFTJOIN('users','role_user.user_id','=','users.id')
                        ->LEFTJOIN('roles','role_user.role_id','=','roles.id')
                        ->where('role_user.role_id','=',$rol_id)
                        ->whereNotNull('users.id')
                        ->get();

        $users = \DB::table('users')
                        ->SELECT(
                            'id',
                            'name',
                        )
                        ->get();


        $roles =  \DB::table('roles')
                        ->SELECT(
                            'id',
                            'title',
                        )
                        ->where('id','=',$rol_id)
                        ->first();

        return view('admin.usermenu.edit',['role_user' => $role_user,'users' => $users,'roles' => $roles]);
    }

    public function update(Request $request, string $rol_id)
    {
        abort_unless(\Gate::allows('role_edit'), 403);

        \DB::table('role_user')->where('role_id','=',$rol_id)->delete();
        if(isset($request->users)){
        foreach($request->users as $u){
               \DB::table('role_user')
                    ->insert(
                                [
                                    'user_id' =>  $u,
                                    'role_id' =>  $rol_id,
                                ]
                        );
       }
    }

        return redirect()->route('admin.usermenu');

    }

    public function getdata()
    {

        $sql="select * from users";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }



}
