<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\TMtotalsew;
use Auth;
use PDF;
/**
 * Class DashboardController.
 */
class ScanFGController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //dd('datein');
        return view('admin.scanfg.index');


    }

    public function create()
    {
        //dd('FG New Create');
        //return view('admin.ppe.create');
        return view('admin.scanfg.create');
    }

    public function edit($id)
    {
        //dd($id);
        //return view('admin.ppedate.showedit');
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        //dd($data);
        return view('admin.scanfg.edit',['data' => $data]);
    }

    public function store(Request $request)
    {
        // dd($request);

        //$XDIODate=Carbon::createFromFormat('d/m/Y', now())->format('Y-m-d');
        $XIIOinoutedit = $request->XIIOinoutedit == 'true'? 0:1;
        //dd($XIIOinoutedit);

        DB::beginTransaction();
        try {
                DB::table('torder_inout')->insert(
                    [
                        'XDIODate'          => DB::Raw('now()'),
                        'XIStVkID'          => $request->XIStVkID,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XIIOSta'           => "5",
                        'XIIOinorout'       => "1",
                        'XIIOinoutedit'     => $XIIOinoutedit,
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/scannfg')->with('message','บันทึกสำเร็จ');

        //return view('admin.scanpackking.create');
    }

    public function update(Request $request,$id){
        // dd($request);
        $XIIOinoutedit = $request->XIIOinoutedit == 'true'? 0:1;
        $XIIOinorout = $request->XIIOinorout == 'true'? 1:0;
        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=',$id)
                ->update(
                    [
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XIIOinorout'       => $XIIOinorout,
                        'XIIOinoutedit'     => $XIIOinoutedit,
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/scannfg')->with('message','บันทึกสำเร็จ');


    }


    public function getdata()
    {
        //dd("testvkG");
        // $sql="select * from torder_inout where (XIIOinorout='1') and (XIIOSta='5') order by XDIODate desc";
        $sql="select * from torder_inout where XIIOSta='5' order by XIIOID desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

    public function findsku(Request $request)
    {
        $sql="select * from torder_stockvk where XVStVkSKUin='$request->id'";
        $result = \DB::select($sql);
//        dd($result);
        return response()->json($result);
    }

    public function reportfg()
    {
        //dd("Report Fg");
        return view('admin.scanfg.reportfg');
    }

    public function reportpdffg(Request $request)
    {
        //dd($request);
        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');
        // dd($dateStart);
        $sql="select * from torder_inout
                WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='5'
                order by XDIODate";

                $res_bc = \DB::select($sql);
        //dd($res_bc);

        $pdf = PDF::loadView('admin.scanfg.reportpdffg', ['res_bc'=>$res_bc]);

        return $pdf->stream();

    }

    public function dele($id)
    {
        //dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->delete();
        return view('admin.scanfg.index');
    }


}
