<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\TMtotalsew;
use Auth;
use PDF;
/**
 * Class DashboardController.
 */
class ScanPackController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //dd('Pack');
        return view('admin.scanpack.index');


    }

    public function create()
    {
        //dd('FG New Create');
        return view('admin.scanpack.create');
    }

    public function edit($id)
    {
        //dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        // //dd($datainout->XVIOSKUin);
        $datanum = DB::table('torder_stockvk')->where('XVStVkSKUin','=',$data->XVIOSKUin)->first();
        // dd($datanum);
        // if ($datanum = null) {
        //     $datanum=0;
        // }
        return view('admin.scanpack.edit',['data' => $data,'datanum'=>$datanum]);
    }

    public function store(Request $request)
    {
        //dd($request);

        //$XDIODate=Carbon::createFromFormat('d/m/Y', now())->format('Y-m-d');

        $numstock=($request->XIStVkNum)+($request->XIIONum);
        //dd($numstock);
        DB::beginTransaction();
        try {
                DB::table('torder_inout')->insert(
                    [
                        'XDIODate'          => DB::Raw('now()'),
                        'XIStVkID'          => $request->XIStVkID,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XIIOSta'           => "15",
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();

            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }

            // DB::beginTransaction();
            // try {
            //         DB::table('torder_stockvk') ->where('XVStVkSKUin','=',$request->XVIOSKUin)
            //         ->update(
            //             [
            //                 'XIStVkNum'          => $numstock,
            //             ]
            //         );
            //     DB::commit();
            //     } catch (\Exception $e) {
            //     //echo $e;
            //     DB::rollBack();
            //         abort(500, 'Internal error');
            //     }

            return redirect('admin/scanpack')->with('message','ระบบเพิ่ม Stock สำเร็จ');

        //return view('admin.scanpackking.create');
    }
    public function update(Request $request,$id){
        //dd($request);
        $numstock = ($request->XIStVkNum)+($request->XIIONum);
        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=',$id)
                ->update(
                    [
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }

            DB::beginTransaction();
            try {
                    DB::table('torder_stockvk') ->where('XVStVkSKUin','=',$request->XVStVkSKUin)
                    ->update(
                        [
                            'XIStVkNum'          => $numstock,
                        ]
                    );
                DB::commit();
                } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                    abort(500, 'Internal error');
                }

            return redirect('admin/scanpack')->with('message','ระบบ แก้ไข Stock สำเร็จ');


    }


    public function getdata()
    {
        $sql="select * from torder_inout where XIIOSta='15' order by XDIODate desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

    public function findsku(Request $request)
    {
        $sql="select * from torder_stockvk where XVStVkSKUin='$request->id'";
        $result = \DB::select($sql);
//        dd($result);
        return response()->json($result);
    }

    public function report()
    {
        //dd("Report PK");
        return view('admin.scanpack.report');
    }


    public function reportpdf(Request $request)
    {
        //dd($request);
        $id =  Carbon::createFromFormat('d/m/Y', $request->XDIODate)->format('Y-m-d');
        // //dd($id);

        $sql="select * from torder_inout where (XIIOSta='15') and (cast(XDIODate as date)='".$id."') order by XVIOSKUin";
        $res_bc = \DB::select($sql);
        // //dd($res_bc);

        $pdf = PDF::loadView('admin.scanpack.reportpdf', ['res_bc'=>$res_bc,'date'=>$id]);

        return $pdf->stream();

    }

    public function dele($id)
    {
        //dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->delete();
        return view('admin.scanpack.index');
    }



}
