<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use PDF;

/**
 * Class DashboardController.
 */
class ScanPackkingController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.scanpackking.index');
    }

    public function create()
    {
        return view('admin.scanpackking.create');
    }

    public function edit()
    {
        return view('admin.scanpackking.edit');
    }

    public function update(Request $request)
    {
        // dd($XVOrderDocNo);
        $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->where('XDDateInNoQC', $request->location)->get();
        // $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode','3220191100010002')->where('XVOrderBLocation','4')->get();
        // dd(count($chk_dup));
        if (count($chk_dup) > 0) {
            return response()->json([
                'success' => '2',
                'order_no' => '',
                'size' => ''
            ]);
        }
        // dd();
        // dd($request->is_repair);


    }

    public function report()
    {
        return view('admin.scanpackking.report');
    }

    public function reportPdf(Request $request)
    {
        $dateStart = Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd = Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');

        //  dd($request->XIAddBlenchCode);
        // ตาลแก้
        $sql = "select torder_hd.XVOrderDocNo,XVOrderBSize,count(XVOrderBarNo) as count_all,torder_hd.XVOrderDetail,torder_hd.XVOrderIn
                    from torder_bc
                    INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                    WHERE cast(XDDateInPack as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XVOrderBLocation='13'
                    GROUP BY XVOrderIn,XVOrderBSize
                    ORDER BY XVOrderIn,XVOrderBSize";

        $res_bc = \DB::select($sql);

        $res = [
            'res_bc' => $res_bc,
            'dateStart' => $request->dateStart,
            'dateEnd' => $request->dateEnd,
        ];

        // dd($request);

        $pdf = PDF::loadView('admin.scanpackking.report_pdf', compact('res'));

        return $pdf->stream();
    }

    public function stockshowDetail($date, $size,$orderin)
    {
        return view('admin.scanpackking.show', [
            'date' => $date,
            'size' => $size,
            'orderIn'=>$orderin
        ]);
    }

    public function getData(Request $request)
    {
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=', $request->location)
            ->groupBy(\DB::raw('DATE_FORMAT(XDDateInPack,\'%Y-%m-%d\')'))
            ->groupBy('XVOrderBSize')
            ->groupBy('XVOrderIn')
            ->select(\DB::raw('DATE_FORMAT(XDDateInPack,\'%Y-%m-%d\') as XDDate'),
                'XVOrderIn','XVOrderBSize',
                'XVOrderDetail',\DB::raw('COUNT(XVOrderBCode) as XISizeCount'))
            ->orderBy('XDDateInPack','desc');
        // dd($request->location);
        // dd($sql);

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function stockshowMyDetail(Request $request){
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=',$request->location)
            ->where(\DB::raw('DATE_FORMAT(XDDateInPack,\'%Y-%m-%d\')'),'=',$request->date)
            ->where('XVOrderBSize','=',$request->size)
            ->where('XVOrderIn','=',$request->orderIn)
            ->select(\DB::raw('DATE_FORMAT(XDDateInPack,\'%Y-%m-%d\') as XDDate'),
                'XVOrderBCode','XVOrderIn',
                'XVOrderDetail','XVOrderBSize')
            ->orderBy('XVOrderBCode','ASC');
// dd($sql);
        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

}
