<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use PDF;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;

/**
 * Class DashboardController.
 */
class ScanProductInBoxController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.scanproductinbox.index');
    }

    public function create($boxno = "")
    {
        // dd($docno);
        return view('admin.scanproductinbox.create', ['boxno' => $boxno]);
    }

    public function edit($boxno, $sizecode, $itemno, $desc)
    {
        $res = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_hd.XVOrderDocNo', 'torder_bc.XVOrderDocNo')
            ->select('XVBoxCode', 'torder_hd.XVOrderDocNo', 'XVOrderMItemNo', 'XVOrderBCode')
            ->where('XVBoxCode', $boxno)
            ->where('XVOrderBSize', $sizecode)
            ->where('XVOrderMItemNo', $itemno)
            ->where('XVOrderBLocation', '9')
            ->get();

        // dd($res);

        return view('admin.scanproductinbox.edit', ['datas' => $res, 'desc' => $desc, 'boxno' => $boxno]);
    }

    public function update(Request $request)
    {
        $chk_dup = \DB::table('torder_bc')
            ->where('XVOrderBCode', $request->barcode)
            ->where('XVOrderBLocation', $request->location)
            ->get();

        if (count($chk_dup) > 0) {
            return response()->json([
                'success'     => '2',
                'message'    => "Scan ซ้ำมีข้อมูลแล้ว",
            ]);
        }

        $chk_exist = \DB::select("SELECT torder_bc.*
                                FROM torder_hd
                                INNER JOIN torder_bc ON torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                                INNER JOIN torder_box ON torder_box.XVItemNo  = torder_hd.XVOrderMItemNo
                                            AND torder_box.XVBoxCode = '" . $request->boxCode . "'
                                            AND torder_box.XVSize = torder_bc.XVOrderBSize
                                WHERE 1=1
                                AND XVOrderBCode = '" . $request->barcode . "'
                                AND XVOrderBLocation <> '9'");

        if (count($chk_exist) == 0) {
            return response()->json([
                'success'     => '2',
                'message'    => "ไม่พบรายการสินค้าในใบกำกับกล่อง",
            ]);
        }

        $status = 1;
        \DB::table('torder_bc')
            ->where('XVOrderBCode', $request->barcode)
            ->update(
                [
                    'XDDateInBox' => date("Y-m-d H:i:s"),
                    'XVOrderBLocation' => $request->location,
                    'XVBoxCode' => $request->boxCode,
                    'XIUser_id' => \Auth::user()->id,
                    'XVWhoEdit' => \Auth::user()->name,
                    'XTWhenEdit' => date("Y-m-d H:i:s"),
                ]
            );

        $Boxs = DB::select("SELECT torder_box.XVItemNo as ItemNo
                            ,torder_box.*,QtyPack
                            FROM torder_box
                            LEFT JOIN (
                                        SELECT  torder_hd.XVOrderMItemNo,XVOrderBSize,COUNT(XVOrderBSize) as QtyPack
                                        FROM torder_bc
                                        INNER JOIN torder_hd ON torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                                        WHERE XVOrderBLocation ='9'
                                        AND XVBoxCode = '" . $request->boxCode . "'
                                        GROUP BY torder_bc.XVOrderBSize,torder_hd.XVOrderMItemNo
                            ) as bc ON torder_box.XVSize = bc.XVOrderBSize AND bc.XVOrderMItemNo = torder_box.XVItemNo
                            WHERE XVBoxCode = '" . $request->boxCode . "'");


        if (!$Boxs) {
            $status = 0;
        }

        return response()->json([
            'success'     => $status,
            'XVOrderBCode'    => @$request->barcode,
            'XVBoxCode'        => @$request->boxCode,
            'Boxs'        => @$Boxs
        ]);
    }

    public function GetByBox(Request $request)
    {
        $status = 1;
        $res = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_hd.XVOrderDocNo', 'torder_bc.XVOrderDocNo')
            ->select('XVBoxCode', 'torder_hd.XVOrderDocNo', 'XVOrderMItemNo', 'XVOrderBCode')
            ->where('XVBoxCode', $request->boxCode)
            ->where('XVOrderBLocation', $request->location)
            // ->groupBy('XVBoxCode', 'torder_hd.XVOrderDocNo', 'XVOrderMItemNo', 'XVOrderBCode')
            ->get();
        if (!$res) {
            $status = 0;
        }


        $Boxs = DB::select("SELECT torder_box.XVItemNo as ItemNo
                            ,torder_box.*,QtyPack
                            FROM torder_box
                            LEFT JOIN (
                                        SELECT  torder_hd.XVOrderMItemNo,XVOrderBSize,COUNT(XVOrderBSize) as QtyPack
                                        FROM torder_bc
                                        INNER JOIN torder_hd ON torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                                        WHERE XVOrderBLocation ='9'
                                        AND XVBoxCode = '" . $request->boxCode . "'
                                        GROUP BY torder_bc.XVOrderBSize,torder_hd.XVOrderMItemNo
                            ) as bc ON torder_box.XVSize = bc.XVOrderBSize AND bc.XVOrderMItemNo = torder_box.XVItemNo
                            WHERE XVBoxCode = '" . $request->boxCode . "'");



        // dd($Boxs);

        return response()->json([
            'success'     => $status,
            'datas'    => @$res,
            'Boxs' => @$Boxs
        ]);
    }


    public function Delete(Request $request)
    {
        // dd($request);
        $status = 1;
        \DB::table('torder_bc')
            ->where('XVOrderBCode', $request->barcode)
            ->update(
                [
                    'XDDateInBox' => '',
                    'XVOrderBLocation' => '6',
                    'XIUser_id' => '',
                    'XVBoxCode' => '',
                    'XVWhoEdit' => \Auth::user()->name,
                    'XTWhenEdit' => date("Y-m-d H:i:s"),
                ]
            );


        return response()->json([
            'success'     => $status
        ]);
    }
    public function getData(Request $request)
    {
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');

        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=',$request->location)
            ->groupBy(\DB::raw('DATE_FORMAT(XDDateInBox,\'%Y-%m-%d\')'))
            ->groupBy('XVOrderBSize')
            ->groupBy('XVOrderIn')
            ->select(\DB::raw('DATE_FORMAT(XDDateInBox,\'%Y-%m-%d\') as XDDate'),
                'XVOrderIn','XVOrderBSize',
                'XVOrderDetail',\DB::raw('COUNT(XVOrderBCode) as XISizeCount'))
            ->orderBy('XDDateInBox','desc');

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function scanproductinboxshowDetail($date,$size,$orderin){
        return view('admin.scanproductinbox.show',[
            'date'=>$date,
            'size'=>$size,
            'orderIn'=>$orderin
        ]);
    }
    public function scanproductinboxfindDetail(Request $request){
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

//        dd($request->orderIn);
        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=',$request->location)
            ->where(\DB::raw('DATE_FORMAT(XDDateInBox,\'%Y-%m-%d\')'),'=',$request->date)
            ->where('XVOrderBSize','=',$request->size)
            ->where('XVOrderIn','=',$request->orderIn)
            ->select(\DB::raw('DATE_FORMAT(XDDateInBox,\'%Y-%m-%d\') as XDDate'),
                'XVOrderBCode','XVOrderIn',
                'XVOrderDetail','XVOrderBSize')
            ->orderBy('XVOrderBCode','ASC');
// dd($sql);
        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }
}
