<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\TMblench;
use App\TMbranch;
use Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use PDF;

/**
 * Class DashboardController.
 */
class ScanSendBleachController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $res_branch = TMbranch::Where('XIBranchCode', Auth::user()->XIBranchCode)->first();

        return view('admin.scansendbleach.index', ['datas' => $res_branch]);
    }

    public function create()
    {
        return view('admin.scansendbleach.create');
    }

    public function edit()
    {
        return view('admin.scansendbleach.edit');
    }

    public function report()
    {
        return view('admin.scansendbleach.report');
    }

    public function reportPdf(Request $request)
    {
        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');

//          dd($request->XIAddBlenchCode);
        // ตาล
        if (Auth::user()->XIBranchCode == null) {
            $sql = "select torder_hd.XVOrderDocNo,XVOrderBSize,count(XVOrderBarNo) as count_all,torder_hd.XVOrderDetail,torder_hd.XVOrderIn,XVbranchName
                    from torder_bc
                    INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                    INNER JOIN tmbranch on tmbranch.XIBranchCode = torder_bc.XIBranchCode_B
                    WHERE cast(XDDateInBlench as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XVOrderBLocation='3'
                    GROUP BY XVOrderIn,XVOrderBSize
                    ORDER BY XVbranchName,XDDateInBlench DESC,XVOrderIn,XVOrderBSize";
        }else{
            $sql = "select torder_hd.XVOrderDocNo,XVOrderBSize,count(XVOrderBarNo) as count_all,torder_hd.XVOrderDetail,torder_hd.XVOrderIn,XVbranchName
                    from torder_bc
                    INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                    INNER JOIN tmbranch on tmbranch.XIBranchCode = torder_bc.XIBranchCode_B
                    WHERE cast(XDDateInBlench as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XVOrderBLocation='3'
                    AND XIBranchCode_B = '" . Auth::user()->XIBranchCode . "'
                    GROUP BY XVOrderIn,XVOrderBSize
                    ORDER BY XVbranchName,XDDateInBlench DESC,XVOrderIn,XVOrderBSize";
        }


        $res_bc = \DB::select($sql);
//         dd($sql,$res_bc);
        // $blenchs      = TMblench::all();
//        $blenchs     = TMblench::where('XIBlenchCode', Auth::user()->XIBranchCode)->first();

        $res = [
            'res_bc'     => $res_bc,
            'dateStart'     => $request->dateStart,
            'dateEnd'     => $request->dateEnd,
//            'blenchs'     => $blenchs->XVBlenchName
        ];

        // dd($request);

        $pdf = PDF::loadView('admin.scansendbleach.report_pdf', compact('res'));

        return $pdf->stream();
    }

    public function sendReport()
    {

        return view('admin.scansendbleach.sendReport');
    }

    public function sendReportPdf(Request $request)
    {


        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');

        // dd($dateStart, $dateEnd);
//          dd($request->XIAddBlenchCode);

        if (Auth::user()->XIBranchCode == null) {
            $sql = "select torder_hd.XVOrderDocNo,XVOrderBSize,count(XVOrderBarNo) as count_all,torder_hd.XVOrderDetail,torder_hd.XVOrderIn,XVbranchName
                    from torder_bc
                    INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                    INNER JOIN tmbranch on tmbranch.XIBranchCode = torder_bc.XIBranchCode_B
                    WHERE cast(XDDateInThread as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XVOrderBLocation='4'
                    GROUP BY XVOrderIn,XVOrderBSize
                    ORDER BY XVbranchName,XDDateInThread DESC,XVOrderIn,XVOrderBSize";
        }else{
            $sql = "select torder_hd.XVOrderDocNo,XVOrderBSize,count(XVOrderBarNo) as count_all,torder_hd.XVOrderDetail,torder_hd.XVOrderIn,XVbranchName
                    from torder_bc
                    INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                    INNER JOIN tmbranch on tmbranch.XIBranchCode = torder_bc.XIBranchCode_B
                    WHERE cast(XDDateInThread as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XVOrderBLocation='4'
                    AND XIBranchCode_B = '" . Auth::user()->XIBranchCode . "'
                    GROUP BY XVOrderIn,XVOrderBSize
                    ORDER BY XVbranchName,XDDateInThread DESC,XVOrderIn,XVOrderBSize";
        }

        $res_bc = \DB::select($sql);
        // dd($res_bc);

        // $res_bc = \DB::table("torder_bc")->whereRaw(" cast(XDDateInBlench as date) Between '" . $dateStart . "' and '" . $dateEnd . "'")


        $res = [
            'res_bc'     => $res_bc,
            'dateStart'     => $request->dateStart,
            'dateEnd'     => $request->dateEnd,
        ];

        // return view('admin.scansendbleach.report_pdf', compact('res'));

        $pdf = PDF::loadView('admin.scansendbleach.sendReport_pdf', compact('res'));

        return $pdf->stream();
    }
    public function update(Request $request)
    {
        // dd($XVOrderDocNo);
        $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->where('XVOrderBLocation', $request->location)->get();
        // $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode','3220191100010002')->where('XVOrderBLocation','4')->get();
        // dd(count($chk_dup));
        if (count($chk_dup) > 0) {
            return response()->json([
                'success'     => '2',
                'order_no'    => '',
                'size'        => ''
            ]);
        }
        // dd();




        $res = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->first();
        if (!$res) {
            $status = 0;
        }
        // dd($res);

        return response()->json([
            'success'     => $status,
            'order_no'    => @$res->XVOrderDocNo,
            'size'        => @$res->XVOrderBSize
        ]);
    }

    public function reportBalance()
    {
        // ตาล
//        dd(Auth::user()->XIBranchCode);
        if (Auth::user()->XIBranchCode == null) {
            $res = DB::select("SELECT
                            torder_hd.XVOrderDocNo,torder_hd.XVOrderDetail,XVOrderMItemNo,XVOrderBSize,count(*) as CountAll
                            FROM torder_bc
                            INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                            WHERE XVOrderBLocation = '3'
                            GROUP BY torder_hd.XVOrderDocNo,XVOrderBSize");
        } else {
            $res = DB::select("SELECT
                            torder_hd.XVOrderDocNo,torder_hd.XVOrderDetail,XVOrderMItemNo,XVOrderBSize,count(*) as CountAll
                            FROM torder_bc
                            INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                            WHERE XVOrderBLocation = '3'
                            AND XIBranchCode_B = '" . Auth::user()->XIBranchCode . "'

                            GROUP BY torder_hd.XVOrderDocNo,XVOrderBSize");
        }



        return view('admin.scansendbleach.reportBalance', ['datas' => $res]);
    }

    public function reportBalanceDetail($docno, $sizecode)
    {
        $res = DB::select("SELECT
                            torder_hd.XVOrderDocNo,torder_hd.XVOrderDetail,XVOrderMItemNo,XVOrderBSize,XVOrderBCode
                            FROM torder_bc
                            INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                            WHERE XVOrderBLocation = '3'
                            AND torder_hd.XVOrderDocNo ='$docno'
                            AND XVOrderBSize ='$sizecode'
                            ");


        return view('admin.scansendbleach.reportBalanceDetail', ['datas' => $res]);
    }

    public function getData(Request $request)
    {

//        $res_branch = TMbranch::Where('XIBranchCode', \Auth::user()->XIBranchCode)->first();
//
//        dd($request->all());
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;


        $sql = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_bc.XVOrderDocNo', '=', 'torder_hd.XVOrderDocNo')
            ->join('tmbranch','torder_bc.XIBranchCode_B','=','tmbranch.XIBranchCode')
            ->where('XVOrderBLocation', '=', $request->location)
            ->groupBy(\DB::raw('DATE_FORMAT(XDDateInThread,\'%Y-%m-%d\')'))
            ->groupBy('XVOrderBSize')
            ->groupBy('XVOrderIn')
            ->select(\DB::raw('DATE_FORMAT(XDDateInThread,\'%Y-%m-%d\') as XDDate'),
                'XVOrderIn','XVOrderBSize',
                'XVOrderDetail',\DB::raw('COUNT(XVOrderBCode) as XISizeCount'),'XVBranchName')
            ->orderBy('XDDateInThread','desc');
        // dd($request->location);
        // dd($sql);
        if($request->branch != null){
            $sql->where('XIBranchCode_B','=',$request->branch);
        }
        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function stockshowDetail($date, $size,$orderin)
    {
        return view('admin.scansendbleach.show', [
            'date' => $date,
            'size' => $size,
            'orderIn'=>$orderin
        ]);
    }

    public function stockshowMyDetail(Request $request){
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

//        dd($request->orderIn);
        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=',$request->location)
            ->where(\DB::raw('DATE_FORMAT(XDDateInThread,\'%Y-%m-%d\')'),'=',$request->date)
            ->where('XVOrderBSize','=',$request->size)
            ->where('XVOrderIn','=',$request->orderIn)
            ->select(\DB::raw('DATE_FORMAT(XDDateInThread,\'%Y-%m-%d\') as XDDate'),
                'XVOrderBCode','XVOrderIn',
                'XVOrderDetail','XVOrderBSize')
            ->orderBy('XVOrderBCode','ASC');
// dd($sql);
        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }
}
