<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use PDF;

/**
 * Class DashboardController.
 */
class ScanStockFGController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //dd('pass');
        return view('admin.scanstockfg.index_new');
//        return view('admin.scanstockfg.index');
    }

    public function create()
    {
        return view('admin.scanstockfg.create');
    }

    public function showin()
    {
        return view('admin.scanstockfg.index');
    }

    public function edit()
    {
        return view('admin.scanstockfg.edit');
    }

    public function update(Request $request)
    {
        // dd($XVOrderDocNo);
        $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->where('XVOrderBLocation', $request->location)->get();
        // $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode','3220191100010002')->where('XVOrderBLocation','4')->get();
        // dd(count($chk_dup));
        if (count($chk_dup) > 0) {
            return response()->json([
                'success'     => '2',
                'order_no'    => '',
                'size'        => ''
            ]);
        }
        // dd();
    }

    public function report()
    {
        return view('admin.scanstockfg.report');
    }

    public function reportPdf(Request $request)
    {
        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');
        // $timeStart = Carbon::createFromFormat('H:i:ss', $request->timeStart)->format('H:i:ss');
        // $timeEnd = Carbon::createFromFormat('H:i:ss', $request->timeEnd)->format('H:i:ss');
        // dd($dateStart, $dateEnd);
        // dd($timeStart,$timeEnd);
        $sql = "select torder_hd.XVOrderDocNo,XVOrderBSize,count(XVOrderBarNo) as count_all,torder_hd.XVOrderDetail,torder_hd.XVOrderIn
                    from torder_bc
                    INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                    WHERE cast(XDDateInStockFG as date) Between '" .$dateStart. "' and '" .$dateEnd. "' and XVOrderBLocation='5'
                    GROUP BY XVOrderIn,XVOrderBSize
                    ORDER BY XVOrderIn,XVOrderBSize";
        // $sql = "select torder_hd.XVOrderDocNo,XVOrderBSize,count(XVOrderBarNo) as count_all,torder_hd.XVOrderDetail,torder_hd.XVOrderIn
        //             from torder_bc
        //             INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
        //             WHERE cast(XDDateInStockFG as datetime) Between '".$dateStart.' '.$request->timeStart."' and '".$dateEnd.' '.$request->timeEnd. "' and XVOrderBLocation='5'
        //             GROUP BY XVOrderIn,XVOrderBSize
        //             ORDER BY XVOrderIn,XVOrderBSize";
        $res_bc = \DB::select($sql);
        // dd($res_bc);
        $res = [
            'res_bc'     => $res_bc,
            'dateStart'     => $request->dateStart,
            'dateEnd'     => $request->dateEnd,
            // 'timeStart' =>$request->timeStart,
            // 'timeEnd'=>$request->timeEnd

        ];

        $pdf = PDF::loadView('admin.scanstockfg.report_pdf', compact('res'));

        return $pdf->stream();
    }


    public function stockOnhandReport()
    {
        return view('admin.scanstockfg.reportOH');
    }

    public function stockOnhandReportPdf(Request $request)
    {

        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');

        // dd($dateStart, $dateEnd);
        $sql = "select torder_hd.XVOrderDocNo,XVOrderBSize,count(XVOrderBarNo) as count_all,torder_hd.XVOrderDetail,torder_hd.XVOrderIn
                    from torder_bc
                    INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                    WHERE cast(XDDateInStockOH as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XVOrderBLocation='13'
                    GROUP BY XVOrderIn,XVOrderBSize
                    ORDER BY XVOrderIn,XVOrderBSize";

        $res_bc = \DB::select($sql);
        $res = [
            'res_bc'     => $res_bc,
            'dateStart'     => $request->dateStart,
            'dateEnd'     => $request->dateEnd,


        ];

        $pdf = PDF::loadView('admin.scanstockfg.reportOH_pdf', compact('res'));

        return $pdf->stream();
    }
    public function stockshowDetail($date,$size,$orderin){
        return view('admin.scanstockfg.show',[
            'date'=>$date,
            'size'=>$size,
            'orderIn'=>$orderin
        ]);

    }

    public function stockshowDetailNew($docno,$orderin,$size,$amount,$detail){
        return view('admin.scanstockfg.editdetail_new',[
            'docno'=>$docno,
            'size'=>$size,
            'orderIn'=>$orderin,
            'amount'=>$amount,
            'detail'=>$detail
        ]);
    }

    public function updateDetailNew(Request $request){
//        dd($request->all(),'hi mom');
        $date = Carbon::createFromFormat('d/m/Y', $request->XDDateInFk);
//        dd($date->format('Y-m-d'));
        $data = DB::table('torder_dt')
            ->where('XVOrderDocNo','=',$request->XVOrderDocNo)
            ->where('XVOrderDSize','=',$request->XVOrderDSize)
            ->where('XIOrderDTotalNum','=',$request->XIOrderDTotalNum)
            ->update([
                'XVOrderAdd'=>$request->XVOrderAdd,
                'XIOrderFk'=>$request->XIOrderFk,
                'XDDateInFk'=>$date->format('Y-m-d'),
            ]);
            return redirect('admin/scanstockfg');

    }
    public function getData_new(Request $request)
    {
//        $res_branch = TMbranch::Where('XIBranchCode', \Auth::user()->XIBranchCode)->first();
//
//        dd($request->all());
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = \DB::table('torder_dt')
            ->join('torder_hd', 'torder_dt.XVOrderDocNo', '=', 'torder_hd.XVOrderDocNo')
            ->select('torder_dt.XVOrderDocNo','torder_hd.XVOrderIn','torder_dt.XVOrderDSize',
                'torder_dt.XIOrderDTotalNum','XDDateInFk','XIOrderFk','XVOrderAdd','XVOrderDetail')
            ->orderBy('torder_dt.XVOrderDocNo','desc');

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );
        //dd($request,$AllData);

        print  json_encode($data);
    }
	public function getData(Request $request)
    {

//        $res_branch = TMbranch::Where('XIBranchCode', \Auth::user()->XIBranchCode)->first();
//
//        dd($request->all());
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;



        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=', $request->location)
            ->groupBy(\DB::raw('DATE_FORMAT(XDDateInStockFG,\'%Y-%m-%d\')'))
            ->groupBy('XVOrderIn')
            ->select(\DB::raw('DATE_FORMAT(XDDateInStockFG,\'%Y-%m-%d\') as XDDate'),
                'XVOrderIn','XVOrderBSize','XVBcNoSand',
                'XVOrderDetail',\DB::raw('COUNT(XVOrderBCode) as XISizeCount'))
            ->orderBy('XDDateInStockFG','desc');

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );
        //dd($request,$AllData);

        print  json_encode($data);
    }

    public function stockshowMyDetail(Request $request){
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

//        dd($request->orderIn);
        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=',$request->location)
            ->where(\DB::raw('DATE_FORMAT(XDDateInStockFG,\'%Y-%m-%d\')'),'=',$request->date)
            ->where('XVOrderBSize','=',$request->size)
            ->where('XVOrderIn','=',$request->orderIn)
            ->select(\DB::raw('DATE_FORMAT(XDDateInStockFG,\'%Y-%m-%d\') as XDDate'),
                'XVOrderBCode','XVOrderIn',
                'XVOrderDetail','XVOrderBSize')
            ->orderBy('XVOrderBCode','ASC');
// dd($sql);
        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

}
